/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm;

import io.github.toolfactory.jvm.util.CleanableSupplier;
import io.github.toolfactory.jvm.util.Properties;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface Driver
extends Closeable {
    public <D extends Driver> D init();

    public <T> T allocateInstance(Class<?> var1);

    public Class<?> defineHookClass(Class<?> var1, byte[] var2);

    public Class<?> getBuiltinClassLoaderClass();

    public Class<?> getClassLoaderDelegateClass();

    public Class<?> getClassByName(String var1, Boolean var2, ClassLoader var3, Class<?> var4);

    public MethodHandles.Lookup getConsulter(Class<?> var1);

    public <T> Constructor<T>[] getDeclaredConstructors(Class<T> var1);

    public Field[] getDeclaredFields(Class<?> var1);

    public Method[] getDeclaredMethods(Class<?> var1);

    public <T> T getFieldValue(Object var1, Field var2);

    public Package getPackage(ClassLoader var1, String var2);

    public Collection<URL> getResources(String var1, boolean var2, ClassLoader ... var3);

    public Collection<URL> getResources(String var1, boolean var2, Collection<ClassLoader> var3);

    public <T> T invoke(Object var1, Method var2, Object[] var3);

    public boolean isBuiltinClassLoader(ClassLoader var1);

    public boolean isClassLoaderDelegate(ClassLoader var1);

    public <T> T newInstance(Constructor<T> var1, Object[] var2);

    public CleanableSupplier<Collection<Class<?>>> getLoadedClassesRetriever(ClassLoader var1);

    public Map<String, ?> retrieveLoadedPackages(ClassLoader var1);

    public void setAccessible(AccessibleObject var1, boolean var2);

    public void setFieldValue(Object var1, Field var2, Object var3);

    public <T> T throwException(Throwable var1);

    public <T> T throwException(String var1, Object ... var2);

    @Override
    public void close();

    public static class InstantiateException
    extends RuntimeException {
        private static final long serialVersionUID = 558903509767014098L;

        public InstantiateException(Throwable cause) {
            super(cause);
        }
    }

    public static class InitializeException
    extends RuntimeException {
        private static final long serialVersionUID = -1351844562568567842L;

        public InitializeException(String message, Throwable cause) {
            super(message, cause);
        }

        public InitializeException(String message) {
            super(message);
        }
    }

    public static class Factory {
        private static Map<String, Constructor<? extends Driver>> driverConstructors;

        public static Driver getNew() {
            try {
                return Factory.getNewDefault().init();
            }
            catch (InitializeException exc) {
                try {
                    return Factory.getNewHybrid().init();
                }
                catch (InitializeException exc2) {
                    return Factory.getNewNative().init();
                }
            }
        }

        public static <D extends Driver> D getNew(String className) throws Throwable {
            return (D)((Driver)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }

        private static void setDriverClass(String name, String className) {
            try {
                Factory.setDriverClass(name, Class.forName(className));
            }
            catch (ClassNotFoundException exc) {
                throw new FactoryException(exc);
            }
        }

        private static void setDriverClass(String name, Class<?> cls) {
            try {
                driverConstructors.put(name, cls.getDeclaredConstructor(new Class[0]));
            }
            catch (NoSuchMethodException | SecurityException exc) {
                throw new FactoryException(exc);
            }
        }

        public static void setDefaultDriverClass(Class<? extends Driver> cls) {
            Factory.setDriverClass("defaultDriverClass", cls);
        }

        public static void setDefaultDriverClass(String className) {
            Factory.setDriverClass("defaultDriverClass", className);
        }

        public static void setHybridDriverClass(Class<? extends Driver> cls) {
            Factory.setDriverClass("hybridDriverClass", cls);
        }

        public static void setHybridDriverClass(String className) {
            Factory.setDriverClass("hybridDriverClass", className);
        }

        public static void setDynamicDriverClass(Class<? extends Driver> cls) {
            Factory.setDriverClass("dynamicDriverClass", cls);
        }

        public static void setDynamicDriverClass(String className) {
            Factory.setDriverClass("dynamicDriverClass", className);
        }

        public static void setNativeDriverClass(Class<? extends Driver> cls) {
            Factory.setDriverClass("nativeDriverClass", cls);
        }

        public static void setNativeDriverClass(String className) {
            Factory.setDriverClass("nativeDriverClass", className);
        }

        public static <D extends Driver> D getNewDefault() {
            try {
                return (D)driverConstructors.get("defaultDriverClass").newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exc) {
                throw new InstantiateException(exc);
            }
        }

        public static <D extends Driver> D getNewDynamic() {
            try {
                return (D)driverConstructors.get("dynamicDriverClass").newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exc) {
                throw new InstantiateException(exc);
            }
        }

        public static <D extends Driver> D getNewHybrid() {
            try {
                return (D)driverConstructors.get("hybridDriverClass").newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exc) {
                throw new InstantiateException(exc);
            }
        }

        public static <D extends Driver> D getNewNative() {
            try {
                return (D)driverConstructors.get("nativeDriverClass").newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exc) {
                throw new InstantiateException(exc);
            }
        }

        static {
            try {
                HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
                classLoaders.add(Factory.class.getClassLoader());
                classLoaders.add(Thread.currentThread().getContextClassLoader());
                java.util.Properties configuration = Properties.loadFromResourcesAndMerge("jvm-driver.properties", "priority-of-this-configuration-file", classLoaders.toArray(new ClassLoader[classLoaders.size()]));
                driverConstructors = new ConcurrentHashMap<String, Constructor<? extends Driver>>();
                Factory.setDriverClass("defaultDriverClass", configuration.getProperty("driver-factory.default-driver.class"));
                Factory.setDriverClass("dynamicDriverClass", configuration.getProperty("driver-factory.dynamic-driver.class"));
                Factory.setDriverClass("hybridDriverClass", configuration.getProperty("driver-factory.hybrid-driver.class"));
                Factory.setDriverClass("nativeDriverClass", configuration.getProperty("driver-factory.native-driver.class"));
            }
            catch (Throwable exc) {
                throw new FactoryException(exc);
            }
        }

        public static class FactoryException
        extends RuntimeException {
            private static final long serialVersionUID = 6332920978175279534L;

            public FactoryException(Throwable cause) {
                super(cause);
            }
        }
    }
}

