/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;

public interface ConstructorInvokeFunction
extends BiFunction<Constructor<?>, Object[], Object> {

    public static class ForJava9
    extends Abst {
        public ForJava9(Map<Object, Object> context) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            Class<?> nativeAccessorImplClass = Class.forName("jdk.internal.reflect.NativeConstructorAccessorImpl");
            Method method = nativeAccessorImplClass.getDeclaredMethod("newInstance0", Constructor.class, Object[].class);
            ConsulterSupplyFunction getConsulterFunction = functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context);
            MethodHandles.Lookup consulter = (MethodHandles.Lookup)getConsulterFunction.apply(nativeAccessorImplClass);
            this.methodHandle = consulter.unreflect(method);
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }
    }

    public static class ForJava7
    extends Abst {
        public ForJava7(Map<Object, Object> context) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            Class<?> nativeAccessorImplClass = Class.forName("sun.reflect.NativeConstructorAccessorImpl");
            Method method = nativeAccessorImplClass.getDeclaredMethod("newInstance0", Constructor.class, Object[].class);
            ConsulterSupplyFunction getConsulterFunction = functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context);
            MethodHandles.Lookup consulter = (MethodHandles.Lookup)getConsulterFunction.apply(nativeAccessorImplClass);
            method.setAccessible(true);
            this.methodHandle = consulter.unreflect(method);
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }
    }

    public static class Abst
    implements ConstructorInvokeFunction {
        protected MethodHandle methodHandle;
        protected ThrowExceptionFunction throwExceptionFunction;

        @Override
        public Object apply(Constructor<?> ctor, Object[] params) {
            try {
                return this.methodHandle.invokeWithArguments(ctor, params);
            }
            catch (Throwable exc) {
                return this.throwExceptionFunction.apply(exc);
            }
        }
    }
}

