/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;

public interface GetPackageFunction
extends BiFunction<ClassLoader, String, Package> {

    public static class ForJava9
    implements GetPackageFunction {
        protected MethodHandle methodHandle;
        protected ThrowExceptionFunction throwExceptionFunction;

        public ForJava9(Map<Object, Object> context) throws NoSuchMethodException, IllegalAccessException {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            ConsulterSupplyFunction consulterSupplyFunction = functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context);
            MethodHandles.Lookup classLoaderConsulter = (MethodHandles.Lookup)consulterSupplyFunction.apply(ClassLoader.class);
            MethodType methodType = MethodType.methodType(Package.class, String.class);
            this.methodHandle = classLoaderConsulter.findSpecial(ClassLoader.class, "getDefinedPackage", methodType, ClassLoader.class);
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }

        @Override
        public Package apply(ClassLoader classLoader, String packageName) {
            try {
                return this.methodHandle.invokeExact(classLoader, packageName);
            }
            catch (Throwable exc) {
                return (Package)this.throwExceptionFunction.apply(exc);
            }
        }
    }

    public static class ForJava7
    implements GetPackageFunction {
        public ForJava7(Map<Object, Object> context) {
        }

        @Override
        public Package apply(ClassLoader inputOne, String packageName) {
            return Package.getPackage(packageName);
        }
    }
}

