/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.InitializeException;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.TriConsumer;
import io.github.toolfactory.jvm.util.Classes;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import sun.misc.Unsafe;

public interface SetFieldValueFunction
extends TriConsumer<Object, Field, Object> {

    public static interface Native
    extends SetFieldValueFunction {

        public static class ForJava7
        extends Abst
        implements Native {
            public ForJava7(Map<Object, Object> context) throws InitializeException {
                super(context);
                this.checkNativeEngine();
            }

            protected void checkNativeEngine() throws InitializeException {
                if (!Narcissus.libraryLoaded) {
                    throw new InitializeException(Strings.compile("Could not initialize the native engine {}", Narcissus.class.getName()));
                }
            }

            @Override
            public void accept(Object target, Field field, Object value) {
                if (value != null && !Classes.isAssignableFrom(field.getType(), value.getClass())) {
                    throw new IllegalArgumentException(Strings.compile("Value {} is not assignable to {}", value, field.getName()));
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    Narcissus.setStaticField((Field)field, (Object)value);
                } else {
                    Narcissus.setField((Object)target, (Field)field, (Object)value);
                }
            }
        }
    }

    public static class ForJava7
    extends Abst {
        final Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) {
            super(context);
            this.unsafe = (Unsafe)ObjectProvider.get(context).getOrBuildObject(UnsafeSupplier.class, context).get();
        }

        @Override
        public void accept(Object origTarget, Field field, Object value) {
            if (value != null && !Classes.isAssignableFrom(field.getType(), value.getClass())) {
                throw new IllegalArgumentException(Strings.compile("Value {} is not assignable to {}", value, field.getName()));
            }
            Class<?> target = Modifier.isStatic(field.getModifiers()) ? field.getDeclaringClass() : origTarget;
            long fieldOffset = Modifier.isStatic(field.getModifiers()) ? this.unsafe.staticFieldOffset(field) : this.unsafe.objectFieldOffset(field);
            Class<?> cls = field.getType();
            if (!cls.isPrimitive()) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putObject(target, fieldOffset, value);
                } else {
                    this.unsafe.putObjectVolatile(target, fieldOffset, value);
                }
            } else if (cls == Integer.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putInt(target, fieldOffset, (Integer)value);
                } else {
                    this.unsafe.putIntVolatile(target, fieldOffset, (Integer)value);
                }
            } else if (cls == Long.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putLong(target, fieldOffset, (Long)value);
                } else {
                    this.unsafe.putLongVolatile(target, fieldOffset, (Long)value);
                }
            } else if (cls == Float.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putFloat(target, fieldOffset, ((Float)value).floatValue());
                } else {
                    this.unsafe.putFloatVolatile(target, fieldOffset, ((Float)value).floatValue());
                }
            } else if (cls == Double.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putDouble(target, fieldOffset, (Double)value);
                } else {
                    this.unsafe.putDoubleVolatile(target, fieldOffset, (Double)value);
                }
            } else if (cls == Boolean.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putBoolean(target, fieldOffset, (Boolean)value);
                } else {
                    this.unsafe.putBooleanVolatile(target, fieldOffset, (Boolean)value);
                }
            } else if (cls == Byte.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putByte(target, fieldOffset, (Byte)value);
                } else {
                    this.unsafe.putByteVolatile(target, fieldOffset, (Byte)value);
                }
            } else if (cls == Character.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putChar(target, fieldOffset, ((Character)value).charValue());
                } else {
                    this.unsafe.putCharVolatile(target, fieldOffset, ((Character)value).charValue());
                }
            }
        }
    }

    public static abstract class Abst
    implements SetFieldValueFunction {
        public Abst(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
        }
    }
}

