/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import toolgood.words.internals.BasePinyinMatch;
import toolgood.words.internals.PinyinDict;
import toolgood.words.internals.TwoTuple;

public class PinyinMatch
extends BasePinyinMatch {
    private String[] _keywords;
    private String[] _keywordsFirstPinyin;
    private String[][] _keywordsPinyin;
    private int[] _indexs;

    public void SetKeywords(List<String> keywords) throws NumberFormatException, IOException {
        this._keywords = keywords.toArray(new String[0]);
        this._keywordsFirstPinyin = new String[this._keywords.length];
        this._keywordsPinyin = new String[this._keywords.length][];
        for (int i = 0; i < this._keywords.length; ++i) {
            String text = this._keywords[i];
            String[] pys = PinyinDict.GetPinyinList(text, 0);
            String fpy = "";
            for (int j = 0; j < pys.length; ++j) {
                pys[j] = pys[j].toUpperCase();
                fpy = fpy + pys[j].charAt(0);
            }
            this._keywordsPinyin[i] = pys;
            this._keywordsFirstPinyin[i] = fpy;
        }
        this._indexs = null;
    }

    public void SetKeywords(List<String> keywords, List<String> pinyin) {
        this.SetKeywords(keywords, pinyin, ',');
    }

    public void SetKeywords(List<String> keywords, List<String> pinyin, char splitChar) {
        this._keywords = keywords.toArray(new String[0]);
        this._keywordsFirstPinyin = new String[this._keywords.length];
        this._keywordsPinyin = new String[this._keywords.length][];
        for (int i = 0; i < this._keywords.length; ++i) {
            String text = pinyin.get(i);
            String[] pys = text.split(Character.valueOf(splitChar).toString());
            String fpy = "";
            for (int j = 0; j < pys.length; ++j) {
                pys[j] = pys[j].toUpperCase();
                fpy = fpy + pys[j].charAt(0);
            }
            this._keywordsPinyin[i] = pys;
            this._keywordsFirstPinyin[i] = fpy;
        }
        this._indexs = null;
    }

    public void SetIndexs(List<Integer> indexs) throws Exception {
        if (this._keywords == null) {
            throw new Exception("\u8bf7\u5148\u4f7f\u7528 SetKeywords \u65b9\u6cd5");
        }
        if (indexs.size() < this._keywords.length) {
            throw new Exception("indexs \u6570\u7ec4\u957f\u5ea6\u5927\u4e8e keywords");
        }
        this._indexs = new int[indexs.size()];
        for (int i = 0; i < indexs.size(); ++i) {
            this._indexs[i] = indexs.get(i);
        }
    }

    public List<String> Find(String key) throws NumberFormatException, IOException {
        if ((key = key.toUpperCase().trim()) == null || key.equals("")) {
            return null;
        }
        boolean hasPinyin = key.matches("^.*?[A-Z]+.*$");
        if (!hasPinyin) {
            ArrayList<String> rs = new ArrayList<String>();
            for (int i = 0; i < this._keywords.length; ++i) {
                String keyword = this._keywords[i];
                if (!keyword.contains(key)) continue;
                rs.add(keyword);
            }
            return rs;
        }
        List<String> pykeys = this.SplitKeywords(key);
        int minLength = Integer.MAX_VALUE;
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        for (String pykey : pykeys) {
            String[] keys = pykey.split(Character.valueOf('\u0000').toString());
            if (minLength > keys.length) {
                minLength = keys.length;
            }
            this.MergeKeywords(keys, 0, "", list);
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this._keywords.length; ++i) {
            String[] pylist;
            String fpy;
            String keywords = this._keywords[i];
            if (keywords.length() < minLength || !search.Find(fpy = this._keywordsFirstPinyin[i], keywords, pylist = this._keywordsPinyin[i])) continue;
            result.add(keywords);
        }
        return result;
    }

    public List<Integer> FindIndex(String key) throws NumberFormatException, IOException {
        if ((key = key.toUpperCase().trim()) == null || key.equals("")) {
            return null;
        }
        boolean hasPinyin = key.matches("^.*?[A-Z]+.*$");
        if (!hasPinyin) {
            ArrayList<Integer> rs = new ArrayList<Integer>();
            for (int i = 0; i < this._keywords.length; ++i) {
                String keyword = this._keywords[i];
                if (!keyword.contains(key)) continue;
                if (this._indexs == null) {
                    rs.add(i);
                    continue;
                }
                rs.add(this._indexs[i]);
            }
            return rs;
        }
        List<String> pykeys = this.SplitKeywords(key);
        int minLength = Integer.MAX_VALUE;
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        for (String pykey : pykeys) {
            String[] keys = pykey.split(Character.valueOf('\u0000').toString());
            if (minLength > keys.length) {
                minLength = keys.length;
            }
            this.MergeKeywords(keys, 0, "", list);
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this._keywords.length; ++i) {
            String[] pylist;
            String fpy;
            String keywords = this._keywords[i];
            if (keywords.length() < minLength || !search.Find(fpy = this._keywordsFirstPinyin[i], keywords, pylist = this._keywordsPinyin[i])) continue;
            if (this._indexs == null) {
                result.add(i);
                continue;
            }
            result.add(this._indexs[i]);
        }
        return result;
    }

    public List<String> FindWithSpace(String keywords) throws NumberFormatException, IOException {
        if ((keywords = keywords.toUpperCase().trim()) == null || keywords.equals("")) {
            return null;
        }
        if (!keywords.contains(" ")) {
            return this.Find(keywords);
        }
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int minLength = 0;
        String[] keys = keywords.split(" ");
        int keysCount = keys.length;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            List<String> pykeys = this.SplitKeywords(key);
            int min = Integer.MAX_VALUE;
            for (String pykey : pykeys) {
                String[] keys2 = pykey.split(Character.valueOf('\u0000').toString());
                if (min > keys2.length) {
                    min = keys2.length;
                }
                this.MergeKeywords(keys2, 0, "", list, i, indexs);
            }
            minLength += min;
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        search.SetIndexs(indexs);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this._keywords.length; ++i) {
            String[] pylist;
            String fpy;
            String keywords2 = this._keywords[i];
            if (keywords2.length() < minLength || !search.Find2(fpy = this._keywordsFirstPinyin[i], keywords2, pylist = this._keywordsPinyin[i], keysCount)) continue;
            result.add(keywords2);
        }
        return result;
    }

    public List<Integer> FindIndexWithSpace(String keywords) throws NumberFormatException, IOException {
        if ((keywords = keywords.toUpperCase().trim()) == null || keywords.equals("")) {
            return null;
        }
        if (!keywords.contains(" ")) {
            return this.FindIndex(keywords);
        }
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int minLength = 0;
        String[] keys = keywords.split(" ");
        int keysCount = keys.length;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            List<String> pykeys = this.SplitKeywords(key);
            int min = Integer.MAX_VALUE;
            for (String pykey : pykeys) {
                String[] keys2 = pykey.split(Character.valueOf('\u0000').toString());
                if (min > keys2.length) {
                    min = keys2.length;
                }
                this.MergeKeywords(keys2, 0, "", list, i, indexs);
            }
            minLength += min;
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        search.SetIndexs(indexs);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this._keywords.length; ++i) {
            String[] pylist;
            String fpy;
            String keywords2 = this._keywords[i];
            if (keywords2.length() < minLength || !search.Find2(fpy = this._keywordsFirstPinyin[i], keywords2, pylist = this._keywordsPinyin[i], keysCount)) continue;
            if (this._indexs == null) {
                result.add(i);
                continue;
            }
            result.add(this._indexs[i]);
        }
        return result;
    }
}

