/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import toolgood.words.internals.PinyinDict;
import toolgood.words.internals.Translate;

public class WordsHelper {
    public static String GetFirstPinyin(String text) throws NumberFormatException, IOException {
        return PinyinDict.GetFirstPinyin(text, 0);
    }

    public static String GetPinyinFast(String text, Boolean tone) throws NumberFormatException, IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            Character c = Character.valueOf(text.charAt(i));
            sb.append(PinyinDict.GetPinyinFast(c, tone != false ? 1 : 0));
        }
        return sb.toString();
    }

    public static String GetPinyinFast(String text) throws NumberFormatException, IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            Character c = Character.valueOf(text.charAt(i));
            sb.append(PinyinDict.GetPinyinFast(c, 0));
        }
        return sb.toString();
    }

    public static String GetPinyin(String text, Boolean tone) throws NumberFormatException, IOException {
        return PinyinDict.GetPinyin(text, tone != false ? 1 : 0);
    }

    public static String GetPinyin(String text) throws NumberFormatException, IOException {
        return PinyinDict.GetPinyin(text, 0);
    }

    public static List<String> GetAllPinyin(char c, Boolean tone) throws NumberFormatException, IOException {
        return PinyinDict.GetAllPinyin(Character.valueOf(c), tone != false ? 1 : 0);
    }

    public static List<String> GetAllPinyin(char c) throws NumberFormatException, IOException {
        return PinyinDict.GetAllPinyin(Character.valueOf(c), 0);
    }

    public static String GetPinyinForName(String name, Boolean tone) throws NumberFormatException, IOException {
        return String.join((CharSequence)"", PinyinDict.GetPinyinForName(name, tone != false ? 1 : 0));
    }

    public static String GetPinyinForName(String name) throws NumberFormatException, IOException {
        return String.join((CharSequence)"", PinyinDict.GetPinyinForName(name, 0));
    }

    public static List<String> GetPinyinListForName(String name, Boolean tone) throws NumberFormatException, IOException {
        return PinyinDict.GetPinyinForName(name, tone != false ? 1 : 0);
    }

    public static List<String> GetPinyinListForName(String name) throws NumberFormatException, IOException {
        return PinyinDict.GetPinyinForName(name, 0);
    }

    public static boolean HasChinese(String content) {
        return Pattern.matches("[\\u3400-\\u4db5\\u4e00-\\u9fd5]", content);
    }

    public static boolean IsAllChinese(String content) {
        return Pattern.matches("^[\\u3400-\\u4db5\\u4e00-\\u9fd5]*$", content);
    }

    public static boolean HasEnglish(String content) {
        return Pattern.matches("[A-Za-z]", content);
    }

    public static boolean IsAllEnglish(String content) {
        return Pattern.matches("^[A-Za-z]*$", content);
    }

    public static String ToSBC(String input) {
        StringBuilder sb = new StringBuilder(input);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ' ') {
                sb.setCharAt(i, '\u3000');
                continue;
            }
            if (c >= '\u007f') continue;
            sb.setCharAt(i, (char)(c + 65248));
        }
        return sb.toString();
    }

    public static String ToDBC(String input) {
        StringBuilder sb = new StringBuilder(input);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\u3000') {
                sb.setCharAt(i, ' ');
                continue;
            }
            if (c <= '\uff00' || c >= '\uff5f') continue;
            sb.setCharAt(i, (char)(c - 65248));
        }
        return sb.toString();
    }

    public static String ToTraditionalChinese(String text) throws Exception {
        return Translate.ToTraditionalChinese(text, 0);
    }

    public static String ToTraditionalChinese(String text, int type) throws Exception {
        return Translate.ToTraditionalChinese(text, type);
    }

    public static String ToSimplifiedChinese(String text) throws Exception {
        return Translate.ToSimplifiedChinese(text, 0);
    }

    public static String ToSimplifiedChinese(String text, int srcType) throws Exception {
        return Translate.ToSimplifiedChinese(text, srcType);
    }
}

