/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import toolgood.words.WordsSearch;
import toolgood.words.WordsSearchResult;

public class Translate {
    private static WordsSearch s2tSearch;
    private static WordsSearch t2sSearch;
    private static WordsSearch t2twSearch;
    private static WordsSearch tw2tSearch;
    private static WordsSearch t2hkSearch;
    private static WordsSearch hk2tSearch;
    private static final Object lockObj;

    public static String ToTraditionalChinese(String text, int type) throws Exception {
        if (type > 2 || type < 0) {
            throw new Exception("type \u4e0d\u652f\u6301\u8be5\u7c7b\u578b");
        }
        WordsSearch s2t = Translate.GetWordsSearch(true, 0);
        text = Translate.TransformationReplace(text, s2t);
        if (type > 0) {
            WordsSearch t2 = Translate.GetWordsSearch(true, type);
            text = Translate.TransformationReplace(text, t2);
        }
        return text;
    }

    public static String ToSimplifiedChinese(String text, int srcType) throws Exception {
        if (srcType > 2 || srcType < 0) {
            throw new Exception("srcType \u4e0d\u652f\u6301\u8be5\u7c7b\u578b");
        }
        if (srcType > 0) {
            WordsSearch t2 = Translate.GetWordsSearch(false, srcType);
            text = Translate.TransformationReplace(text, t2);
        }
        WordsSearch s2t = Translate.GetWordsSearch(false, 0);
        text = Translate.TransformationReplace(text, s2t);
        return text;
    }

    public static void ClearTranslate() {
        s2tSearch = null;
        t2sSearch = null;
        t2twSearch = null;
        tw2tSearch = null;
        t2hkSearch = null;
        hk2tSearch = null;
    }

    private static String TransformationReplace(String text, WordsSearch wordsSearch) {
        List<WordsSearchResult> ts = wordsSearch.FindAll(text);
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < text.length()) {
            WordsSearchResult t = null;
            int end = -1;
            for (WordsSearchResult wordsSearchResult : ts) {
                if (wordsSearchResult.Start != index || end >= wordsSearchResult.End) continue;
                end = wordsSearchResult.End;
                t = wordsSearchResult;
            }
            if (t == null) {
                sb.append(text.charAt(index));
                ++index;
                continue;
            }
            sb.append(wordsSearch._others[t.Index]);
            index = t.End + 1;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WordsSearch GetWordsSearch(Boolean s2t, int srcType) throws IOException {
        if (s2t.booleanValue()) {
            if (srcType == 0) {
                if (s2tSearch == null) {
                    Object object = lockObj;
                    synchronized (object) {
                        if (s2tSearch == null) {
                            s2tSearch = Translate.BuildWordsSearch("s2t.dat", false);
                        }
                    }
                }
                return s2tSearch;
            }
            if (srcType == 1) {
                if (t2hkSearch == null) {
                    Object object = lockObj;
                    synchronized (object) {
                        if (t2hkSearch == null) {
                            t2hkSearch = Translate.BuildWordsSearch("t2hk.dat", false);
                        }
                    }
                }
                return t2hkSearch;
            }
            if (srcType == 2) {
                if (t2twSearch == null) {
                    Object object = lockObj;
                    synchronized (object) {
                        if (t2twSearch == null) {
                            t2twSearch = Translate.BuildWordsSearch("t2tw.dat", false);
                        }
                    }
                }
                return t2twSearch;
            }
        } else {
            if (srcType == 0) {
                if (t2sSearch == null) {
                    Object object = lockObj;
                    synchronized (object) {
                        if (t2sSearch == null) {
                            t2sSearch = Translate.BuildWordsSearch("t2s.dat", false);
                        }
                    }
                }
                return t2sSearch;
            }
            if (srcType == 1) {
                if (hk2tSearch == null) {
                    Object object = lockObj;
                    synchronized (object) {
                        if (hk2tSearch == null) {
                            hk2tSearch = Translate.BuildWordsSearch("t2hk.dat", true);
                        }
                    }
                }
                return hk2tSearch;
            }
            if (srcType == 2) {
                if (tw2tSearch == null) {
                    Object object = lockObj;
                    synchronized (object) {
                        if (tw2tSearch == null) {
                            tw2tSearch = Translate.BuildWordsSearch("t2tw.dat", true);
                        }
                    }
                }
                return tw2tSearch;
            }
        }
        return null;
    }

    private static WordsSearch BuildWordsSearch(String fileName, Boolean reverse) throws IOException {
        Map<String, String> dict = Translate.GetTransformationDict(fileName);
        ArrayList<String> Keys = new ArrayList<String>();
        ArrayList<String> Values2 = new ArrayList<String>();
        dict.forEach((k, v) -> {
            Keys.add((String)k);
            Values2.add((String)v);
        });
        WordsSearch wordsSearch = new WordsSearch();
        if (reverse.booleanValue()) {
            wordsSearch.SetKeywords(Values2);
            String[] temp = new String[Keys.size()];
            wordsSearch._others = Keys.toArray(temp);
        } else {
            wordsSearch.SetKeywords(Keys);
            String[] temp = new String[Keys.size()];
            wordsSearch._others = Values2.toArray(temp);
        }
        return wordsSearch;
    }

    static Map<String, String> GetTransformationDict(String fileName) throws IOException {
        String resourceName = fileName;
        InputStream u1 = WordsSearch.class.getClassLoader().getResourceAsStream(resourceName);
        BufferedReader br = new BufferedReader(new InputStreamReader(u1));
        String tStr = "";
        HashMap<String, String> dict = new HashMap<String, String>();
        while ((tStr = br.readLine()) != null) {
            String[] ss = tStr.split("\t");
            if (ss.length < 2) continue;
            dict.put(ss[0], ss[1]);
        }
        br.close();
        return dict;
    }

    static {
        lockObj = new Object();
    }
}

