/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TrieNodeEx {
    public Integer Char;
    public boolean End;
    public Integer Index;
    public List<Integer> Results;
    public Map<Integer, TrieNodeEx> m_values;
    private Integer minflag = Integer.MAX_VALUE;
    private Integer maxflag = 0;
    public int Next;

    public TrieNodeEx() {
        this.m_values = new Hashtable<Integer, TrieNodeEx>();
        this.Results = new ArrayList<Integer>();
    }

    public void Add(int c, TrieNodeEx node3) {
        if (this.minflag > c) {
            this.minflag = c;
        }
        if (this.maxflag < c) {
            this.maxflag = c;
        }
        this.m_values.put(c, node3);
    }

    public void SetResults(Integer text) {
        if (!this.End) {
            this.End = true;
        }
        if (!this.Results.contains(text)) {
            this.Results.add(text);
        }
    }

    public boolean HasKey(Integer c) {
        if (this.minflag <= c && this.maxflag >= c) {
            return this.m_values.containsKey((int)c);
        }
        return false;
    }

    public void Rank(Integer oneStart, Integer start, boolean[] seats, boolean[] seats2, Integer[] has) {
        if (this.maxflag == 0) {
            return;
        }
        if (this.minflag == this.maxflag) {
            this.RankOne(oneStart, seats, has);
            return;
        }
        ArrayList keys = new ArrayList();
        this.m_values.forEach((k, v) -> keys.add(Integer.valueOf(k)));
        Integer length = keys.size() - 1;
        int[] moves = new int[keys.size() - 1];
        for (int i = 1; i < keys.size(); ++i) {
            moves[i - 1] = this.maxflag - (Integer)keys.get(i);
        }
        while (has[start] != null) {
            Integer i = start;
            start = start + 1;
        }
        Integer s = start < this.minflag ? this.minflag : start;
        int next = s - this.minflag;
        for (int e = next + this.maxflag; e < has.length; ++e) {
            if (!seats2[e] && !seats[next]) {
                boolean isok = true;
                for (int i = 0; i < keys.size(); ++i) {
                    int position = next + (Integer)keys.get(i);
                    if (has[position] == null) continue;
                    for (int j = 0; j < length; ++j) {
                        seats2[position + moves[j]] = true;
                    }
                    isok = false;
                    break;
                }
                if (isok) {
                    this.SetSeats(next, seats, has);
                    start = start + keys.size() / 2;
                    for (int p = start.intValue(); p < e + this.maxflag - start + 1; ++p) {
                        if (!seats2[p]) continue;
                        seats2[p] = false;
                    }
                    return;
                }
            }
            ++next;
        }
    }

    private void RankOne(Integer start, boolean[] seats, Integer[] has) {
        Integer s;
        while (has[start] != null) {
            Integer n = start;
            start = start + 1;
        }
        Integer i = s = start < this.minflag ? this.minflag : start;
        while (i < has.length) {
            Integer next;
            if (has[i] == null && !seats[next = Integer.valueOf(i - this.minflag)]) {
                this.SetSeats(next, seats, has);
                break;
            }
            Integer n = i;
            i = i + 1;
        }
        Integer n = start;
        start = start + 1;
    }

    private void SetSeats(Integer next, boolean[] seats, Integer[] has) {
        this.Next = next;
        seats[next.intValue()] = true;
        this.m_values.forEach((key, value) -> {
            int position = next + key;
            has[position] = value.Index;
        });
    }
}

