/*
 * Decompiled with CFR 0.152.
 */
package com.torrydo.screenez;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Rect;
import android.provider.Settings;
import android.util.Size;
import android.view.Display;
import android.view.WindowManager;
import androidx.window.layout.WindowMetricsCalculator;
import com.torrydo.screenez.ScreenInfoApi;
import com.torrydo.screenez.ScreenPadding;
import com.torrydo.screenez.ScreenRotation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/torrydo/screenez/ApiLevel21;", "Lcom/torrydo/screenez/ScreenInfoApi;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cutoutPadding", "Lcom/torrydo/screenez/ScreenPadding;", "getDisplay", "Landroid/view/Display;", "isButtonsNavigation", "", "isGestureNavigation", "navBarHeight", "", "navBarPadding", "navigationMode", "orientation", "screenRotation", "Lcom/torrydo/screenez/ScreenRotation;", "screenSize", "Landroid/util/Size;", "statusBarHeight", "statusPadding", "screenez_release"})
public class ApiLevel21
implements ScreenInfoApi {
    @NotNull
    private final Context context;

    public ApiLevel21(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    public Size screenSize() {
        WindowMetricsCalculator wmc = WindowMetricsCalculator.Companion.getOrCreate();
        Rect maxWindowMetrics = wmc.computeMaximumWindowMetrics(this.context).getBounds();
        return new Size(maxWindowMetrics.width(), maxWindowMetrics.height());
    }

    @Override
    public int orientation() {
        return this.context.getResources().getConfiguration().orientation;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public ScreenRotation screenRotation() {
        v0 = this.getDisplay();
        rotation = v0 != null ? Integer.valueOf(v0.getRotation()) : null;
        screenSize = this.screenSize();
        width = screenSize.getWidth();
        height = screenSize.getHeight();
        v1 = rotation;
        if (v1 != null && v1 == 0) ** GOTO lbl-1000
        v2 = rotation;
        var6_5 = 2;
        if (v2 != null && v2 == var6_5) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        isPortrait = v3;
        v4 = rotation;
        var7_7 = 1;
        if (v4 != null && v4 == var7_7) ** GOTO lbl-1000
        v5 = rotation;
        var7_7 = 3;
        if (v5 != null && v5 == var7_7) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = isLandscape = false;
        }
        if (isPortrait && height > width || isLandscape && width > height) {
            v7 = var7_8 = rotation;
            if (v7 != null && v7 == 0) {
                v8 = ScreenRotation.PORTRAIT;
            } else {
                v9 = var7_8;
                var8_10 = 1;
                if (v9 != null && v9 == var8_10) {
                    v8 = ScreenRotation.REVERSED_LANDSCAPE;
                } else {
                    v10 = var7_8;
                    var8_10 = 2;
                    if (v10 != null && v10 == var8_10) {
                        v8 = ScreenRotation.REVERSED_PORTRAIT;
                    } else {
                        v11 = var7_8;
                        var8_10 = 3;
                        v8 = v11 != null && v11 == var8_10 ? ScreenRotation.LANDSCAPE : ScreenRotation.PORTRAIT;
                    }
                }
            }
        } else {
            v12 = var7_9 = rotation;
            if (v12 != null && v12 == 0) {
                v8 = ScreenRotation.LANDSCAPE;
            } else {
                v13 = var7_9;
                var8_11 = 1;
                if (v13 != null && v13 == var8_11) {
                    v8 = ScreenRotation.PORTRAIT;
                } else {
                    v14 = var7_9;
                    var8_11 = 2;
                    if (v14 != null && v14 == var8_11) {
                        v8 = ScreenRotation.REVERSED_LANDSCAPE;
                    } else {
                        v15 = var7_9;
                        var8_11 = 3;
                        v8 = v15 != null && v15 == var8_11 ? ScreenRotation.REVERSED_PORTRAIT : ScreenRotation.LANDSCAPE;
                    }
                }
            }
        }
        return v8;
    }

    @Override
    @NotNull
    public ScreenPadding statusPadding() {
        return ScreenPadding.copy$default(ScreenPadding.Companion.getNone(), 0, this.statusBarHeight(), 0, 0, 13, null);
    }

    @Override
    @NotNull
    public ScreenPadding navBarPadding() {
        ScreenPadding screenPadding;
        int height = this.navBarHeight();
        ScreenPadding nonePadding = ScreenPadding.Companion.getNone();
        switch (this.orientation()) {
            case 1: {
                screenPadding = ScreenPadding.copy$default(nonePadding, 0, 0, 0, height, 7, null);
                break;
            }
            case 2: {
                screenPadding = ScreenPadding.copy$default(nonePadding, 0, 0, height, 0, 11, null);
                break;
            }
            default: {
                screenPadding = nonePadding;
            }
        }
        return screenPadding;
    }

    @Override
    @NotNull
    public ScreenPadding cutoutPadding() {
        return ScreenPadding.Companion.getNone();
    }

    @Override
    public boolean isButtonsNavigation() {
        return this.navigationMode() == 0;
    }

    @Override
    public boolean isGestureNavigation() {
        return this.navigationMode() == 2;
    }

    @Override
    public int navBarHeight() {
        int resourceId = this.context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        return this.context.getResources().getDimensionPixelSize(resourceId);
    }

    @Override
    public int statusBarHeight() {
        int statusBarHeightId = this.context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return this.context.getResources().getDimensionPixelSize(statusBarHeightId);
    }

    @Nullable
    public Display getDisplay() {
        Object object = this.context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager wm = (WindowManager)object;
        return wm.getDefaultDisplay();
    }

    private final int navigationMode() {
        int n;
        try {
            n = Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"navigation_mode");
        }
        catch (Exception e) {
            n = 0;
        }
        return n;
    }
}

