/*
 * Decompiled with CFR 0.152.
 */
package com.torrydo.screenez;

import android.content.Context;
import android.util.Size;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.Insets;
import androidx.core.view.WindowInsetsCompat;
import androidx.window.layout.WindowMetrics;
import androidx.window.layout.WindowMetricsCalculator;
import com.torrydo.screenez.ApiLevel29;
import com.torrydo.screenez.ScreenPadding;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/torrydo/screenez/ApiLevel30;", "Lcom/torrydo/screenez/ApiLevel29;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cutoutInsets", "Landroidx/core/graphics/Insets;", "navBarInsets", "screenSize", "Landroid/util/Size;", "statusBarInsets", "cutoutPadding", "Lcom/torrydo/screenez/ScreenPadding;", "navBarPadding", "statusPadding", "screenez_release"})
@RequiresApi(value=30)
public final class ApiLevel30
extends ApiLevel29 {
    @NotNull
    private final Context context;
    @NotNull
    private Size screenSize;
    @NotNull
    private Insets navBarInsets;
    @NotNull
    private Insets statusBarInsets;
    @NotNull
    private Insets cutoutInsets;

    public ApiLevel30(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        this.screenSize = new Size(0, 0);
        Insets insets = Insets.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"NONE");
        this.navBarInsets = insets;
        Insets insets2 = Insets.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"NONE");
        this.statusBarInsets = insets2;
        Insets insets3 = Insets.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"NONE");
        this.cutoutInsets = insets3;
        this.screenSize = this.screenSize();
        WindowMetricsCalculator wmc = WindowMetricsCalculator.Companion.getOrCreate();
        WindowMetrics maxWindowMetrics = wmc.computeMaximumWindowMetrics(this.context);
        Insets insets4 = maxWindowMetrics.getWindowInsets().getInsets(WindowInsetsCompat.Type.navigationBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets4, (String)"maxWindowMetrics.getWind\u2026at.Type.navigationBars())");
        this.navBarInsets = insets4;
        Insets insets5 = maxWindowMetrics.getWindowInsets().getInsets(WindowInsetsCompat.Type.statusBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets5, (String)"maxWindowMetrics.getWind\u2026Compat.Type.statusBars())");
        this.statusBarInsets = insets5;
        Insets insets6 = maxWindowMetrics.getWindowInsets().getInsets(WindowInsetsCompat.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)insets6, (String)"maxWindowMetrics.getWind\u2026pat.Type.displayCutout())");
        this.cutoutInsets = insets6;
    }

    @Override
    @NotNull
    public ScreenPadding navBarPadding() {
        return ScreenPadding.Companion.fromInsets$screenez_release(this.navBarInsets);
    }

    @Override
    @NotNull
    public ScreenPadding statusPadding() {
        return ScreenPadding.Companion.fromInsets$screenez_release(this.statusBarInsets);
    }

    @Override
    @NotNull
    public ScreenPadding cutoutPadding() {
        return ScreenPadding.Companion.fromInsets$screenez_release(this.cutoutInsets);
    }
}

