/*
 * Decompiled with CFR 0.152.
 */
package com.torrydo.screenez;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.Size;
import com.torrydo.screenez.ApiLevel21;
import com.torrydo.screenez.ApiLevel25;
import com.torrydo.screenez.ApiLevel28;
import com.torrydo.screenez.ApiLevel29;
import com.torrydo.screenez.ApiLevel30;
import com.torrydo.screenez.ScreenArea;
import com.torrydo.screenez.ScreenInfoApi;
import com.torrydo.screenez.ScreenPadding;
import com.torrydo.screenez.ScreenRotation;
import com.torrydo.screenez.XKt;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020=J\u0006\u0010?\u001a\u00020=J\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020A2\u0006\u0010\b\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010#\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u0011\u0010%\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0011\u0010'\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012R\u0011\u0010)\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0012R\u0011\u0010+\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\u0011\u0010-\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0016R\u0011\u0010/\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0012R\u0014\u00101\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0012R\u0011\u0010:\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u000e\u00a8\u0006C"}, d2={"Lcom/torrydo/screenez/ScreenEasy;", "", "()V", "_screenInfo", "Lcom/torrydo/screenez/ScreenInfoApi;", "_weakContext", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "context", "getContext", "()Landroid/content/Context;", "cutoutPadding", "Lcom/torrydo/screenez/ScreenPadding;", "getCutoutPadding", "()Lcom/torrydo/screenez/ScreenPadding;", "fullHeight", "", "getFullHeight", "()I", "fullSize", "Landroid/util/Size;", "getFullSize", "()Landroid/util/Size;", "fullWidth", "getFullWidth", "navBarHeight", "getNavBarHeight", "navBarPadding", "getNavBarPadding", "safeArea", "Lcom/torrydo/screenez/ScreenArea;", "getSafeArea", "()Lcom/torrydo/screenez/ScreenArea;", "safeHeight", "getSafeHeight", "safePaddingBottom", "getSafePaddingBottom", "safePaddingLeft", "getSafePaddingLeft", "safePaddingRight", "getSafePaddingRight", "safePaddingTop", "getSafePaddingTop", "safeScreenPadding", "getSafeScreenPadding", "safeSize", "getSafeSize", "safeWidth", "getSafeWidth", "screenInfo", "getScreenInfo", "()Lcom/torrydo/screenez/ScreenInfoApi;", "screenRotation", "Lcom/torrydo/screenez/ScreenRotation;", "getScreenRotation", "()Lcom/torrydo/screenez/ScreenRotation;", "statusBarHeight", "getStatusBarHeight", "statusBarPadding", "getStatusBarPadding", "isButtonsNavigation", "", "isGestureNavigation", "isPortrait", "refresh", "", "with", "screenez_release"})
public final class ScreenEasy {
    @Nullable
    private ScreenInfoApi _screenInfo;
    @Nullable
    private WeakReference<Context> _weakContext;

    private final ScreenInfoApi getScreenInfo() {
        if (this._screenInfo == null) {
            throw new IllegalStateException("You haven't call `with(context)`");
        }
        ScreenInfoApi screenInfoApi = this._screenInfo;
        Intrinsics.checkNotNull((Object)screenInfoApi);
        return screenInfoApi;
    }

    private final Context getContext() {
        if (this._weakContext == null) {
            throw new IllegalStateException("You haven't call `with(context)`");
        }
        WeakReference<Context> weakReference = this._weakContext;
        Intrinsics.checkNotNull(weakReference);
        Object t = weakReference.get();
        Intrinsics.checkNotNull(t);
        return (Context)t;
    }

    public final void with(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._weakContext = new WeakReference<Context>(context.getApplicationContext());
        this.refresh();
    }

    public final void refresh() {
        this._screenInfo = Build.VERSION.SDK_INT >= 30 ? (ScreenInfoApi)new ApiLevel30(this.getContext()) : (Build.VERSION.SDK_INT >= 29 ? (ScreenInfoApi)new ApiLevel29(this.getContext()) : (Build.VERSION.SDK_INT >= 28 ? (ScreenInfoApi)new ApiLevel28(this.getContext()) : (Build.VERSION.SDK_INT >= 25 ? (ScreenInfoApi)new ApiLevel25(this.getContext()) : (ScreenInfoApi)new ApiLevel21(this.getContext()))));
    }

    @NotNull
    public final ScreenPadding getNavBarPadding() {
        return this.getScreenInfo().navBarPadding();
    }

    @NotNull
    public final ScreenPadding getStatusBarPadding() {
        return this.getScreenInfo().statusPadding();
    }

    @NotNull
    public final ScreenPadding getCutoutPadding() {
        return this.getScreenInfo().cutoutPadding();
    }

    public final int getFullWidth() {
        return this.getFullSize().getWidth();
    }

    public final int getFullHeight() {
        return this.getFullSize().getHeight();
    }

    @NotNull
    public final Size getFullSize() {
        return this.getScreenInfo().screenSize();
    }

    public final boolean isButtonsNavigation() {
        return this.getScreenInfo().isButtonsNavigation();
    }

    public final boolean isGestureNavigation() {
        return this.getScreenInfo().isGestureNavigation();
    }

    @NotNull
    public final ScreenArea getSafeArea() {
        ScreenPadding paddings = this.getSafeScreenPadding();
        Point topLeft = new Point(paddings.getLeft(), paddings.getTop());
        Point topRight = new Point(this.getFullWidth() - paddings.getRight(), paddings.getTop());
        Point bottomRight = new Point(this.getFullWidth() - paddings.getRight(), this.getFullHeight() - paddings.getBottom());
        Point bottomLeft = new Point(paddings.getLeft(), this.getFullHeight() - paddings.getBottom());
        return new ScreenArea(topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public final ScreenPadding getSafeScreenPadding() {
        int topPadding = this.getSafePaddingTop();
        int bottomPadding = this.getSafePaddingBottom();
        int leftPadding = this.getSafePaddingLeft();
        int rightPadding = this.getSafePaddingRight();
        return new ScreenPadding(leftPadding, topPadding, rightPadding, bottomPadding);
    }

    public final int getSafePaddingLeft() {
        return Math.max(this.getScreenInfo().cutoutPadding().getLeft(), Math.max(this.getScreenInfo().statusPadding().getLeft(), this.getScreenInfo().navBarPadding().getLeft()));
    }

    public final int getSafePaddingRight() {
        return Math.max(this.getScreenInfo().cutoutPadding().getRight(), Math.max(this.getScreenInfo().statusPadding().getRight(), this.getScreenInfo().navBarPadding().getRight()));
    }

    public final int getSafePaddingTop() {
        return Math.max(this.getScreenInfo().cutoutPadding().getTop(), Math.max(this.getScreenInfo().statusPadding().getTop(), this.getScreenInfo().navBarPadding().getTop()));
    }

    public final int getSafePaddingBottom() {
        return Math.max(this.getScreenInfo().cutoutPadding().getBottom(), Math.max(this.getScreenInfo().statusPadding().getBottom(), this.getScreenInfo().navBarPadding().getBottom()));
    }

    public final int getSafeWidth() {
        int total = this.getSafePaddingLeft() + this.getSafePaddingRight();
        return this.getFullWidth() - total;
    }

    public final int getSafeHeight() {
        int bottomGestureNavHeight = XKt.height(this.getNavBarPadding());
        int topStatusBarHeight = XKt.height(this.getStatusBarPadding());
        int total = bottomGestureNavHeight + topStatusBarHeight;
        return this.getFullHeight() - total;
    }

    @NotNull
    public final Size getSafeSize() {
        return new Size(this.getSafeWidth(), this.getSafeHeight());
    }

    public final int getStatusBarHeight() {
        return this.getStatusBarPadding().getTop();
    }

    public final int getNavBarHeight() {
        return this.getScreenInfo().navBarHeight();
    }

    public final boolean isPortrait() {
        return this.getScreenInfo().orientation() == 1;
    }

    @NotNull
    public final ScreenRotation getScreenRotation() {
        return this.getScreenInfo().screenRotation();
    }
}

