/*
 * Decompiled with CFR 0.152.
 */
package chariot;

import chariot.ClientAuth;
import chariot.api.Account;
import chariot.api.Analysis;
import chariot.api.Bot;
import chariot.api.Broadcasts;
import chariot.api.Builders;
import chariot.api.Challenges;
import chariot.api.Custom;
import chariot.api.ExternalEngine;
import chariot.api.Games;
import chariot.api.OpeningExplorer;
import chariot.api.Puzzles;
import chariot.api.Simuls;
import chariot.api.Studies;
import chariot.api.Tablebase;
import chariot.api.Teams;
import chariot.api.Tournaments;
import chariot.api.Users;
import chariot.internal.AuthClient;
import chariot.internal.BasicClient;
import chariot.internal.Config;
import chariot.internal.DefaultClient;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.prefs.Preferences;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Client {
    public static Client basic() {
        return Client.basic(Config.basic((Builders.Builder builder) -> builder.production()));
    }

    public static ClientAuth auth(String string) {
        return Client.auth((Builders.TokenBuilder tokenBuilder) -> tokenBuilder.production().auth(string));
    }

    public Account account();

    public Analysis analysis();

    public Bot bot();

    public Broadcasts broadcasts();

    public Challenges challenges();

    public ExternalEngine externalEngine();

    public Games games();

    public OpeningExplorer openingExplorer();

    public Puzzles puzzles();

    public Simuls simuls();

    public Studies studies();

    public Tablebase tablebase();

    public Teams teams();

    public Tournaments tournaments();

    public Users users();

    public static Client basic(Consumer<Builders.Builder> consumer) {
        return Client.basic(Config.basic(consumer));
    }

    public static ClientAuth auth(Consumer<Builders.TokenBuilder> consumer) {
        return Client.auth(Config.auth(consumer));
    }

    public static ClientAuth auth(Supplier<char[]> supplier) {
        return Client.auth((Builders.TokenBuilder tokenBuilder) -> tokenBuilder.production().auth((Supplier)supplier));
    }

    public static Client load(Preferences preferences) {
        return Client.load(Config.load(preferences));
    }

    public boolean store(Preferences var1);

    default public void clearAuth(Preferences preferences) {
        Config.clearAuth(preferences);
    }

    public static ClientAuth load(Preferences preferences, Consumer<Builders.AuthBuilder> consumer) {
        return Client.auth(Config.load(preferences, consumer));
    }

    public static ClientAuth reuseOrInitialize(Consumer<Builders.OAuthHelper> consumer) {
        var var1_1 = new Builders.OAuthHelper(){
            Preferences preferences = null;
            Scope[] scopes = null;

            @Override
            public Builders.OAuthHelper prefs(Preferences preferences) {
                this.preferences = preferences;
                return this;
            }

            @Override
            public Builders.OAuthHelper scopes(Scope ... scopeArray) {
                Objects.requireNonNull(scopeArray);
                this.scopes = scopeArray;
                return this;
            }
        };
        consumer.accept(var1_1);
        Objects.requireNonNull(var1_1.preferences);
        return Client.reuseOrInitialize(var1_1.preferences, var1_1.scopes);
    }

    public static ClientAuth reuseOrInitialize(Preferences preferences, Scope ... scopeArray) {
        Object object;
        Client client = Client.load(preferences);
        if (client instanceof ClientAuth && (object = (ClientAuth)client).account().scopes().containsAll(Set.of(scopeArray))) {
            return object;
        }
        object = client.account().oauthPKCE(scopeArray);
        System.out.println("\n\nGrant access at URL:\n" + String.valueOf(((Account.UriAndToken)object).url()) + "\n");
        ClientAuth clientAuth = Client.load(preferences, arg_0 -> Client.lambda$reuseOrInitialize$3((Account.UriAndToken)object, arg_0));
        clientAuth.store(preferences);
        return clientAuth;
    }

    default public Optional<ClientAuth> asAuth() {
        Optional<ClientAuth> optional;
        Client client = this;
        if (client instanceof AuthClient) {
            AuthClient authClient = (AuthClient)client;
            optional = Optional.of(authClient);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    default public void logging(Consumer<Builders.LogSetter> consumer) {
        Config.Logging logging = ((DefaultClient)((Object)this)).config().logging();
        Config.LBuilderImpl lBuilderImpl = new Config.LBuilderImpl(logging);
        consumer.accept(lBuilderImpl);
    }

    private static Client load(Config config) {
        if (config instanceof Config.Basic) {
            Config.Basic basic = (Config.Basic)config;
            return new BasicClient(basic);
        }
        if (config instanceof Config.Auth) {
            Config.Auth auth = (Config.Auth)config;
            return new AuthClient(auth);
        }
        throw new RuntimeException("Unknown config type: " + String.valueOf(config));
    }

    private static Client basic(Config.Basic basic) {
        return new BasicClient(basic);
    }

    private static ClientAuth auth(Config.Auth auth) {
        return new AuthClient(auth);
    }

    public Custom custom();

    private static /* synthetic */ void lambda$reuseOrInitialize$3(Account.UriAndToken uriAndToken, Builders.AuthBuilder authBuilder) {
        authBuilder.auth(uriAndToken.token().get());
    }

    public static enum Scope {
        preference_read,
        preference_write,
        email_read,
        challenge_read,
        challenge_write,
        challenge_bulk,
        study_read,
        study_write,
        tournament_write,
        racer_write,
        puzzle_read,
        team_read,
        team_write,
        team_lead,
        msg_write,
        board_play,
        bot_play,
        follow_read,
        follow_write,
        engine_read,
        engine_write,
        web_login,
        web_mod,
        any;


        public String asString() {
            return switch (this) {
                case any -> "*";
                default -> this.name().replace("_", ":");
            };
        }

        public static Optional<Scope> fromString(String string) {
            try {
                return Optional.of(Scope.valueOf(string.replace(":", "_")));
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Basic
    extends Client {
    }
}

