/*
 * Decompiled with CFR 0.152.
 */
package chariot.api;

import chariot.api.Builders;
import chariot.api.ChallengesAuthCommon;
import chariot.model.Ack;
import chariot.model.ChatMessage;
import chariot.model.Enums;
import chariot.model.GameEvent;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.SeekAck;
import java.util.function.Consumer;
import java.util.function.Function;

public interface BoardAuth
extends ChallengesAuthCommon {
    public Many<String> seekRealTime(Consumer<SeekRealTimeBuilder> var1);

    default public Many<String> seekRealTime(int n, int n2) {
        return this.seekRealTime(seekRealTimeBuilder -> seekRealTimeBuilder.clock(n, n2));
    }

    public One<SeekAck> seekCorrespondence(Consumer<SeekCorrespondenceBuilder> var1);

    default public One<SeekAck> seekCorrespondence(int n) {
        return this.seekCorrespondence(seekCorrespondenceBuilder -> seekCorrespondenceBuilder.daysPerTurn(n));
    }

    public Many<GameEvent> connectToGame(String var1);

    public One<Ack> move(String var1, String var2, boolean var3);

    public One<Ack> move(String var1, String var2);

    public One<Ack> chat(String var1, String var2, Enums.Room var3);

    public One<Ack> abort(String var1);

    public One<Ack> resign(String var1);

    public One<Ack> handleDrawOffer(String var1, Enums.Offer var2);

    public One<Ack> handleTakebackOffer(String var1, Enums.Offer var2);

    public One<Ack> claimVictory(String var1);

    public Many<ChatMessage> fetchChat(String var1);

    public One<Ack> berserk(String var1);

    default public One<Ack> chat(String string, String string2) {
        return this.chat(string, string2, Enums.Room.player);
    }

    default public One<Ack> handleDrawOffer(String string, Function<Enums.Offer.Provider, Enums.Offer> function) {
        return this.handleDrawOffer(string, function.apply(Enums.Offer.provider()));
    }

    default public One<Ack> handleTakebackOffer(String string, Function<Enums.Offer.Provider, Enums.Offer> function) {
        return this.handleTakebackOffer(string, function.apply(Enums.Offer.provider()));
    }

    public static interface SeekCorrespondenceBuilder
    extends Builders.ClockCorrespondence<SeekParams> {
    }

    public static interface SeekRealTimeBuilder
    extends Builders.ClockMinute<SeekParams> {
    }

    public static interface SeekParams {
        public SeekParams color(Enums.ColorPref var1);

        default public SeekParams color(Function<Enums.ColorPref.Provider, Enums.ColorPref> function) {
            return this.color(function.apply(Enums.ColorPref.provider()));
        }

        public SeekParams variant(Enums.VariantName var1);

        default public SeekParams variant(Function<Enums.VariantName.Provider, Enums.VariantName> function) {
            return this.variant(function.apply(Enums.VariantName.provider()));
        }

        public SeekParams rated(boolean var1);

        default public SeekParams rated() {
            return this.rated(true);
        }

        public SeekParams ratingRange(String var1);
    }
}

