/*
 * Decompiled with CFR 0.152.
 */
package chariot.api;

import chariot.Client;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.prefs.Preferences;

public interface Builders {

    public static interface LogLevel {
        public LogSetter all();

        public LogSetter finest();

        public LogSetter finer();

        public LogSetter fine();

        public LogSetter config();

        public LogSetter info();

        public LogSetter warning();

        public LogSetter severe();

        public LogSetter off();
    }

    public static interface LogSetter {
        public LogLevel request();

        public LogLevel response();

        public LogLevel auth();
    }

    public static interface ExtServBuilder {
        public ExtServBuilder explorer(String var1);

        public ExtServBuilder tablebase(String var1);

        public ExtServBuilder engine(String var1);
    }

    public static interface Builder {
        default public Builder production() {
            return this.api("https://lichess.org").servers(extServBuilder -> extServBuilder.explorer("https://explorer.lichess.ovh").tablebase("https://tablebase.lichess.ovh"));
        }

        default public Builder local() {
            return this.api("http://localhost:9663");
        }

        public Builder api(String var1);

        public Builder servers(Consumer<ExtServBuilder> var1);

        public Builder logging(Consumer<LogSetter> var1);

        public Builder retries(int var1);
    }

    public static interface AuthBuilder {
        default public AuthBuilder auth(String string) {
            return this.auth(() -> string.toCharArray());
        }

        public AuthBuilder auth(Supplier<char[]> var1);

        public AuthBuilder auth(Set<Supplier<char[]>> var1);

        public AuthBuilder auth(Map<Client.Scope, Supplier<char[]>> var1);
    }

    public static interface TokenBuilder
    extends Builder,
    AuthBuilder {
        @Override
        default public TokenBuilder auth(String string) {
            return this.auth(() -> string.toCharArray());
        }

        @Override
        public TokenBuilder auth(Supplier<char[]> var1);

        @Override
        public TokenBuilder auth(Set<Supplier<char[]>> var1);

        @Override
        public TokenBuilder auth(Map<Client.Scope, Supplier<char[]>> var1);

        @Override
        public TokenBuilder api(String var1);

        @Override
        public TokenBuilder servers(Consumer<ExtServBuilder> var1);

        @Override
        public TokenBuilder logging(Consumer<LogSetter> var1);

        @Override
        default public TokenBuilder production() {
            Builder.super.production();
            return this;
        }

        @Override
        default public TokenBuilder local() {
            Builder.super.local();
            return this;
        }
    }

    public static interface ClockMinute<T> {
        public T clock(float var1, int var2);

        default public T clockBullet1m0s() {
            return this.clock(1.0f, 0);
        }

        default public T clockBullet2m1s() {
            return this.clock(2.0f, 1);
        }

        default public T clockBlitz3m1s() {
            return this.clock(3.0f, 1);
        }

        default public T clockBlitz3m2s() {
            return this.clock(3.0f, 2);
        }

        default public T clockBlitz5m0s() {
            return this.clock(5.0f, 0);
        }

        default public T clockBlitz5m3s() {
            return this.clock(5.0f, 3);
        }

        default public T clockRapid10m0s() {
            return this.clock(10.0f, 0);
        }

        default public T clockRapid10m5s() {
            return this.clock(10.0f, 5);
        }

        default public T clockRapid15m10s() {
            return this.clock(15.0f, 10);
        }

        default public T clockClassical30m0s() {
            return this.clock(30.0f, 0);
        }

        default public T clockClassical30m20s() {
            return this.clock(30.0f, 20);
        }
    }

    public static interface ClockCorrespondence<T> {
        public T daysPerTurn(int var1);
    }

    public static interface Clock<T> {
        public T clock(int var1, int var2);

        default public T clockBullet1m0s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(1L), 0);
        }

        default public T clockBullet2m1s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(2L), 1);
        }

        default public T clockBlitz3m1s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(3L), 1);
        }

        default public T clockBlitz3m2s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(3L), 2);
        }

        default public T clockBlitz5m0s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(5L), 0);
        }

        default public T clockBlitz5m3s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(5L), 3);
        }

        default public T clockRapid10m0s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(10L), 0);
        }

        default public T clockRapid10m5s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(10L), 5);
        }

        default public T clockRapid15m10s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(15L), 10);
        }

        default public T clockClassical30m0s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(30L), 0);
        }

        default public T clockClassical30m20s() {
            return this.clock((int)TimeUnit.MINUTES.toSeconds(30L), 20);
        }
    }

    public static interface OAuthHelper {
        public OAuthHelper prefs(Preferences var1);

        public OAuthHelper scopes(Client.Scope ... var1);

        default public OAuthHelper prefs(String string) {
            return this.prefs(Preferences.userRoot().node(string));
        }
    }
}

