/*
 * Decompiled with CFR 0.152.
 */
package chariot.api;

import chariot.api.Builders;
import chariot.api.Challenges;
import chariot.api.ChallengesAuthCommon;
import chariot.internal.Crypt;
import chariot.model.Ack;
import chariot.model.BulkPairing;
import chariot.model.Enums;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.PendingChallenges;
import java.time.ZonedDateTime;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ChallengesAuth
extends Challenges,
ChallengesAuthCommon {
    public One<PendingChallenges> challenges();

    public One<Ack> startClocksOfGame(String var1, String var2, String var3);

    public One<Ack> addTimeToGame(String var1, int var2);

    public Many<BulkPairing> bulks();

    public One<BulkPairing> createBulk(Consumer<BulkBuilder> var1);

    public One<Ack> startBulk(String var1);

    public One<Ack> cancelBulk(String var1);

    public static interface BulkParams {
        public BulkParams rated(boolean var1);

        default public BulkParams rated() {
            return this.rated(true);
        }

        default public BulkParams addPairing(String string, String string2) {
            Crypt.Result result = Crypt.encrypt(string.toCharArray());
            Crypt.Result result2 = Crypt.encrypt(string2.toCharArray());
            return this.addPairing(new Pairing(() -> Crypt.decrypt(result.data(), result.key()), () -> Crypt.decrypt(result2.data(), result2.key())));
        }

        default public BulkParams addPairing(Supplier<char[]> supplier, Supplier<char[]> supplier2) {
            return this.addPairing(new Pairing(supplier, supplier2));
        }

        public BulkParams addPairing(Pairing var1);

        public BulkParams pairAt(long var1);

        default public BulkParams pairAt(ZonedDateTime zonedDateTime) {
            return this.pairAt(zonedDateTime.toInstant().toEpochMilli());
        }

        public BulkParams startClocksAt(long var1);

        default public BulkParams startClocksAt(ZonedDateTime zonedDateTime) {
            return this.startClocksAt(zonedDateTime.toInstant().toEpochMilli());
        }

        public BulkParams variant(Enums.VariantName var1);

        default public BulkParams variant(Function<Enums.VariantName.Provider, Enums.VariantName> function) {
            return this.variant(function.apply(Enums.VariantName.provider()));
        }

        public BulkParams fen(String var1);

        public BulkParams message(String var1);

        public BulkParams noAbort();

        public BulkParams noRematch();

        public BulkParams noGiveTime();

        public BulkParams noClaimWin();

        public record Pairing(Supplier<char[]> tokenWhite, Supplier<char[]> tokenBlack) {
        }
    }

    public static interface BulkBuilder
    extends Builders.Clock<BulkParams>,
    Builders.ClockCorrespondence<BulkParams> {
    }
}

