/*
 * Decompiled with CFR 0.152.
 */
package chariot.api;

import chariot.model.Ack;
import chariot.model.Enums;
import chariot.model.Game;
import chariot.model.GameImport;
import chariot.model.GameInfo;
import chariot.model.Many;
import chariot.model.MoveInfo;
import chariot.model.One;
import chariot.model.Pgn;
import chariot.model.TVChannels;
import chariot.model.TVFeedEvent;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Games {
    public One<Game> byGameId(String var1, Consumer<GameParams> var2);

    default public One<Game> byGameId(String string) {
        return this.byGameId(string, gameParams -> {});
    }

    public One<Pgn> pgnByGameId(String var1, Consumer<GameParams> var2);

    default public One<Pgn> pgnByGameId(String string) {
        return this.pgnByGameId(string, gameParams -> {});
    }

    public One<Game> currentByUserId(String var1, Consumer<GameParams> var2);

    default public One<Game> currentByUserId(String string) {
        return this.currentByUserId(string, gameParams -> {});
    }

    public One<Pgn> pgnCurrentByUserId(String var1, Consumer<GameParams> var2);

    default public One<Pgn> pgnCurrentByUserId(String string) {
        return this.pgnCurrentByUserId(string, gameParams -> {});
    }

    public Many<Game> byUserId(String var1, Consumer<SearchFilter> var2);

    default public Many<Game> byUserId(String string) {
        return this.byUserId(string, searchFilter -> {});
    }

    public Many<Pgn> pgnByUserId(String var1, Consumer<SearchFilter> var2);

    default public Many<Pgn> pgnByUserId(String string) {
        return this.pgnByUserId(string, searchFilter -> {});
    }

    public Many<Game> byGameIds(Set<String> var1, Consumer<GameParams> var2);

    default public Many<Game> byGameIds(Consumer<GameParams> consumer, String ... stringArray) {
        return this.byGameIds(Set.of(stringArray), consumer);
    }

    default public Many<Game> byGameIds(String ... stringArray) {
        return this.byGameIds(Set.of(stringArray));
    }

    default public Many<Game> byGameIds(Set<String> set) {
        return this.byGameIds(set, (GameParams gameParams) -> {});
    }

    public Many<Pgn> pgnByGameIds(Set<String> var1, Consumer<GameParams> var2);

    default public Many<Pgn> pgnByGameIds(Consumer<GameParams> consumer, String ... stringArray) {
        return this.pgnByGameIds(Set.of(stringArray), consumer);
    }

    default public Many<Pgn> pgnByGameIds(String ... stringArray) {
        return this.pgnByGameIds(Set.of(stringArray));
    }

    default public Many<Pgn> pgnByGameIds(Set<String> set) {
        return this.pgnByGameIds(set, (GameParams gameParams) -> {});
    }

    public One<GameImport> importGame(String var1);

    public Many<Game> byChannel(Enums.Channel var1, Consumer<ChannelFilter> var2);

    default public Many<Game> byChannel(Enums.Channel channel) {
        return this.byChannel(channel, (ChannelFilter channelFilter) -> {});
    }

    default public Many<Game> byChannel(Function<Enums.Channel.Provider, Enums.Channel> function) {
        return this.byChannel(function.apply(Enums.Channel.provider()));
    }

    default public Many<Game> byChannel(Function<Enums.Channel.Provider, Enums.Channel> function, Consumer<ChannelFilter> consumer) {
        return this.byChannel(function.apply(Enums.Channel.provider()), consumer);
    }

    public Many<Pgn> pgnByChannel(Enums.Channel var1, Consumer<ChannelFilter> var2);

    default public Many<Pgn> pgnByChannel(Enums.Channel channel) {
        return this.pgnByChannel(channel, (ChannelFilter channelFilter) -> {});
    }

    default public Many<Pgn> pgnByChannel(Function<Enums.Channel.Provider, Enums.Channel> function) {
        return this.pgnByChannel(function.apply(Enums.Channel.provider()));
    }

    default public Many<Pgn> pgnByChannel(Function<Enums.Channel.Provider, Enums.Channel> function, Consumer<ChannelFilter> consumer) {
        return this.pgnByChannel(function.apply(Enums.Channel.provider()), consumer);
    }

    public One<TVChannels> tvChannels();

    public Many<TVFeedEvent> tvFeed();

    public Many<GameInfo> gameInfosByUserIds(Set<String> var1, Consumer<GamesParameters> var2);

    default public Many<GameInfo> gameInfosByUserIds(Set<String> set) {
        return this.gameInfosByUserIds(set, (GamesParameters gamesParameters) -> {});
    }

    default public Many<GameInfo> gameInfosByUserIds(String ... stringArray) {
        return this.gameInfosByUserIds(Set.of(stringArray));
    }

    public Many<GameInfo> gameInfosByGameIds(String var1, Set<String> var2);

    default public Many<GameInfo> gameInfosByGameIds(String string, String ... stringArray) {
        return this.gameInfosByGameIds(string, Set.of(stringArray));
    }

    public One<Ack> addGameIdsToStream(String var1, Set<String> var2);

    default public One<Ack> addGameIdsToStream(String string, String ... stringArray) {
        return this.addGameIdsToStream(string, Set.of(stringArray));
    }

    public Many<MoveInfo> moveInfosByGameId(String var1);

    public static interface ChannelFilter
    extends CommonGameParameters<ChannelFilter> {
        public ChannelFilter nb(int var1);
    }

    public static interface SearchFilter
    extends CommonGameParameters<SearchFilter>,
    EvalsAndPlayers<SearchFilter> {
        public SearchFilter since(long var1);

        default public SearchFilter since(ZonedDateTime zonedDateTime) {
            return this.since(SearchFilter.zdtToMillis(zonedDateTime));
        }

        public SearchFilter until(long var1);

        default public SearchFilter until(ZonedDateTime zonedDateTime) {
            return this.until(SearchFilter.zdtToMillis(zonedDateTime));
        }

        public SearchFilter max(int var1);

        public SearchFilter vs(String var1);

        public SearchFilter rated(boolean var1);

        default public SearchFilter rated() {
            return this.rated(true);
        }

        public SearchFilter color(Enums.Color var1);

        default public SearchFilter color(Function<Enums.Color.Provider, Enums.Color> function) {
            return this.color(function.apply(Enums.Color.provider()));
        }

        public SearchFilter analyzed(boolean var1);

        default public SearchFilter analyzed() {
            return this.analyzed(true);
        }

        public SearchFilter perfType(Enums.PerfType ... var1);

        default public SearchFilter perfType(Set<Function<Enums.PerfType.Provider, Enums.PerfType>> set) {
            return this.perfType(set.stream().map(function -> (Enums.PerfType)((Object)((Object)function.apply(Enums.PerfType.provider())))).toList().toArray(new Enums.PerfType[0]));
        }

        public SearchFilter ongoing(boolean var1);

        default public SearchFilter ongoing() {
            return this.ongoing(true);
        }

        public SearchFilter finished(boolean var1);

        default public SearchFilter finished() {
            return this.finished(true);
        }

        public SearchFilter sortAscending(boolean var1);

        default public SearchFilter sortAscending() {
            return this.sortAscending(true);
        }

        public SearchFilter literate(boolean var1);

        default public SearchFilter literate() {
            return this.literate(true);
        }

        public SearchFilter lastFen(boolean var1);

        default public SearchFilter lastFen() {
            return this.lastFen(true);
        }

        private static long zdtToMillis(ZonedDateTime zonedDateTime) {
            return zonedDateTime.toInstant().getEpochSecond() * 1000L;
        }
    }

    public static interface GameParams
    extends CommonGameParameters<GameParams>,
    EvalsAndPlayers<GameParams> {
        public GameParams literate(boolean var1);

        default public GameParams literate() {
            return this.literate(true);
        }
    }

    public static interface Filter
    extends CommonGameParameters<Filter> {
        public Filter player(String var1);
    }

    public static interface EvalsAndPlayers<T> {
        public T evals(boolean var1);

        default public T evals() {
            return this.evals(true);
        }

        public T players(URL var1);
    }

    public static interface CommonGameParameters<T> {
        public T moves(boolean var1);

        default public T moves() {
            return this.moves(true);
        }

        public T pgn(boolean var1);

        default public T pgn() {
            return this.pgn(true);
        }

        @Deprecated
        default public T pgnInJson(boolean bl) {
            return this.pgn(bl);
        }

        public T tags(boolean var1);

        default public T tags() {
            return this.tags(true);
        }

        public T clocks(boolean var1);

        default public T clocks() {
            return this.clocks(true);
        }

        public T opening(boolean var1);

        default public T opening() {
            return this.opening(true);
        }

        public T accuracy(boolean var1);

        default public T accuracy() {
            return this.accuracy(true);
        }
    }

    public static interface GamesParameters {
        public GamesParameters withCurrentGames(boolean var1);

        default public GamesParameters withCurrentGames() {
            return this.withCurrentGames(true);
        }
    }
}

