/*
 * Decompiled with CFR 0.152.
 */
package chariot.api;

import chariot.model.Enums;
import chariot.model.ExploreResult;
import chariot.model.One;
import chariot.model.Pgn;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface OpeningExplorer {
    public One<Pgn> pgnByMastersGameId(String var1);

    public One<ExploreResult.OpeningDB> masters(Consumer<MastersBuilder> var1);

    default public One<ExploreResult.OpeningDB> masters() {
        return this.masters(mastersBuilder -> {});
    }

    public One<ExploreResult.OpeningDB> lichess(Consumer<LichessBuilder> var1);

    default public One<ExploreResult.OpeningDB> lichess() {
        return this.lichess(lichessBuilder -> {});
    }

    public One<ExploreResult.HistoryStats> lichessHistory(Consumer<HistoryBuilder> var1);

    default public One<ExploreResult.HistoryStats> lichessHistory() {
        return this.lichessHistory(historyBuilder -> {});
    }

    public One<ExploreResult.OpeningPlayer> player(String var1, Consumer<PlayerBuilder> var2);

    default public One<ExploreResult.OpeningPlayer> player(String string) {
        return this.player(string, playerBuilder -> {});
    }

    public static interface HistoryBuilder {
        public HistoryBuilder variant(Enums.VariantName var1);

        default public HistoryBuilder variant(Function<Enums.VariantName.Provider, Enums.VariantName> function) {
            return this.variant(function.apply(Enums.VariantName.provider()));
        }

        public HistoryBuilder fen(String var1);

        public HistoryBuilder play(String var1);

        public HistoryBuilder speeds(Set<Enums.Speed> var1);

        default public HistoryBuilder speeds(Enums.Speed ... speedArray) {
            return this.speeds(Set.of(speedArray));
        }

        public LichessBuilder ratings(Set<Enums.RatingGroup> var1);

        default public LichessBuilder ratings(Enums.RatingGroup ... ratingGroupArray) {
            return this.ratings(Set.of(ratingGroupArray));
        }

        public HistoryBuilder since(String var1);

        public HistoryBuilder until(String var1);
    }

    public static interface PlayerBuilder
    extends CommonOpeningExplorer<PlayerBuilder>,
    CommonLichessOpeningExplorer<PlayerBuilder> {
        public PlayerBuilder color(Enums.Color var1);

        public PlayerBuilder modes(Set<Mode> var1);

        default public PlayerBuilder modes(Mode ... modeArray) {
            return this.modes(Set.of(modeArray));
        }

        default public PlayerBuilder modes(Function<Mode.Provider, Mode> ... functionArray) {
            return this.modes(Stream.of(functionArray).map(function -> (Mode)((Object)((Object)function.apply(Mode.provider())))).collect(Collectors.toSet()));
        }

        default public PlayerBuilder color(Function<Enums.Color.Provider, Enums.Color> function) {
            return this.color(function.apply(Enums.Color.provider()));
        }

        public static enum Mode {
            casual,
            rated;


            public static Provider provider() {
                return new Provider(){};
            }

            public static interface Provider {
                default public Mode casual() {
                    return casual;
                }

                default public Mode rated() {
                    return rated;
                }
            }
        }
    }

    public static interface LichessBuilder
    extends CommonOpeningExplorer<LichessBuilder>,
    CommonLichessOpeningExplorer<LichessBuilder> {
        public LichessBuilder topGames(int var1);

        public LichessBuilder ratings(Set<Enums.RatingGroup> var1);

        default public LichessBuilder ratings(Enums.RatingGroup ... ratingGroupArray) {
            return this.ratings(Set.of(ratingGroupArray));
        }
    }

    public static interface MastersBuilder
    extends CommonOpeningExplorer<MastersBuilder> {
        public MastersBuilder since(int var1);

        public MastersBuilder until(int var1);

        public MastersBuilder topGames(int var1);
    }

    public static interface CommonLichessOpeningExplorer<T> {
        public T since(String var1);

        public T until(String var1);

        public T recentGames(int var1);

        public T variant(Enums.VariantName var1);

        public T speeds(Set<Enums.Speed> var1);

        default public T variant(Function<Enums.VariantName.Provider, Enums.VariantName> function) {
            return this.variant(function.apply(Enums.VariantName.provider()));
        }

        default public T speeds(Enums.Speed ... speedArray) {
            return this.speeds(Set.of(speedArray));
        }
    }

    public static interface CommonOpeningExplorer<T> {
        public T fen(String var1);

        public T play(String var1);

        public T moves(int var1);
    }
}

