/*
 * Decompiled with CFR 0.152.
 */
package chariot.api;

import chariot.api.Builders;
import chariot.api.Tournaments;
import chariot.internal.Util;
import chariot.model.Ack;
import chariot.model.Arena;
import chariot.model.Enums;
import chariot.model.One;
import chariot.model.Swiss;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public interface TournamentsAuth
extends Tournaments {
    public One<Arena> createArena(Consumer<ArenaBuilder> var1);

    public One<Arena> updateArena(String var1, Consumer<ArenaBuilder> var2);

    public One<Arena> updateTeamBattle(String var1, int var2, Set<String> var3);

    default public One<Arena> updateTeamBattle(String string, int n, String ... stringArray) {
        return this.updateTeamBattle(string, n, Set.of(stringArray));
    }

    public One<Ack> terminateArena(String var1);

    public One<Ack> joinArena(String var1, Consumer<JoinArenaParams> var2);

    default public One<Ack> joinArena(String string) {
        return this.joinArena(string, joinArenaParams -> {});
    }

    public One<Ack> withdrawArena(String var1);

    public One<Swiss> createSwiss(String var1, Consumer<SwissBuilder> var2);

    public One<Swiss> updateSwiss(String var1, Consumer<SwissBuilder> var2);

    public One<Ack> terminateSwiss(String var1);

    public One<Ack> withdrawSwiss(String var1);

    public One<Ack> joinSwiss(String var1, Consumer<JoinSwissParams> var2);

    default public One<Ack> joinSwiss(String string) {
        return this.joinSwiss(string, joinSwissParams -> {});
    }

    default public Map<String, String> generateUserEntryCodes(String string, Set<String> set) {
        return Util.generateUserEntryCodes(string, set);
    }

    default public String generateUserEntryCode(String string, String string2) {
        return Util.generateUserEntryCodes(string, Set.of(string2)).get(string2);
    }

    public static interface JoinSwissParams {
        public JoinSwissParams entryCode(String var1);
    }

    public static interface SwissParams {
        public SwissParams nbRounds(int var1);

        public SwissParams name(String var1);

        public SwissParams rated(boolean var1);

        default public SwissParams rated() {
            return this.rated(true);
        }

        public SwissParams startsAt(long var1);

        default public SwissParams startsAt(ZonedDateTime zonedDateTime) {
            return this.startsAt(zonedDateTime.toInstant().toEpochMilli());
        }

        public SwissParams roundInterval(int var1);

        public SwissParams variant(Enums.VariantName var1);

        default public SwissParams variant(Function<Enums.VariantName.Provider, Enums.VariantName> function) {
            return this.variant(function.apply(Enums.VariantName.provider()));
        }

        public SwissParams description(String var1);

        public SwissParams entryCode(String var1);

        public SwissParams chatFor(Enums.ChatFor var1);

        default public SwissParams chatFor(Function<Enums.ChatFor.Provider, Enums.ChatFor> function) {
            return this.chatFor(function.apply(Enums.ChatFor.provider()));
        }

        public SwissParams allowList(List<String> var1);

        default public SwissParams addForbiddenPairing(String string, String string2) {
            return this.addForbiddenPairings(Set.of(new Pairing(string, string2)));
        }

        default public SwissParams addForbiddenPairing(Pairing pairing) {
            return this.addForbiddenPairings(Set.of(pairing));
        }

        public SwissParams addForbiddenPairings(Collection<Pairing> var1);

        default public SwissParams addManualPairing(String string, String string2) {
            return this.addManualPairings(Set.of(new Pairing(string, string2)));
        }

        default public SwissParams addManualPairing(Pairing pairing) {
            return this.addManualPairings(Set.of(pairing));
        }

        public SwissParams addManualPairings(Collection<Pairing> var1);

        public record Pairing(String player1, String player2) {
        }
    }

    public static interface SwissBuilder
    extends Builders.Clock<SwissParams> {
    }

    public static interface JoinArenaParams {
        public JoinArenaParams entryCode(String var1);

        public JoinArenaParams team(String var1);

        public JoinArenaParams pairMeAsap(boolean var1);

        default public JoinArenaParams pairMeAsap() {
            return this.pairMeAsap(true);
        }
    }

    public static interface ArenaParams {
        public ArenaParams name(String var1);

        public ArenaParams minutes(int var1);

        public ArenaParams startTime(Function<StartTime.Provider, StartTime> var1);

        default public ArenaParams startTime(ZonedDateTime zonedDateTime) {
            return this.startTime((StartTime.Provider provider) -> provider.atDate(zonedDateTime));
        }

        public ArenaParams variant(Enums.VariantName var1);

        public ArenaParams rated(boolean var1);

        default public ArenaParams rated() {
            return this.rated(true);
        }

        public ArenaParams position(String var1);

        public ArenaParams berserkable(boolean var1);

        default public ArenaParams berserkable() {
            return this.berserkable(true);
        }

        public ArenaParams streakable(boolean var1);

        default public ArenaParams streakable() {
            return this.streakable(true);
        }

        public ArenaParams hasChat(boolean var1);

        default public ArenaParams hasChat() {
            return this.hasChat(true);
        }

        public ArenaParams description(String var1);

        public ArenaParams entryCode(String var1);

        @Deprecated
        default public ArenaParams password(String string) {
            return this.entryCode(string);
        }

        public ArenaParams teamBattleByTeam(String var1);

        public ArenaParams conditionTeam(String var1);

        public ArenaParams conditionMinRating(int var1);

        public ArenaParams conditionMaxRating(int var1);

        public ArenaParams conditionMinRatedGames(int var1);

        public ArenaParams allowList(List<String> var1);

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface StartTime {
            public static Provider provider() {
                return new Provider(){};
            }

            public record AtDate(long startDate) implements StartTime
            {
            }

            public record InMinutes(int waitMinutes) implements StartTime
            {
            }

            public static interface Provider {
                default public StartTime inMinutes(int n) {
                    return new InMinutes(n);
                }

                default public StartTime atDate(ZonedDateTime zonedDateTime) {
                    return new AtDate(zonedDateTime.toInstant().toEpochMilli());
                }

                default public StartTime atDate(long l) {
                    return new AtDate(l);
                }
            }
        }
    }

    public static interface ArenaBuilder
    extends Builders.ClockMinute<ArenaParams> {
    }
}

