/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.Client;
import chariot.api.Builders;
import chariot.internal.Crypt;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Config {
    public static final String lichess = "https://lichess.org";
    public static final String explorer = "https://explorer.lichess.ovh";
    public static final String tablebase = "https://tablebase.lichess.ovh";
    public static final String engine = "https://engine.lichess.ovh";
    public static final String local = "http://localhost:9663";

    public static Basic api(String string) {
        return Config.basic(builder -> builder.api(string));
    }

    public static Basic basic(Consumer<Builders.Builder> consumer) {
        BuilderImpl builderImpl = new BuilderImpl();
        consumer.accept(builderImpl);
        return builderImpl.build();
    }

    public static Auth auth(Consumer<Builders.TokenBuilder> consumer) {
        TokenBuilderImpl tokenBuilderImpl = new TokenBuilderImpl();
        consumer.accept(tokenBuilderImpl);
        Auth auth = tokenBuilderImpl.buildAuth();
        if (auth == null) {
            throw new IllegalArgumentException("Missing token");
        }
        return auth;
    }

    public boolean isAuth();

    public void store(Preferences var1);

    public int retries();

    public Servers servers();

    public Logging logging();

    public static Config load(Preferences preferences) {
        Basic basic = Config.loadBasic(preferences);
        return basic.withAuth(preferences).orElse(basic);
    }

    public static Auth load(Preferences preferences, Consumer<Builders.AuthBuilder> consumer) {
        TokenBuilderImpl tokenBuilderImpl = new TokenBuilderImpl();
        consumer.accept(tokenBuilderImpl);
        Auth auth = tokenBuilderImpl.buildAuth(Config.loadBasic(preferences));
        return auth;
    }

    private static Basic loadBasic(Preferences preferences) {
        Objects.requireNonNull(preferences);
        return Config.basic(builder -> builder.api(preferences.get("api", lichess)).servers(extServBuilder -> extServBuilder.explorer(preferences.get("explorer", explorer)).tablebase(preferences.get("tablebase", tablebase)).engine(preferences.get("engine", engine))).logging(logSetter -> logSetter.request().warning().response().warning().auth().off()));
    }

    public static void clearAuth(Preferences preferences) {
        preferences.remove("omni_");
        preferences.remove("pre_");
        try {
            Arrays.stream(preferences.keys()).filter(string -> string.startsWith("pre_")).forEach(string -> preferences.remove((String)string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            preferences.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public record Basic(Servers servers, Logging logging, int retries) implements Config
    {
        @Override
        public boolean isAuth() {
            return false;
        }

        public Auth withAuth(Supplier<char[]> supplier) {
            return new Auth(this, new TokenType.OmniToken(supplier));
        }

        public Auth withAuth(Set<Supplier<char[]>> set) {
            return new Auth(this, new TokenType.AutoScopedTokens(this.logging().auth(), Collections.unmodifiableSet(set), new HashMap<Client.Scope, Set<Supplier<char[]>>>()));
        }

        public Auth withAuth(Map<Client.Scope, Supplier<char[]>> map) {
            return new Auth(this, new TokenType.PreScopedTokens(Collections.unmodifiableMap(map)));
        }

        public Auth withAuth(String string) {
            return this.withAuth(string.toCharArray());
        }

        public Auth withAuth(char[] cArray) {
            Crypt.Result result = Crypt.encrypt(cArray);
            return new Auth(this, new TokenType.OmniToken(() -> Crypt.decrypt(result.data(), result.key())));
        }

        @Override
        public void store(Preferences preferences) {
            Server.Url url;
            preferences.put("api", this.servers().api().get());
            Server server = this.servers().explorer();
            if (server instanceof Server.Url) {
                url = (Server.Url)server;
                preferences.put("explorer", url.url);
            } else {
                preferences.remove("explorer");
            }
            server = this.servers().tablebase();
            if (server instanceof Server.Url) {
                url = (Server.Url)server;
                preferences.put("tablebase", url.url);
            } else {
                preferences.remove("tablebase");
            }
            server = this.servers().engine();
            if (server instanceof Server.Url) {
                url = (Server.Url)server;
                preferences.put("engine", url.url);
            } else {
                preferences.remove("engine");
            }
            preferences.put("chariot.request", this.logging().request().getLevel().toString());
            preferences.put("chariot.response-body-raw", this.logging().responsebodyraw().getLevel().toString());
            preferences.put("chariot.auth", this.logging().auth().getLevel().toString());
        }

        Optional<Config> withAuth(Preferences preferences) {
            Optional<Config> optional = Basic.pref(preferences, "omni_").map(string -> {
                Crypt.Result result = Crypt.encrypt(string.toCharArray());
                return this.withAuth(() -> Crypt.decrypt(result.data(), result.key()));
            });
            if (optional.isPresent()) {
                return optional;
            }
            Optional<Config> optional2 = Basic.pref(preferences, "pre_").map(string -> {
                HashMap<Client.Scope, Supplier<char[]>> hashMap = new HashMap<Client.Scope, Supplier<char[]>>();
                String[] stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    Crypt.Result result = Crypt.encrypt(stringArray[i].toCharArray());
                    Supplier<char[]> supplier = () -> Crypt.decrypt(result.data(), result.key());
                    String[] stringArray2 = preferences.get("pre_" + (i + 1), null).split(",");
                    for (int j = 0; j < stringArray2.length; ++j) {
                        hashMap.put(Client.Scope.fromString(stringArray2[j]).get(), supplier);
                    }
                }
                return this.withAuth(hashMap);
            });
            return optional2;
        }

        private static Optional<String> pref(Preferences preferences, String string) {
            return Optional.ofNullable(preferences.get(string, null));
        }
    }

    public static class BuilderImpl
    implements Builders.Builder {
        SBuilderImpl sbuilder = new SBuilderImpl();
        LBuilderImpl lbuilder = new LBuilderImpl();
        Server api = Server.of("https://lichess.org");
        int retries = 1;

        @Override
        public Builders.Builder api(String string) {
            this.api = Server.of(string);
            return this;
        }

        @Override
        public Builders.Builder servers(Consumer<Builders.ExtServBuilder> consumer) {
            consumer.accept(this.sbuilder);
            return this;
        }

        @Override
        public Builders.Builder logging(Consumer<Builders.LogSetter> consumer) {
            consumer.accept(this.lbuilder);
            return this;
        }

        @Override
        public Builders.Builder retries(int n) {
            this.retries = n < 0 ? 0 : n;
            return this;
        }

        Basic build() {
            return new Basic(this.sbuilder.build(this.api), this.lbuilder.build(), this.retries);
        }
    }

    public static class TokenBuilderImpl
    extends BuilderImpl
    implements Builders.TokenBuilder {
        Supplier<char[]> token = null;
        Set<Supplier<char[]>> tokens = null;
        Map<Client.Scope, Supplier<char[]>> mappedTokens = null;

        @Override
        public Builders.TokenBuilder api(String string) {
            super.api(string);
            return this;
        }

        @Override
        public Builders.TokenBuilder servers(Consumer<Builders.ExtServBuilder> consumer) {
            super.servers(consumer);
            return this;
        }

        @Override
        public Builders.TokenBuilder logging(Consumer<Builders.LogSetter> consumer) {
            super.logging(consumer);
            return this;
        }

        @Override
        public Builders.TokenBuilder auth(Supplier<char[]> supplier) {
            this.token = supplier;
            return this;
        }

        @Override
        public Builders.TokenBuilder auth(Set<Supplier<char[]>> set) {
            this.tokens = set;
            return this;
        }

        @Override
        public Builders.TokenBuilder auth(Map<Client.Scope, Supplier<char[]>> map) {
            this.mappedTokens = map;
            return this;
        }

        Auth buildAuth() {
            Basic basic = super.build();
            return this.buildAuth(basic);
        }

        Auth buildAuth(Basic basic) {
            if (this.token != null) {
                return basic.withAuth(this.token);
            }
            if (this.tokens != null) {
                return basic.withAuth(this.tokens);
            }
            if (this.mappedTokens != null) {
                return basic.withAuth(this.mappedTokens);
            }
            return null;
        }
    }

    public record Auth(Basic basic, TokenType type) implements Config
    {
        @Override
        public boolean isAuth() {
            return true;
        }

        @Override
        public Logging logging() {
            return this.basic().logging();
        }

        @Override
        public Servers servers() {
            return this.basic().servers();
        }

        @Override
        public int retries() {
            return this.basic().retries();
        }

        @Override
        public void store(Preferences preferences) {
            this.basic.store(preferences);
            TokenType tokenType = this.type;
            if (tokenType instanceof TokenType.OmniToken) {
                TokenType.OmniToken omniToken = (TokenType.OmniToken)tokenType;
                preferences.put("omni_", String.valueOf(omniToken.token().get()));
                return;
            }
            Optional<Object> optional = Optional.empty();
            Object object = this.type;
            if (object instanceof TokenType.PreScopedTokens) {
                tokenType = (TokenType.PreScopedTokens)object;
                optional = Optional.of(((TokenType.PreScopedTokens)tokenType).tokens());
            } else {
                object = this.type;
                if (object instanceof TokenType.AutoScopedTokens) {
                    TokenType.AutoScopedTokens autoScopedTokens = (TokenType.AutoScopedTokens)object;
                    object = autoScopedTokens.cache().entrySet().stream().collect(Collectors.toMap(entry -> (Client.Scope)((Object)((Object)entry.getKey())), entry -> ((Set)entry.getValue()).stream().findAny()));
                    optional = Optional.of(object.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(entry -> (Client.Scope)((Object)((Object)entry.getKey())), entry -> (Supplier)((Optional)entry.getValue()).get())));
                }
            }
            optional.ifPresent(map -> {
                Map<Client.Scope, String> map2 = map.entrySet().stream().collect(Collectors.toMap(entry -> (Client.Scope)((Object)((Object)((Object)entry.getKey()))), entry -> String.valueOf((char[])((Supplier)entry.getValue()).get())));
                List<String> list = map2.values().stream().toList();
                preferences.put("pre_", String.join((CharSequence)",", list));
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i);
                    String string2 = map2.entrySet().stream().filter(entry -> string.equals(entry.getValue())).map(entry -> ((Client.Scope)((Object)((Object)((Object)entry.getKey())))).asString()).collect(Collectors.joining(","));
                    preferences.put("pre_" + (i + 1), string2);
                }
            });
        }
    }

    public static class LogLevelImpl
    implements Builders.LogLevel {
        private final Logger logger;
        private final Builders.LogSetter setter;

        private LogLevelImpl(Builders.LogSetter logSetter, Logger logger) {
            this.setter = logSetter;
            this.logger = logger;
        }

        @Override
        public Builders.LogSetter all() {
            this.logger.setLevel(Level.ALL);
            return this.setter;
        }

        @Override
        public Builders.LogSetter finest() {
            this.logger.setLevel(Level.FINEST);
            return this.setter;
        }

        @Override
        public Builders.LogSetter finer() {
            this.logger.setLevel(Level.FINER);
            return this.setter;
        }

        @Override
        public Builders.LogSetter fine() {
            this.logger.setLevel(Level.FINE);
            return this.setter;
        }

        @Override
        public Builders.LogSetter config() {
            this.logger.setLevel(Level.CONFIG);
            return this.setter;
        }

        @Override
        public Builders.LogSetter info() {
            this.logger.setLevel(Level.INFO);
            return this.setter;
        }

        @Override
        public Builders.LogSetter warning() {
            this.logger.setLevel(Level.WARNING);
            return this.setter;
        }

        @Override
        public Builders.LogSetter severe() {
            this.logger.setLevel(Level.SEVERE);
            return this.setter;
        }

        @Override
        public Builders.LogSetter off() {
            this.logger.setLevel(Level.OFF);
            return this.setter;
        }
    }

    public static class LBuilderImpl
    implements Builders.LogSetter {
        private static int num = 0;
        final Logging logging;

        LBuilderImpl() {
            this(new Logging(Logger.getLogger("chariot.request." + num), Logger.getLogger("chariot.response-body-raw." + num), Logger.getLogger("chariot.auth." + num)));
            ++num;
            this.logging.request().setLevel(Level.WARNING);
            this.logging.responsebodyraw().setLevel(Level.WARNING);
            this.logging.auth().setLevel(Level.OFF);
        }

        public LBuilderImpl(Logging logging) {
            this.logging = logging;
        }

        Logging build() {
            return this.logging;
        }

        @Override
        public Builders.LogLevel request() {
            return new LogLevelImpl(this, this.logging.request());
        }

        @Override
        public Builders.LogLevel response() {
            return new LogLevelImpl(this, this.logging.responsebodyraw());
        }

        @Override
        public Builders.LogLevel auth() {
            return new LogLevelImpl(this, this.logging.auth());
        }
    }

    public static class SBuilderImpl
    implements Builders.ExtServBuilder {
        Map<String, Server> map = new HashMap<String, Server>();

        @Override
        public Builders.ExtServBuilder explorer(String string) {
            this.map.put("explorer", Server.of(string));
            return this;
        }

        @Override
        public Builders.ExtServBuilder tablebase(String string) {
            this.map.put("tablebase", Server.of(string));
            return this;
        }

        @Override
        public Builders.ExtServBuilder engine(String string) {
            this.map.put("engine", Server.of(string));
            return this;
        }

        Servers build(Server server) {
            Servers servers = new Servers(server, this.map.get("explorer"), this.map.get("tablebase"), this.map.get("engine"));
            return servers;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TokenType {
        public Optional<Supplier<char[]>> getToken(Client.Scope var1);

        public record PreScopedTokens(Map<Client.Scope, Supplier<char[]>> tokens) implements TokenType
        {
            @Override
            public Optional<Supplier<char[]>> getToken(Client.Scope scope) {
                return Optional.ofNullable(this.tokens().get((Object)scope));
            }
        }

        public record AutoScopedTokens(Logger authlog, Set<Supplier<char[]>> tokens, Map<Client.Scope, Set<Supplier<char[]>>> cache) implements TokenType
        {
            @Override
            public Optional<Supplier<char[]>> getToken(Client.Scope scope2) {
                return this.cache.computeIfAbsent(scope2, scope -> new HashSet()).stream().findAny();
            }

            public void resolve(Function<Supplier<char[]>, Set<Client.Scope>> function) {
                this.tokens().forEach(supplier -> ((Set)function.apply((Supplier<char[]>)supplier)).forEach(arg_0 -> this.lambda$resolve$3((Supplier)supplier, arg_0)));
                this.authlog().info(this.cache().entrySet().stream().map(entry -> "[%s] [%s]".formatted(entry.getKey(), ((Set)entry.getValue()).stream().map(supplier -> "%s".formatted(String.valueOf((char[])supplier.get()))).collect(Collectors.joining(",")))).collect(Collectors.joining("\n")));
            }

            private /* synthetic */ void lambda$resolve$3(Supplier supplier, Client.Scope scope2) {
                this.authlog().info(() -> AutoScopedTokens.lambda$resolve$1(scope2, (Supplier)supplier));
                this.cache().computeIfAbsent(scope2, scope -> new HashSet()).add(supplier);
            }

            private static /* synthetic */ String lambda$resolve$1(Client.Scope scope, Supplier supplier) {
                return "AutoScope [%s] [%s]".formatted(new Object[]{scope, String.valueOf((char[])supplier.get())});
            }
        }

        public record OmniToken(Supplier<char[]> token) implements TokenType
        {
            @Override
            public Optional<Supplier<char[]>> getToken(Client.Scope scope) {
                return Optional.ofNullable(this.token());
            }
        }
    }

    public static enum ServerType {
        api,
        explorer,
        tablebase,
        engine;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Server {
        public static Server of(String string) {
            return new Url(string);
        }

        public static Server none() {
            return new None();
        }

        default public void ifPresent(Consumer<String> consumer) {
            Server server = this;
            if (server instanceof Url) {
                Url url = (Url)server;
                consumer.accept(url.url());
            }
        }

        default public String get() {
            Server server = this;
            if (server instanceof Url) {
                Url url = (Url)server;
                return url.url();
            }
            throw new NoSuchElementException();
        }

        public record Url(String url) implements Server
        {
            public Url {
                Objects.requireNonNull(string);
                URI.create(string);
            }
        }

        public record None() implements Server
        {
        }
    }

    public record Logging(Logger request, Logger responsebodyraw, Logger auth) {
    }

    public record Servers(Server api, Server explorer, Server tablebase, Server engine) {
    }
}

