/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.api.AccountAuth;
import chariot.api.AdminAuth;
import chariot.api.Analysis;
import chariot.api.BoardAuth;
import chariot.api.BotAuth;
import chariot.api.BroadcastsAuth;
import chariot.api.ChallengesAuth;
import chariot.api.Custom;
import chariot.api.ExternalEngineAuth;
import chariot.api.GamesAuth;
import chariot.api.OpeningExplorer;
import chariot.api.PuzzlesAuth;
import chariot.api.Simuls;
import chariot.api.Studies;
import chariot.api.Tablebase;
import chariot.api.TeamsAuth;
import chariot.api.TournamentsAuth;
import chariot.api.UsersAuth;
import chariot.internal.Config;
import chariot.internal.InternalClient;
import chariot.internal.impl.AccountAuthImpl;
import chariot.internal.impl.AdminAuthImpl;
import chariot.internal.impl.AnalysisImpl;
import chariot.internal.impl.BoardAuthImpl;
import chariot.internal.impl.BotAuthImpl;
import chariot.internal.impl.BroadcastsAuthImpl;
import chariot.internal.impl.ChallengesAuthImpl;
import chariot.internal.impl.CustomImpl;
import chariot.internal.impl.ExternalEngineAuthImpl;
import chariot.internal.impl.GamesAuthImpl;
import chariot.internal.impl.OpeningExplorerImpl;
import chariot.internal.impl.PuzzlesAuthImpl;
import chariot.internal.impl.SimulsImpl;
import chariot.internal.impl.StudiesImpl;
import chariot.internal.impl.TablebaseImpl;
import chariot.internal.impl.TeamsAuthImpl;
import chariot.internal.impl.TournamentsAuthImpl;
import chariot.internal.impl.UsersAuthImpl;
import java.util.prefs.Preferences;

public class DefaultClient {
    private final InternalClient client;
    private final Config config;
    private final AccountAuthImpl account;
    private final AdminAuthImpl admin;
    private final AnalysisImpl analysis;
    private final BoardAuthImpl board;
    private final BotAuthImpl bot;
    private final BroadcastsAuthImpl broadcasts;
    private final ChallengesAuthImpl challenges;
    private final CustomImpl custom;
    private final ExternalEngineAuthImpl externalEngine;
    private final GamesAuthImpl games;
    private final OpeningExplorerImpl openingExplorer;
    private final PuzzlesAuthImpl puzzles;
    private final SimulsImpl simuls;
    private final StudiesImpl studies;
    private final TablebaseImpl tablebase;
    private final TeamsAuthImpl teams;
    private final TournamentsAuthImpl tournaments;
    private final UsersAuthImpl users;

    public DefaultClient(Config config) {
        Config.Auth auth;
        Config.TokenType tokenType;
        this.config = config;
        this.client = new InternalClient(config);
        this.account = new AccountAuthImpl(this.client);
        if (config instanceof Config.Auth && (tokenType = (auth = (Config.Auth)config).type()) instanceof Config.TokenType.AutoScopedTokens) {
            Config.TokenType.AutoScopedTokens autoScopedTokens = (Config.TokenType.AutoScopedTokens)tokenType;
            autoScopedTokens.resolve(this.account::scopes);
        }
        this.admin = new AdminAuthImpl(this.client);
        this.analysis = new AnalysisImpl(this.client);
        this.challenges = new ChallengesAuthImpl(this.client);
        this.custom = new CustomImpl(this.client);
        this.board = new BoardAuthImpl(this.client);
        this.bot = new BotAuthImpl(this.client);
        this.broadcasts = new BroadcastsAuthImpl(this.client);
        this.externalEngine = new ExternalEngineAuthImpl(this.client);
        this.games = new GamesAuthImpl(this.client);
        this.openingExplorer = new OpeningExplorerImpl(this.client);
        this.puzzles = new PuzzlesAuthImpl(this.client);
        this.simuls = new SimulsImpl(this.client);
        this.studies = new StudiesImpl(this.client);
        this.tablebase = new TablebaseImpl(this.client);
        this.teams = new TeamsAuthImpl(this.client);
        this.tournaments = new TournamentsAuthImpl(this.client);
        this.users = new UsersAuthImpl(this.client);
    }

    public AccountAuth account() {
        return this.account;
    }

    public AdminAuth admin() {
        return this.admin;
    }

    public Analysis analysis() {
        return this.analysis;
    }

    public BoardAuth board() {
        return this.board;
    }

    public BotAuth bot() {
        return this.bot;
    }

    public BroadcastsAuth broadcasts() {
        return this.broadcasts;
    }

    public ChallengesAuth challenges() {
        return this.challenges;
    }

    public Custom custom() {
        return this.custom;
    }

    public ExternalEngineAuth externalEngine() {
        return this.externalEngine;
    }

    public GamesAuth games() {
        return this.games;
    }

    public OpeningExplorer openingExplorer() {
        return this.openingExplorer;
    }

    public PuzzlesAuth puzzles() {
        return this.puzzles;
    }

    public Simuls simuls() {
        return this.simuls;
    }

    public Studies studies() {
        return this.studies;
    }

    public Tablebase tablebase() {
        return this.tablebase;
    }

    public TeamsAuth teams() {
        return this.teams;
    }

    public TournamentsAuth tournaments() {
        return this.tournaments;
    }

    public UsersAuth users() {
        return this.users;
    }

    public Config config() {
        return this.config;
    }

    public boolean store(Preferences preferences) {
        this.config.store(preferences);
        try {
            preferences.flush();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

