/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.Client;
import chariot.internal.Config;
import chariot.internal.ModelMapper;
import chariot.internal.RequestParameters;
import chariot.internal.RequestResult;
import chariot.internal.Util;
import chariot.model.AccountEmail;
import chariot.model.AccountKid;
import chariot.model.AccountPreferences;
import chariot.model.Ack;
import chariot.model.Activity;
import chariot.model.Analysis;
import chariot.model.Arena;
import chariot.model.ArenaResult;
import chariot.model.Broadcast;
import chariot.model.BulkPairing;
import chariot.model.Challenge;
import chariot.model.ChallengeAI;
import chariot.model.ChallengeOpenEnded;
import chariot.model.ChallengeResult;
import chariot.model.ChallengeTokens;
import chariot.model.ChatMessage;
import chariot.model.Crosstable;
import chariot.model.Err;
import chariot.model.Event;
import chariot.model.ExploreResult;
import chariot.model.ExternalEngineAnalysis;
import chariot.model.ExternalEngineInfo;
import chariot.model.ExternalEngineRequest;
import chariot.model.Game;
import chariot.model.GameEvent;
import chariot.model.GameImport;
import chariot.model.GameInfo;
import chariot.model.Leaderboard;
import chariot.model.LightUserWithStatus;
import chariot.model.Many;
import chariot.model.MoveInfo;
import chariot.model.MyGameInfo;
import chariot.model.One;
import chariot.model.PageTeam;
import chariot.model.PendingChallenges;
import chariot.model.PerfStat;
import chariot.model.Pgn;
import chariot.model.Puzzle;
import chariot.model.PuzzleActivity;
import chariot.model.PuzzleDashboard;
import chariot.model.PuzzleRace;
import chariot.model.RatingHistory;
import chariot.model.SeekAck;
import chariot.model.Simuls;
import chariot.model.StormDashboard;
import chariot.model.StreamerStatus;
import chariot.model.Swiss;
import chariot.model.SwissResult;
import chariot.model.TVChannels;
import chariot.model.TVFeedEvent;
import chariot.model.TablebaseResult;
import chariot.model.Team;
import chariot.model.TeamBattleResults;
import chariot.model.TeamRequest;
import chariot.model.TokenBulkResult;
import chariot.model.TokenResult;
import chariot.model.Tournament;
import chariot.model.TournamentStatus;
import chariot.model.User;
import chariot.model.UserStatus;
import chariot.model.UserTopAll;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Endpoint<T> {
    public static final EPOne<User> accountProfile = Endpoint.of(User.class).endpoint("/api/account").scope(Client.Scope.any).toOne();
    public static final EPOne<AccountPreferences> accountPreferences = Endpoint.of(AccountPreferences.class).endpoint("/api/account/preferences").scope(Client.Scope.preference_read).toOne();
    public static final EPOne<AccountEmail> accountEmail = Endpoint.of(AccountEmail.class).endpoint("/api/account/email").scope(Client.Scope.email_read).toOne();
    public static final EPOne<AccountKid> accountKid = Endpoint.of(AccountKid.class).endpoint("/api/account/kid").scope(Client.Scope.preference_read).toOne();
    public static final EPOne<Ack> accountKidStatus = Endpoint.of(Ack.class).endpoint("/api/account/kid").post().scope(Client.Scope.preference_write).toOne();
    public static final EPMany<MyGameInfo> accountNowPlaying = Endpoint.of(MyGameInfo.class).endpoint("/api/account/playing").streamMapper(stream -> stream.map(ModelMapper.mapper(PlayingWrapper.class)).filter(Objects::nonNull).flatMap(playingWrapper -> playingWrapper.nowPlaying().stream())).scope(Client.Scope.any).toMany();
    public static final EPOne<Ack> accountOAuthToken = Endpoint.of(Ack.class).endpoint("/account/oauth/token").toOne();
    public static final EPOne<TokenResult> apiToken = Endpoint.of(TokenResult.class).endpoint("/api/token").post("application/x-www-form-urlencoded").toOne();
    public static final EPOne<Ack> apiTokenRevoke = Endpoint.of(Ack.class).endpoint("/api/token").delete().scope(Client.Scope.any).toOne();
    public static final EPOne<TokenBulkResult> apiTokenBulkTest = Endpoint.of(TokenBulkResult.class).endpoint("/api/token/test").post("text/plain; charset=utf-8").toOne();
    public static final EPOne<ChallengeTokens> apiAdminChallengeTokens = Endpoint.of(ChallengeTokens.class).endpoint("/api/token/admin-challenge").post("application/x-www-form-urlencoded").scope(Client.Scope.web_mod).toOne();
    public static final EPOne<Ack> sendMessage = Endpoint.of(Ack.class).endpoint("/inbox/%s").post("application/x-www-form-urlencoded").scope(Client.Scope.msg_write).toOne();
    public static final EPOne<Crosstable> crosstableByUserIds = Endpoint.of(Crosstable.class).endpoint("/api/crosstable/%s/%s").toOne();
    public static final EPOne<User> userById = Endpoint.of(User.class).endpoint("/api/user/%s").toOne();
    public static final EPMany<RatingHistory> ratingHistoryById = Endpoint.ofArr(RatingHistory.class).endpoint("/api/user/%s/rating-history").toMany();
    public static final EPOne<PerfStat> perfStatByIdAndType = Endpoint.of(PerfStat.class).endpoint("/api/user/%s/perf/%s").toOne();
    public static final EPMany<Activity> activityById = Endpoint.ofArr(Activity.class).endpoint("/api/user/%s/activity").toMany();
    public static final EPOne<Game> gameCurrentByUserId = Endpoint.of(Game.class).endpoint("/api/user/%s/current-game").toOne();
    public static final EPOne<Pgn> gameCurrentByUserIdPgn = Endpoint.of(Pgn.class).endpoint("/api/user/%s/current-game").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toOne();
    public static final EPMany<User> relFollowing = Endpoint.of(User.class).endpoint("/api/rel/following").scope(Client.Scope.follow_read).accept("application/x-ndjson").toMany();
    public static final EPOne<Ack> followUser = Endpoint.of(Ack.class).endpoint("/api/rel/follow/%s").post().scope(Client.Scope.follow_write).toOne();
    public static final EPOne<Ack> unfollowUser = Endpoint.of(Ack.class).endpoint("/api/rel/unfollow/%s").post().scope(Client.Scope.follow_write).toOne();
    public static final EPMany<Tournament> tournamentArenaCreatedByUser = Endpoint.of(Tournament.class).endpoint("/api/user/%s/tournament/created").accept("application/x-ndjson").toMany();
    public static final EPMany<UserStatus> userStatusByIds = Endpoint.ofArr(UserStatus.class).endpoint("/api/users/status").toMany();
    public static final EPMany<User> usersByIds = Endpoint.ofArr(User.class).endpoint("/api/users").post("text/plain; charset=utf-8").toMany();
    public static final EPMany<String> usersNamesAutocomplete = Endpoint.ofArr((String string) -> string.substring(1, string.length() - 1).replaceAll("\"", "").split(",")).endpoint("/api/player/autocomplete").accept("text/plain; charset=utf-8").toMany();
    public static final EPMany<LightUserWithStatus> usersStatusAutocomplete = Endpoint.ofArr(LightUserWithStatus.class).endpoint("/api/player/autocomplete").streamMapper(stream -> stream.map(ModelMapper.mapper(AutocompleteWrapper.class)).filter(Objects::nonNull).flatMap(autocompleteWrapper -> autocompleteWrapper.result().stream())).toMany();
    public static final EPMany<StreamerStatus> liveStreamers = Endpoint.ofArr(StreamerStatus.class).endpoint("/api/streamer/live").toMany();
    public static final EPOne<Team> teamById = Endpoint.of(Team.class).endpoint("/api/team/%s").toOne();
    public static final EPMany<Team> teamsByUserId = Endpoint.ofArr(Team.class).endpoint("/api/team/of/%s").toMany();
    public static final EPMany<User> teamUsersById = Endpoint.of(User.class).endpoint("/api/team/%s/users").accept("application/x-ndjson").scope(Client.Scope.team_read).toMany();
    public static final EPOne<PageTeam> popularTeamsByPage = Endpoint.of(PageTeam.class).endpoint("/api/team/all").toOne();
    public static final EPOne<PageTeam> teamsSearch = Endpoint.of(PageTeam.class).endpoint("/api/team/search").toOne();
    public static final EPMany<Tournament> teamArenaById = Endpoint.of(Tournament.class).endpoint("/api/team/%s/arena").toMany();
    public static final EPMany<Swiss> teamSwissById = Endpoint.of(Swiss.class).endpoint("/api/team/%s/swiss").toMany();
    public static final EPOne<Ack> teamJoin = Endpoint.of(Ack.class).endpoint("/team/%s/join").post("application/x-www-form-urlencoded").scope(Client.Scope.team_write).toOne();
    public static final EPOne<Ack> teamQuit = Endpoint.of(Ack.class).endpoint("/team/%s/quit").post().scope(Client.Scope.team_write).toOne();
    public static final EPOne<Ack> teamKick = Endpoint.of(Ack.class).endpoint("/team/%s/kick/%s").post().scope(Client.Scope.team_lead).toOne();
    public static final EPOne<Ack> teamMessage = Endpoint.of(Ack.class).endpoint("/team/%s/pm-all").post("application/x-www-form-urlencoded").scope(Client.Scope.team_lead).toOne();
    public static final EPMany<TeamRequest> teamRequests = Endpoint.ofArr(TeamRequest.class).endpoint("/api/team/%s/requests").scope(Client.Scope.team_read).toMany();
    public static final EPOne<Ack> teamAcceptJoin = Endpoint.of(Ack.class).endpoint("/api/team/%s/request/%s/accept").post().scope(Client.Scope.team_lead).toOne();
    public static final EPOne<Ack> teamDeclineJoin = Endpoint.of(Ack.class).endpoint("/api/team/%s/request/%s/decline").post().scope(Client.Scope.team_lead).toOne();
    public static final EPOne<GameImport> gameImport = Endpoint.of(GameImport.class).endpoint("/api/import").post("application/x-www-form-urlencoded").toOne();
    public static final EPMany<GameInfo> streamGamesByUsers = Endpoint.of(GameInfo.class).endpoint("/api/stream/games-by-users").post("text/plain; charset=utf-8").accept("application/x-ndjson").toMany();
    public static final EPMany<GameInfo> streamGamesByStreamIds = Endpoint.of(GameInfo.class).endpoint("/api/stream/games/%s").post("text/plain; charset=utf-8").accept("application/x-ndjson").toMany();
    public static final EPOne<Ack> addGameIdsToStream = Endpoint.of(Ack.class).endpoint("/api/stream/games/%s/add").post("text/plain; charset=utf-8").accept("application/json").toOne();
    public static final EPMany<MoveInfo> streamMoves = Endpoint.of(MoveInfo.class).endpoint("/api/stream/game/%s").accept("application/x-ndjson").toMany();
    public static final EPMany<Event> streamEvents = Endpoint.of(Event.class).endpoint("/api/stream/event").accept("application/x-ndjson").scope(Client.Scope.challenge_read).toMany();
    public static final EPOne<Arena> createArenaTournament = Endpoint.of(Arena.class).endpoint("/api/tournament").post("application/x-www-form-urlencoded").scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Ack> joinArenaTournament = Endpoint.of(Ack.class).endpoint("/api/tournament/%s/join").post("application/x-www-form-urlencoded").scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Ack> withdrawArenaTournament = Endpoint.of(Ack.class).endpoint("/api/tournament/%s/withdraw").post().scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Arena> updateArenaTournament = Endpoint.of(Arena.class).endpoint("/api/tournament/%s").post("application/x-www-form-urlencoded").scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Arena> updateTeamBattleTournament = Endpoint.of(Arena.class).endpoint("/api/tournament/team-battle/%s").post("application/x-www-form-urlencoded").scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Ack> terminateArenaTournament = Endpoint.of(Ack.class).endpoint("/api/tournament/%s/terminate").post().scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Arena> tournamentArenaById = Endpoint.of(Arena.class).endpoint("/api/tournament/%s").toOne();
    public static final EPMany<ArenaResult> tournamentArenaResultsById = Endpoint.of(ArenaResult.class).endpoint("/api/tournament/%s/results").accept("application/x-ndjson").toMany();
    public static final EPOne<TeamBattleResults> tournamentTeamBattleResultsById = Endpoint.of(TeamBattleResults.class).endpoint("/api/tournament/%s/teams").toOne();
    public static final EPOne<TournamentStatus> tournamentArenas = Endpoint.of(TournamentStatus.class).endpoint("/api/tournament").toOne();
    public static final EPMany<Game> gamesByArenaId = Endpoint.of(Game.class).endpoint("/api/tournament/%s/games").accept("application/x-ndjson").toMany();
    public static final EPMany<Pgn> gamesByArenaIdPgn = Endpoint.of(Pgn.class).endpoint("/api/tournament/%s/games").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPMany<Game> gamesByUserId = Endpoint.of(Game.class).endpoint("/api/games/user/%s").accept("application/x-ndjson").toMany();
    public static final EPMany<Pgn> gamesByUserIdPgn = Endpoint.of(Pgn.class).endpoint("/api/games/user/%s").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPOne<Game> gameById = Endpoint.of(Game.class).endpoint("/game/export/%s").toOne();
    public static final EPOne<Pgn> gameByIdPgn = Endpoint.of(Pgn.class).endpoint("/game/export/%s").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toOne();
    public static final EPMany<Game> gamesByIds = Endpoint.of(Game.class).endpoint("/api/games/export/_ids").post("text/plain; charset=utf-8").accept("application/x-ndjson").toMany();
    public static final EPMany<Pgn> gamesByIdsPgn = Endpoint.of(Pgn.class).endpoint("/api/games/export/_ids").post("text/plain; charset=utf-8").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPOne<ExploreResult.OpeningDB> exploreMasters = Endpoint.of(ExploreResult.OpeningDB.class).endpoint("/masters").target(Config.ServerType.explorer).toOne();
    public static final EPOne<ExploreResult.OpeningDB> exploreLichess = Endpoint.of(ExploreResult.OpeningDB.class).endpoint("/lichess").target(Config.ServerType.explorer).toOne();
    public static final EPOne<ExploreResult.HistoryStats> exploreLichessHistory = Endpoint.of(ExploreResult.HistoryStats.class).endpoint("/lichess/history").target(Config.ServerType.explorer).toOne();
    public static final EPOne<ExploreResult.OpeningPlayer> explorePlayers = Endpoint.of(ExploreResult.OpeningPlayer.class).endpoint("/player").target(Config.ServerType.explorer).toOne();
    public static final EPOne<Pgn> exploreMasterOTB = Endpoint.of(Pgn.class).endpoint("/master/pgn/%s").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").target(Config.ServerType.explorer).toOne();
    public static final EPOne<TablebaseResult> tablebaseLookup = Endpoint.of(TablebaseResult.class).endpoint("/standard").target(Config.ServerType.tablebase).toOne();
    public static final EPOne<TablebaseResult> tablebaseAtomicLookup = Endpoint.of(TablebaseResult.class).endpoint("/atomic").target(Config.ServerType.tablebase).toOne();
    public static final EPOne<TablebaseResult> tablebaseAntichessLookup = Endpoint.of(TablebaseResult.class).endpoint("/antichess").target(Config.ServerType.tablebase).toOne();
    public static final EPOne<TVChannels> gameTVChannels = Endpoint.of(TVChannels.class).endpoint("/api/tv/channels").toOne();
    public static final EPMany<TVFeedEvent> gameTVFeed = Endpoint.of(TVFeedEvent.class).endpoint("/api/tv/feed").accept("application/x-ndjson").toMany();
    public static final EPMany<Game> gamesTVChannel = Endpoint.of(Game.class).endpoint("/api/tv/%s").accept("application/x-ndjson").toMany();
    public static final EPMany<Pgn> gamesTVChannelPgn = Endpoint.of(Pgn.class).endpoint("/api/tv/%s").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPOne<UserTopAll> usersTopAll = Endpoint.of(UserTopAll.class).endpoint("/api/player").accept("application/vnd.lichess.v3+json").toOne();
    public static final EPOne<Leaderboard> usersLeaderboard = Endpoint.of(Leaderboard.class).endpoint("/api/player/top/%s/%s").accept("application/vnd.lichess.v3+json").toOne();
    public static final EPOne<Puzzle> dailyPuzzle = Endpoint.of(Puzzle.class).endpoint("/api/puzzle/daily").toOne();
    public static final EPOne<Puzzle> puzzleById = Endpoint.of(Puzzle.class).endpoint("/api/puzzle/%s").toOne();
    public static final EPMany<PuzzleActivity> puzzleActivity = Endpoint.of(PuzzleActivity.class).endpoint("/api/puzzle/activity").accept("application/x-ndjson").scope(Client.Scope.puzzle_read).toMany();
    public static final EPOne<PuzzleDashboard> puzzleDashboard = Endpoint.of(PuzzleDashboard.class).endpoint("/api/puzzle/dashboard/%s").scope(Client.Scope.puzzle_read).toOne();
    public static final EPOne<PuzzleRace> puzzleRace = Endpoint.of(PuzzleRace.class).endpoint("/api/racer").post().scope(Client.Scope.racer_write).toOne();
    public static final EPOne<StormDashboard> stormDashboard = Endpoint.of(StormDashboard.class).endpoint("/api/storm/dashboard/%s").toOne();
    public static final EPOne<Simuls> simuls = Endpoint.of(Simuls.class).endpoint("/api/simul").toOne();
    public static final EPOne<Analysis> cloudEval = Endpoint.of(Analysis.class).endpoint("/api/cloud-eval").toOne();
    public static final EPMany<Pgn> exportChapter = Endpoint.of(Pgn.class).endpoint("/study/%s/%s.pgn").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPMany<Pgn> exportChapters = Endpoint.of(Pgn.class).endpoint("/api/study/%s.pgn").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPMany<Pgn> exportStudies = Endpoint.of(Pgn.class).endpoint("/study/by/%s/export.pgn").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").scope(Client.Scope.any).toMany();
    public static final EPMany<BulkPairing> bulkPairingGet = Endpoint.of(BulkPairing.class).endpoint("/api/bulk-pairing").streamMapper(stream -> stream.map(ModelMapper.mapper(BulkPairingWrapper.class)).filter(Objects::nonNull).flatMap(bulkPairingWrapper -> bulkPairingWrapper.bulks().stream())).scope(Client.Scope.challenge_bulk).toMany();
    public static final EPOne<BulkPairing> bulkPairingCreate = Endpoint.of(BulkPairing.class).endpoint("/api/bulk-pairing").post("application/x-www-form-urlencoded").scope(Client.Scope.challenge_bulk).toOne();
    public static final EPOne<Ack> bulkPairingStart = Endpoint.of(Ack.class).endpoint("/api/bulk-pairing/%s/start-clocks").post().scope(Client.Scope.challenge_bulk).toOne();
    public static final EPOne<Ack> bulkPairingCancel = Endpoint.of(Ack.class).endpoint("/api/bulk-pairing/%s").delete().scope(Client.Scope.challenge_bulk).toOne();
    public static final EPOne<PendingChallenges> challenges = Endpoint.of(PendingChallenges.class).endpoint("/api/challenge").scope(Client.Scope.challenge_read).toOne();
    public static final EPOne<Challenge> challengeCreate = Endpoint.of(Challenge.class).endpoint("/api/challenge/%s").streamMapper(stream -> stream.map(ModelMapper.mapper(ChallengeResult.class)).filter(ChallengeResult.ChallengeInfo.class::isInstance).map(ChallengeResult.ChallengeInfo.class::cast).map(ChallengeResult.ChallengeInfo::challenge)).post("application/x-www-form-urlencoded").scope(Client.Scope.challenge_write).toOne();
    public static final EPMany<Challenge> challengeCreateKeepAlive = Endpoint.of(Challenge.class).endpoint("/api/challenge/%s").streamMapper(stream -> stream.map(ModelMapper.mapper(ChallengeResult.class)).filter(ChallengeResult.ChallengeInfo.class::isInstance).map(ChallengeResult.ChallengeInfo.class::cast).map(ChallengeResult.ChallengeInfo::challenge)).post("application/x-www-form-urlencoded").scope(Client.Scope.challenge_write).toMany();
    public static final EPOne<ChallengeAI> challengeAI = Endpoint.of(ChallengeAI.class).endpoint("/api/challenge/ai").streamMapper(stream -> stream.map(ModelMapper.mapper(ChallengeResult.class)).filter(ChallengeAI.class::isInstance).map(ChallengeAI.class::cast)).post("application/x-www-form-urlencoded").scope(Client.Scope.challenge_write).toOne();
    public static final EPOne<ChallengeOpenEnded> challengeOpenEnded = Endpoint.of(ChallengeOpenEnded.class).endpoint("/api/challenge/open").post("application/x-www-form-urlencoded").scope(Client.Scope.challenge_write).toOne();
    public static final EPOne<Ack> challengeCancel = Endpoint.of(Ack.class).endpoint("/api/challenge/%s/cancel").post().scope(Client.Scope.challenge_write).toOne();
    public static final EPOne<Ack> challengeAccept = Endpoint.of(Ack.class).endpoint("/api/challenge/%s/accept").post().scope(Client.Scope.challenge_write).toOne();
    public static final EPOne<Ack> challengeDecline = Endpoint.of(Ack.class).endpoint("/api/challenge/%s/decline").post("application/x-www-form-urlencoded").scope(Client.Scope.challenge_write).toOne();
    public static final EPOne<Ack> startClocksOfGame = Endpoint.of(Ack.class).endpoint("/api/challenge/%s/start-clocks").post().scope(Client.Scope.challenge_write).toOne();
    public static final EPOne<Ack> addTimeToGame = Endpoint.of(Ack.class).endpoint("/api/round/%s/add-time/%s").post().scope(Client.Scope.challenge_write).toOne();
    public static final EPOne<Swiss> createSwiss = Endpoint.of(Swiss.class).endpoint("/api/swiss/new/%s").post("application/x-www-form-urlencoded").scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Swiss> tournamentSwissById = Endpoint.of(Swiss.class).endpoint("/api/swiss/%s").toOne();
    public static final EPOne<Swiss> updateSwissTournament = Endpoint.of(Swiss.class).endpoint("/api/swiss/%s/edit").post("application/x-www-form-urlencoded").scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Ack> joinSwissTournament = Endpoint.of(Ack.class).endpoint("/api/swiss/%s/join").post("application/x-www-form-urlencoded").scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Ack> terminateSwiss = Endpoint.of(Ack.class).endpoint("/api/swiss/%s/terminate").post().scope(Client.Scope.tournament_write).toOne();
    public static final EPOne<Ack> withdrawSwiss = Endpoint.of(Ack.class).endpoint("/api/swiss/%s/withdraw").post().scope(Client.Scope.tournament_write).toOne();
    public static final EPMany<SwissResult> swissResults = Endpoint.of(SwissResult.class).endpoint("/api/swiss/%s/results").accept("application/x-ndjson").toMany();
    public static final EPMany<String> swissTRF = Endpoint.of(Function.identity()).endpoint("/swiss/%s.trf").accept("text/plain; charset=utf-8").toMany();
    public static final EPMany<Game> gamesBySwissId = Endpoint.of(Game.class).endpoint("/api/swiss/%s/games").accept("application/x-ndjson").toMany();
    public static final EPMany<Pgn> gamesBySwissIdPgn = Endpoint.of(Pgn.class).endpoint("/api/swiss/%s/games").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPMany<Broadcast> officialBroadcasts = Endpoint.of(Broadcast.class).endpoint("/api/broadcast").accept("application/x-ndjson").toMany();
    public static final EPOne<Broadcast> createBroadcast = Endpoint.of(Broadcast.class).endpoint("/broadcast/new").post("application/x-www-form-urlencoded").scope(Client.Scope.study_write).toOne();
    public static final EPOne<Broadcast.Round> createRound = Endpoint.of(Broadcast.Round.class).endpoint("/broadcast/%s/new").post("application/x-www-form-urlencoded").scope(Client.Scope.study_write).toOne();
    public static final EPOne<Broadcast> broadcastById = Endpoint.of(Broadcast.class).endpoint("/broadcast/-/%s").scope(Client.Scope.study_read).toOne();
    public static final EPOne<Broadcast.Round> roundById = Endpoint.of(Broadcast.Round.class).endpoint("/broadcast/-/-/%s").scope(Client.Scope.study_read).toOne();
    public static final EPOne<Ack> updateBroadcast = Endpoint.of(Ack.class).endpoint("/broadcast/%s/edit").post("application/x-www-form-urlencoded").scope(Client.Scope.study_write).toOne();
    public static final EPOne<Broadcast.Round> updateRound = Endpoint.of(Broadcast.Round.class).endpoint("/broadcast/round/%s/edit").post("application/x-www-form-urlencoded").scope(Client.Scope.study_write).toOne();
    public static final EPOne<Ack> pushPGNbyRoundId = Endpoint.of(Ack.class).endpoint("/broadcast/round/%s/push").post("text/plain; charset=utf-8").scope(Client.Scope.study_write).toOne();
    public static final EPMany<Pgn> streamBroadcast = Endpoint.of(Pgn.class).endpoint("/api/stream/broadcast/round/%s.pgn").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPMany<Pgn> exportBroadcastOneRoundPgn = Endpoint.of(Pgn.class).endpoint("/api/broadcast/round/%s.pgn").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPMany<Pgn> exportBroadcastAllRoundsPgn = Endpoint.of(Pgn.class).endpoint("/api/broadcast/%s.pgn").streamMapper(Util::toPgnStream).accept("application/x-chess-pgn").toMany();
    public static final EPMany<String> boardSeekRealTime = Endpoint.of(Function.identity()).endpoint("/api/board/seek").post("application/x-www-form-urlencoded").accept("text/plain; charset=utf-8").scope(Client.Scope.board_play).toMany();
    public static final EPOne<SeekAck> boardSeekCorr = Endpoint.of(SeekAck.class).endpoint("/api/board/seek").post("application/x-www-form-urlencoded").accept("text/plain; charset=utf-8").scope(Client.Scope.board_play).toOne();
    public static final EPMany<GameEvent> streamBoardGameEvents = Endpoint.of(GameEvent.class).endpoint("/api/board/game/stream/%s").accept("application/x-ndjson").scope(Client.Scope.board_play).toMany();
    public static final EPOne<Ack> boardMove = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/move/%s").post().scope(Client.Scope.board_play).toOne();
    public static final EPOne<Ack> boardChat = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/chat").post("application/x-www-form-urlencoded").scope(Client.Scope.board_play).toOne();
    public static final EPOne<Ack> boardAbort = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/abort").post().scope(Client.Scope.board_play).toOne();
    public static final EPOne<Ack> boardResign = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/resign").post().scope(Client.Scope.board_play).toOne();
    public static final EPOne<Ack> boardDraw = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/draw/%s").post().scope(Client.Scope.board_play).toOne();
    public static final EPOne<Ack> boardTakeback = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/takeback/%s").post().scope(Client.Scope.board_play).toOne();
    public static final EPOne<Ack> boardClaimVictory = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/claim-victory").post().scope(Client.Scope.board_play).toOne();
    public static final EPMany<ChatMessage> boardFetchChat = Endpoint.ofArr(ChatMessage.class).endpoint("/api/board/game/%s/chat").accept("application/x-ndjson").scope(Client.Scope.board_play).toMany();
    public static final EPOne<Ack> boardBerserk = Endpoint.of(Ack.class).endpoint("/api/board/game/%s/berserk").scope(Client.Scope.board_play).toOne();
    public static final EPMany<User> botsOnline = Endpoint.of(User.class).endpoint("/api/bot/online").accept("application/x-ndjson").toMany();
    public static final EPOne<Ack> botAccountUpgrade = Endpoint.of(Ack.class).endpoint("/api/bot/account/upgrade").post().scope(Client.Scope.bot_play).toOne();
    public static final EPMany<GameEvent> streamBotGameEvents = Endpoint.of(GameEvent.class).endpoint("/api/bot/game/stream/%s").accept("application/x-ndjson").scope(Client.Scope.bot_play).toMany();
    public static final EPOne<Ack> botMove = Endpoint.of(Ack.class).endpoint("/api/bot/game/%s/move/%s").post().scope(Client.Scope.bot_play).toOne();
    public static final EPOne<Ack> botChat = Endpoint.of(Ack.class).endpoint("/api/bot/game/%s/chat").post("application/x-www-form-urlencoded").scope(Client.Scope.bot_play).toOne();
    public static final EPOne<Ack> botAbort = Endpoint.of(Ack.class).endpoint("/api/bot/game/%s/abort").post().scope(Client.Scope.bot_play).toOne();
    public static final EPOne<Ack> botResign = Endpoint.of(Ack.class).endpoint("/api/bot/game/%s/resign").post().scope(Client.Scope.bot_play).toOne();
    public static final EPMany<ChatMessage> botFetchChat = Endpoint.ofArr(ChatMessage.class).endpoint("/api/bot/game/%s/chat").accept("application/x-ndjson").scope(Client.Scope.bot_play).toMany();
    public static final EPMany<ExternalEngineInfo> externalEngineList = Endpoint.ofArr(ExternalEngineInfo.class).endpoint("/api/external-engine").scope(Client.Scope.engine_read).toMany();
    public static final EPOne<ExternalEngineInfo> externalEngineCreate = Endpoint.of(ExternalEngineInfo.class).endpoint("/api/external-engine").post("application/json").scope(Client.Scope.engine_write).toOne();
    public static final EPOne<ExternalEngineInfo> externalEngineGet = Endpoint.of(ExternalEngineInfo.class).endpoint("/api/external-engine/%s").scope(Client.Scope.engine_read).toOne();
    public static final EPOne<ExternalEngineInfo> externalEngineUpdate = Endpoint.of(ExternalEngineInfo.class).endpoint("/api/external-engine/%s").put("application/json").scope(Client.Scope.engine_write).toOne();
    public static final EPOne<Ack> externalEngineDelete = Endpoint.of(Ack.class).endpoint("/api/external-engine/%s").delete().scope(Client.Scope.engine_write).toOne();
    public static final EPMany<ExternalEngineAnalysis> externalEngineAnalyse = Endpoint.of(ExternalEngineAnalysis.class).endpoint("/api/external-engine/%s/analyse").post("application/json").accept("application/x-ndjson").target(Config.ServerType.engine).toMany();
    public static final EPOne<ExternalEngineRequest> externalEngineAcquire = Endpoint.of(ExternalEngineRequest.class).endpoint("/api/external-engine/work").post("application/json").target(Config.ServerType.engine).toOne();
    public static final EPOne<Void> externalEngineAnswer = Endpoint.of(Void.class).endpoint("/api/external-engine/work/%s").post("text/plain; charset=utf-8").target(Config.ServerType.engine).toOne();

    public EP ep();

    default public String endpoint() {
        return this.ep().endpoint();
    }

    default public String accept() {
        return this.ep().accept();
    }

    default public String contentType() {
        return this.ep().contentType();
    }

    default public String method() {
        return this.ep().method();
    }

    default public Client.Scope scope() {
        return this.ep().scope();
    }

    default public Config.ServerType target() {
        return this.ep().target();
    }

    public static <T> EPOne<T> one(Builder<T> builder) {
        return new EPOne(new EP(builder.endpoint, builder.accept, builder.contentType, builder.method, builder.scope, builder.target), builder.mapOne);
    }

    public static <T> EPMany<T> many(Builder<T> builder) {
        return new EPMany(new EP(builder.endpoint, builder.accept, builder.contentType, builder.method, builder.scope, builder.target), builder.mapMany);
    }

    public static <T> Builder<T> of(Class<T> clazz) {
        return Endpoint.of(ModelMapper.mapper(clazz));
    }

    public static <T> Builder<T> of(Function<String, T> function) {
        return new Builder<T>().elementMapper(function);
    }

    public static <T> Builder<T> ofArr(Class<T> clazz) {
        return Endpoint.ofArr(ModelMapper.mapperArr(clazz));
    }

    public static <T> Builder<T> ofArr(Function<String, T[]> function) {
        return new Builder().streamMapper(stream -> stream.map(function).flatMap(Arrays::stream));
    }

    default public RequestParameters.ParamsBuilder toBuilder(Consumer<RequestParameters.Params> consumer) {
        record KeyValue(String key, String value) {
        }
        Map<String, String> map = Stream.of(new KeyValue("accept", this.accept()), new KeyValue("content-type", this.contentType())).filter(keyValue -> keyValue.value() != null).collect(Collectors.toMap(KeyValue::key, KeyValue::value));
        final RequestParameters.ParamsBuilder paramsBuilder = new RequestParameters.ParamsBuilder(this.endpoint(), this.method()).headers(map).scope(this.scope()).serverType(this.target());
        RequestParameters.Params params = new RequestParameters.Params(){

            @Override
            public RequestParameters.Params path(Object ... objectArray) {
                paramsBuilder.path(objectArray);
                return this;
            }

            @Override
            public RequestParameters.Params query(Map<String, Object> map) {
                paramsBuilder.query(map);
                return this;
            }

            @Override
            public RequestParameters.Params body(InputStream inputStream) {
                paramsBuilder.body(inputStream);
                return this;
            }

            @Override
            public RequestParameters.Params body(String string) {
                paramsBuilder.body(string);
                return this;
            }

            @Override
            public RequestParameters.Params body(Map<String, ?> map) {
                paramsBuilder.body(map);
                return this;
            }

            @Override
            public RequestParameters.Params timeout(Duration duration) {
                paramsBuilder.timeout(duration);
                return this;
            }

            @Override
            public RequestParameters.Params headers(Map<String, String> map) {
                paramsBuilder.headers(map);
                return this;
            }

            @Override
            public RequestParameters.Params scope(Client.Scope scope) {
                paramsBuilder.scope(scope);
                return this;
            }

            @Override
            public RequestParameters.Params serverType(Config.ServerType serverType) {
                paramsBuilder.serverType(serverType);
                return this;
            }

            @Override
            public RequestParameters.Params stream() {
                paramsBuilder.stream();
                return this;
            }
        };
        consumer.accept(params);
        return paramsBuilder;
    }

    public record EP(String endpoint, String accept, String contentType, String method, Client.Scope scope, Config.ServerType target) {
    }

    public record EPOne<T>(EP ep, Function<Stream<String>, One<T>> mapper) implements Endpoint<T>
    {
        public RequestParameters.ReqOne<T> newRequest(Consumer<RequestParameters.Params> consumer) {
            return RequestParameters.one(this.toBuilder(consumer), requestResult -> {
                if (requestResult instanceof RequestResult.Success) {
                    RequestResult.Success success = (RequestResult.Success)requestResult;
                    return this.mapper.apply(success.stream());
                }
                if (requestResult instanceof RequestResult.Failure) {
                    RequestResult.Failure failure = (RequestResult.Failure)requestResult;
                    return One.fail(failure.code(), Err.from(failure.body()));
                }
                return this.mapper.apply(Stream.of(new String[0]));
            });
        }
    }

    public static class Builder<T> {
        private String endpoint = "";
        Function<Stream<String>, One<T>> mapOne;
        Function<Stream<String>, Many<T>> mapMany;
        private Config.ServerType target = Config.ServerType.api;
        private String accept = "application/json";
        private String contentType;
        private String method = "GET";
        private Client.Scope scope;

        public Builder<T> elementMapper(Function<String, T> function) {
            Objects.requireNonNull(function);
            this.mapOne = stream -> stream.map(function).filter(Objects::nonNull).findFirst().map(One::entry).orElse(One.none());
            this.mapMany = stream -> Many.entries(stream.map(function).filter(Objects::nonNull));
            return this;
        }

        public Builder<T> endpoint(String string) {
            this.endpoint = Objects.requireNonNull(string);
            return this;
        }

        public Builder<T> streamMapper(Function<Stream<String>, Stream<T>> function) {
            Objects.requireNonNull(function);
            this.mapOne = stream -> ((Stream)function.apply((Stream<String>)stream)).findFirst().map(One::entry).orElse(One.none());
            this.mapMany = stream -> Many.entries(((Stream)function.apply((Stream<String>)stream)).filter(Objects::nonNull));
            return this;
        }

        public Builder<T> accept(String string) {
            this.accept = Objects.requireNonNull(string);
            return this;
        }

        public Builder<T> post() {
            this.method = "POST";
            return this;
        }

        public Builder<T> post(String string) {
            this.contentType = Objects.requireNonNull(string);
            return this.post();
        }

        public Builder<T> put() {
            this.method = "PUT";
            return this;
        }

        public Builder<T> put(String string) {
            this.contentType = Objects.requireNonNull(string);
            return this.put();
        }

        public Builder<T> delete() {
            this.method = "DELETE";
            return this;
        }

        public Builder<T> scope(Client.Scope scope) {
            this.scope = Objects.requireNonNull(scope);
            return this;
        }

        public Builder<T> target(Config.ServerType serverType) {
            this.target = Objects.requireNonNull(serverType);
            return this;
        }

        public EPOne<T> toOne() {
            return Endpoint.one(this);
        }

        public EPMany<T> toMany() {
            return Endpoint.many(this);
        }
    }

    public record EPMany<T>(EP ep, Function<Stream<String>, Many<T>> mapper) implements Endpoint<T>
    {
        public RequestParameters.ReqMany<T> newRequest(Consumer<RequestParameters.Params> consumer) {
            return RequestParameters.many(this.toBuilder(consumer), requestResult -> {
                if (requestResult instanceof RequestResult.Success) {
                    RequestResult.Success success = (RequestResult.Success)requestResult;
                    return this.mapper.apply(success.stream());
                }
                if (requestResult instanceof RequestResult.Failure) {
                    RequestResult.Failure failure = (RequestResult.Failure)requestResult;
                    return Many.fail(failure.code(), Err.from(failure.body()));
                }
                return this.mapper.apply(Stream.of(new String[0]));
            });
        }
    }

    public record BulkPairingWrapper(List<BulkPairing> bulks) {
    }

    public record AutocompleteWrapper(List<LightUserWithStatus> result) {
    }

    public record PlayingWrapper(List<MyGameInfo> nowPlaying) {
    }
}

