/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.Client;
import chariot.internal.Config;
import chariot.internal.RequestParameters;
import chariot.internal.RequestResult;
import chariot.internal.Util;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InternalClient {
    private final Config config;
    private final int retryMillis = 60000;
    private final int burstRefillAfterInactivityMillis = 10000;
    private final int requestSpacingMillis = 1000;
    private final int NUMBER_OF_PARALLEL_REQUESTS = 1;
    private final int NUMBER_OF_BURST_REQUESTS = 4;
    private final int NUMBER_OF_STREAM_REQUESTS = 8;
    private final Semaphore singleSemaphore = new Semaphore(1);
    private final Semaphore burstSemaphore = new Semaphore(4);
    private final Semaphore streamSemaphore = new Semaphore(8);
    private final AtomicLong previousRequestTS = new AtomicLong();
    private final AtomicBoolean throttle429 = new AtomicBoolean();
    private final Lock throttleLock = new ReentrantLock();
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(5L)).followRedirects(HttpClient.Redirect.NORMAL).build();

    public InternalClient(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    public RequestResult request(RequestParameters requestParameters) {
        Object object;
        HttpRequest.BodyPublisher bodyPublisher;
        String string3 = switch (requestParameters.target()) {
            default -> throw new IncompatibleClassChangeError();
            case Config.ServerType.api -> this.config.servers().api().get();
            case Config.ServerType.explorer -> this.config.servers().explorer().get();
            case Config.ServerType.tablebase -> this.config.servers().tablebase().get();
            case Config.ServerType.engine -> this.config.servers().engine().get();
        };
        URI uRI = URI.create(this.joinUri(string3, requestParameters.path()));
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uRI);
        String string4 = Objects.toString(requestParameters.data(), "");
        HttpRequest.BodyPublisher bodyPublisher2 = bodyPublisher = string4.isEmpty() ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(string4);
        if (requestParameters.dataInputStream() != null) {
            bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> requestParameters.dataInputStream());
        }
        switch (requestParameters.method()) {
            case "DELETE": {
                builder.DELETE();
                break;
            }
            case "POST": {
                builder.POST(bodyPublisher);
                break;
            }
            case "PUT": {
                builder.PUT(bodyPublisher);
            }
        }
        Object object2 = this.config;
        if (object2 instanceof Config.Auth) {
            object = (Config.Auth)object2;
            object2 = requestParameters.scope() != null ? requestParameters.scope() : Client.Scope.any;
            ((Config.Auth)object).type().getToken((Client.Scope)((Object)object2)).ifPresent(supplier -> builder.header("authorization", "Bearer " + String.valueOf((char[])supplier.get())));
        }
        builder.header("user-agent", "%s %s".formatted(Util.javaVersion, Util.clientVersion));
        requestParameters.headers().forEach((string, string2) -> builder.header((String)string, (String)string2));
        object = builder.build();
        this.config.logging().request().info(() -> InternalClient.lambda$request$5(uRI, (HttpRequest)object, string4));
        try {
            object2 = this.sendWithRetry(requestParameters.stream(), (HttpRequest)object, HttpResponse.BodyHandlers.ofLines(), this.config.retries());
        }
        catch (Exception exception) {
            this.config.logging().request().log(Level.SEVERE, "%s".formatted(object), exception);
            return new RequestResult.Failure(-1, exception.getMessage());
        }
        int n = object2.statusCode();
        if (n >= 200 && n <= 299) {
            this.config.logging().request().info(() -> InternalClient.lambda$request$6((HttpResponse)object2));
            Stream<String> stream = ((Stream)object2.body()).peek(string -> this.config.logging().responsebodyraw().info(() -> string)).filter(Predicate.not("{}"::equals));
            return new RequestResult.Success(stream);
        }
        String string5 = ((Stream)object2.body()).collect(Collectors.joining());
        Supplier<String> supplier2 = () -> InternalClient.lambda$request$10((HttpResponse)object2, string5);
        if (n >= 500) {
            this.config.logging().request().warning(supplier2);
        } else {
            this.config.logging().request().info(supplier2);
        }
        this.config.logging().responsebodyraw().info(() -> string5);
        return new RequestResult.Failure(n, string5);
    }

    private <T> HttpResponse<T> sendWithRetry(boolean bl, HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler, int n) throws Exception {
        HttpResponse httpResponse = this.sendRequest(bl, httpRequest, bodyHandler);
        if (httpResponse.statusCode() == 429) {
            this.throttle429.set(true);
            this.config.logging().request().warning(() -> "%s".formatted(httpResponse));
            if (n > 0) {
                HttpRequest.Builder builder = HttpRequest.newBuilder(httpRequest, (string, string2) -> true);
                httpRequest.timeout().ifPresent(duration -> builder.timeout(duration.plusMillis(60000L)));
                HttpRequest httpRequest2 = builder.build();
                return this.sendWithRetry(bl, httpRequest2, bodyHandler, n - 1);
            }
        }
        return httpResponse;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HttpResponse<T> sendRequest(boolean bl, HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler) throws Exception {
        long l;
        this.throttleLock.lock();
        try {
            if (this.throttle429.get()) {
                long l2 = System.currentTimeMillis() - this.previousRequestTS.get();
                l = 60000L - l2;
                if (l > 0L) {
                    this.sleep(l);
                }
                this.throttle429.set(false);
            }
        }
        finally {
            this.throttleLock.unlock();
        }
        Semaphore semaphore = bl ? this.streamSemaphore : this.singleSemaphore;
        boolean bl2 = false;
        if (!bl) {
            bl2 = this.burstSemaphore.tryAcquire();
        }
        try {
            if (!bl2) {
                semaphore.acquire();
                l = System.currentTimeMillis() - this.previousRequestTS.get();
                if (!bl && l > 10000L) {
                    this.burstSemaphore.release(4);
                }
                if (l < 1000L) {
                    long l3 = 1000L - l;
                    this.sleep(l3);
                }
            }
            this.config.logging().request().fine(() -> "%s".formatted(httpRequest));
            HttpResponse<T> httpResponse = this.httpClient.send(httpRequest, bodyHandler);
            this.previousRequestTS.set(System.currentTimeMillis());
            HttpResponse<T> httpResponse2 = httpResponse;
            return httpResponse2;
        }
        finally {
            if (!bl2) {
                semaphore.release();
            }
        }
    }

    public Set<Client.Scope> fetchScopes(String string) {
        Set<Client.Scope> set;
        Config config = this.config;
        if (config instanceof Config.Auth) {
            Config.Auth auth = (Config.Auth)config;
            set = auth.type().getToken(Client.Scope.any).map(supplier -> this.fetchScopes(string, (Supplier<char[]>)supplier)).orElse(Set.of());
        } else {
            set = Set.of();
        }
        return set;
    }

    public Set<Client.Scope> fetchScopes(String string2, Supplier<char[]> supplier) {
        HttpResponse<Void> httpResponse;
        URI uRI = URI.create(this.joinUri(this.config.servers().api().get(), string2));
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uRI).method("HEAD", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(15L));
        builder.header("authorization", "Bearer " + new String(supplier.get()));
        HttpRequest httpRequest = builder.build();
        try {
            httpResponse = this.sendWithRetry(false, httpRequest, HttpResponse.BodyHandlers.discarding(), this.config().retries());
        }
        catch (Exception exception) {
            this.config.logging().request().log(Level.SEVERE, "%s".formatted(httpRequest), exception);
            return Set.of();
        }
        int n = httpResponse.statusCode();
        Supplier<String> supplier2 = () -> {
            String string = httpResponse.headers().map().entrySet().stream().map(entry -> "[%s] [%s]".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
            return "*** %s%n%nHeaders:%n%s".formatted(httpResponse, string);
        };
        if (n >= 200 && n <= 299) {
            this.config.logging().auth().info(supplier2);
            return httpResponse.headers().allValues("x-oauth-scopes").stream().flatMap(string -> Arrays.stream(string.split(","))).map(String::trim).map(string -> Client.Scope.fromString(string)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
        this.config.logging().request().warning(supplier2);
        return Set.of();
    }

    private String joinUri(String string, String string2) {
        if (!string.endsWith("/") && !string2.startsWith("/")) {
            return string + "/" + string2;
        }
        if (string.endsWith("/") && string2.startsWith("/")) {
            return string + string2.substring(1);
        }
        return string + string2;
    }

    private static /* synthetic */ String lambda$request$10(HttpResponse httpResponse, String string) {
        String string2 = httpResponse.headers().map().entrySet().stream().map(entry -> "[%s] [%s]".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
        return "### Response: %s%nBody:%n%s%nHeaders:%n%s".formatted(httpResponse, string.isEmpty() ? "<no body>" : string, string2);
    }

    private static /* synthetic */ String lambda$request$6(HttpResponse httpResponse) {
        return "%s".formatted(httpResponse);
    }

    private static /* synthetic */ String lambda$request$5(URI uRI, HttpRequest httpRequest, String string) {
        return "### Request: %s%nHeaders:%n%s%nBody:%n%s".formatted(uRI, httpRequest.headers().map().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(string -> Util.stripSensitive((String)entry.getKey(), string))).sorted().collect(Collectors.joining("\n")), string);
    }
}

