/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.internal.ModelMapperUtil;
import chariot.internal.Util;
import chariot.internal.yayson.Parser;
import chariot.internal.yayson.YayMapper;
import chariot.model.Activity;
import chariot.model.Broadcast;
import chariot.model.ChallengeAI;
import chariot.model.ChallengeOpenEnded;
import chariot.model.ChallengeResult;
import chariot.model.ChallengeTokens;
import chariot.model.Crosstable;
import chariot.model.Game;
import chariot.model.GameEvent;
import chariot.model.MoveInfo;
import chariot.model.PerfStat;
import chariot.model.RatingHistory;
import chariot.model.TVChannels;
import chariot.model.TokenBulkResult;
import chariot.model.Tournament;
import chariot.model.User;
import chariot.model.Variant;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModelMapper {
    private static final YayMapper mapper = YayMapper.mapper();
    private static final Map<Class<?>, Function<String, ?>> mappings = new HashMap();
    private static final Map<Class<?>, Function<String, ?>> mappingsArr = new HashMap();

    public static <T> Function<String, T> mapper(Class<T> clazz2) {
        return mappings.computeIfAbsent(clazz2, clazz -> string -> mapper.fromString((String)string, clazz));
    }

    public static <T> Function<String, T[]> mapperArr(Class<T> clazz2) {
        return mappingsArr.computeIfAbsent(clazz2, clazz -> string -> {
            Parser.YayNode yayNode2 = Parser.fromString(string);
            if (yayNode2 instanceof Parser.YayNode.YayArray) {
                Parser.YayNode.YayArray yayArray = (Parser.YayNode.YayArray)yayNode2;
                List<Object> list = yayArray.value().stream().map(yayNode -> mapper.fromYayTree((Parser.YayNode)yayNode, clazz)).toList();
                Object object = Array.newInstance(clazz, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(object, i, list.get(i));
                }
                return object;
            }
            return null;
        });
    }

    static {
        mapper.setMappings(PerfStat.Stat.DateResult.class, ModelMapperUtil.intMapping());
        mapper.setMappings(Game.class, ModelMapperUtil.createdAtAndLastMoveAtMapping());
        mapper.setMappings(MoveInfo.GameSummary.class, ModelMapperUtil.createdAtMapping());
        mapper.setMappings(GameEvent.Full.class, ModelMapperUtil.createdAtMapping());
        mapper.setMappings(TVChannels.class, ModelMapperUtil.tvChannelsMapping());
        mapper.setMappings(User.Count.class, ModelMapperUtil.importMapping());
        mapper.setMappings(Variant.class, ModelMapperUtil.shortMapping());
        mapper.setMappings(Broadcast.Round.class, ModelMapperUtil.startsAtMapping());
        mapper.setMappings(ChallengeAI.class, ModelMapperUtil.createdAtAndLastMoveAtMapping());
        mappings.put(Crosstable.class, string -> {
            Function<Parser.YayNode, Crosstable.Results> function = yayNode -> {
                Parser.YayNode.YayObject yayObject;
                Object object;
                if (yayNode instanceof Parser.YayNode.YayObject && (object = (yayObject = (Parser.YayNode.YayObject)yayNode).value().get("users")) instanceof Parser.YayNode.YayObject) {
                    Parser.YayNode.YayObject yayObject2 = (Parser.YayNode.YayObject)object;
                    object = yayObject2.value().entrySet().stream().map(entry -> new Crosstable.Results.Result((String)entry.getKey(), ((Parser.YayNode.YayValue.YayNumber)entry.getValue()).value().doubleValue())).collect(Collectors.toSet());
                    return new Crosstable.Results((Set<Crosstable.Results.Result>)object, yayObject.getInteger("nbGames"));
                }
                return null;
            };
            Parser.YayNode yayNode2 = Parser.fromString(string);
            if (yayNode2 instanceof Parser.YayNode.YayObject) {
                Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode2;
                Crosstable.Results results = function.apply(yayNode2);
                Optional<Crosstable.Results> optional = Optional.ofNullable(function.apply(yayObject.value().get("matchup")));
                Crosstable crosstable = new Crosstable(results, optional);
                return Crosstable.class.cast(crosstable);
            }
            return null;
        });
        mappings.put(ChallengeResult.class, string -> {
            Parser.YayNode yayNode = Parser.fromString(string);
            if (yayNode instanceof Parser.YayNode.YayObject) {
                Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                Map<String, Parser.YayNode> map = yayObject.value();
                if (map.get("urlWhite") != null) {
                    return mapper.fromYayTree(yayNode, ChallengeOpenEnded.class);
                }
                if (map.get("challenge") != null) {
                    return mapper.fromYayTree(yayNode, ChallengeResult.ChallengeInfo.class);
                }
                if (map.get("done") != null) {
                    return mapper.fromYayTree(yayNode, ChallengeResult.OpponentDecision.class);
                }
                return mapper.fromYayTree(yayNode, ChallengeAI.class);
            }
            return null;
        });
        mappings.put(Tournament.class, string -> {
            Parser.YayNode yayNode = Parser.fromString(string);
            if (yayNode instanceof Parser.YayNode.YayObject) {
                Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                Map<String, Parser.YayNode> map = yayObject.value();
                if (map.get("schedule") != null) {
                    return mapper.fromYayTree(yayNode, Tournament.Scheduled.class);
                }
                if (map.get("teamBattle") != null) {
                    return mapper.fromYayTree(yayNode, Tournament.TeamBattle.class);
                }
                return mapper.fromYayTree(yayNode, Tournament.LocalArena.class);
            }
            return null;
        });
        mappings.put(ChallengeTokens.class, string2 -> {
            Parser.YayNode yayNode = Parser.fromString(string2);
            if (yayNode instanceof Parser.YayNode.YayObject) {
                Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                Map<String, String> map = yayObject.value().keySet().stream().collect(Collectors.toMap(string -> string, string -> yayObject.getString((String)string)));
                return new ChallengeTokens(map);
            }
            return null;
        });
        mappings.put(TokenBulkResult.class, string2 -> {
            Parser.YayNode yayNode = Parser.fromString(string2);
            if (yayNode instanceof Parser.YayNode.YayObject) {
                Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                HashMap<String, TokenBulkResult.TokenInfo> hashMap = new HashMap<String, TokenBulkResult.TokenInfo>();
                yayObject.value().keySet().stream().forEach(string -> {
                    TokenBulkResult.TokenInfo tokenInfo;
                    Parser.YayNode yayNode = yayObject.value().get(string);
                    if (yayNode instanceof Parser.YayNode.YayObject) {
                        Parser.YayNode.YayObject yayObject2 = (Parser.YayNode.YayObject)yayNode;
                        tokenInfo = new TokenBulkResult.TokenInfo(yayObject2.getString("userId"), yayObject2.getString("scopes"), Util.fromLong(yayObject2.getLong("expires")));
                    } else {
                        tokenInfo = null;
                    }
                    TokenBulkResult.TokenInfo tokenInfo2 = tokenInfo;
                    hashMap.put((String)string, tokenInfo2);
                });
                return new TokenBulkResult(hashMap);
            }
            return null;
        });
        mappingsArr.put(RatingHistory.class, string -> {
            Function<Parser.YayNode, List> function = yayNode -> {
                if (yayNode instanceof Parser.YayNode.YayArray) {
                    Parser.YayNode.YayArray yayArray = (Parser.YayNode.YayArray)yayNode;
                    return yayArray.value().stream().map(yayNode2 -> {
                        if (yayNode2 instanceof Parser.YayNode.YayArray) {
                            Parser.YayNode.YayArray yayArray = (Parser.YayNode.YayArray)yayNode2;
                            List<Parser.YayNode.YayValue.YayNumber> list = yayArray.value().stream().map(yayNode -> (Parser.YayNode.YayValue.YayNumber)yayNode).toList();
                            Parser.YayNode.YayValue.YayNumber yayNumber = list.get(0);
                            Parser.YayNode.YayValue.YayNumber yayNumber2 = list.get(1);
                            Parser.YayNode.YayValue.YayNumber yayNumber3 = list.get(2);
                            Parser.YayNode.YayValue.YayNumber yayNumber4 = list.get(3);
                            LocalDate localDate = LocalDate.of(yayNumber.value().intValue(), yayNumber2.value().intValue() + 1, yayNumber3.value().intValue());
                            int n = yayNumber4.value().intValue();
                            return new RatingHistory.DateResult(localDate, n);
                        }
                        return null;
                    }).toList();
                }
                return List.of();
            };
            Parser.YayNode yayNode2 = Parser.fromString(string);
            if (yayNode2 instanceof Parser.YayNode.YayArray) {
                Parser.YayNode.YayArray yayArray = (Parser.YayNode.YayArray)yayNode2;
                List<RatingHistory> list = yayArray.value().stream().map(yayNode -> {
                    if (yayNode instanceof Parser.YayNode.YayObject) {
                        Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                        return new RatingHistory(yayObject.getString("name"), (List)function.apply(yayObject.value().get("points")));
                    }
                    return null;
                }).toList();
                Object object = Array.newInstance(RatingHistory.class, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(object, i, list.get(i));
                }
                return object;
            }
            return null;
        });
        mappingsArr.put(Activity.class, string -> {
            Parser.YayNode yayNode3 = Parser.fromString(string);
            if (yayNode3 instanceof Parser.YayNode.YayArray) {
                Parser.YayNode.YayArray yayArray = (Parser.YayNode.YayArray)yayNode3;
                Function<Parser.YayNode, List> function = yayNode -> {
                    if (yayNode instanceof Parser.YayNode.YayObject) {
                        Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                        return yayObject.value().entrySet().stream().map(entry -> {
                            try {
                                Activity.Result.ResultHelper resultHelper = mapper.fromYayTree((Parser.YayNode)entry.getValue(), Activity.Result.ResultHelper.class);
                                return new Activity.Result((String)entry.getKey(), resultHelper.win(), resultHelper.loss(), resultHelper.draw(), resultHelper.rp());
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }).toList();
                    }
                    return List.of();
                };
                List<Activity> list = yayArray.value().stream().map(yayNode2 -> {
                    if (yayNode2 instanceof Parser.YayNode.YayObject) {
                        Object object;
                        Object object2;
                        Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode2;
                        Activity.Interval interval = null;
                        Object object3 = yayObject.value().get("interval");
                        if (object3 instanceof Parser.YayNode.YayObject) {
                            object2 = (Parser.YayNode.YayObject)object3;
                            object3 = Util.fromLong(((Parser.YayNode.YayObject)object2).getNumber("start").longValue());
                            object = Util.fromLong(((Parser.YayNode.YayObject)object2).getNumber("end").longValue());
                            interval = new Activity.Interval((ZonedDateTime)object3, (ZonedDateTime)object);
                        }
                        object2 = yayObject.value().keySet();
                        object3 = new HashSet();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            String string = (String)object.next();
                            if ("interval".equals(string)) continue;
                            Parser.YayNode yayNode3 = yayObject.value().get(string);
                            Record record = switch (string) {
                                case "games" -> new Activity.Type.Games((List)function.apply(yayNode3));
                                case "puzzles" -> new Activity.Type.Puzzles((Activity.Result)((List)function.apply(yayNode3)).get(0));
                                case "tournaments" -> mapper.fromYayTree(yayNode3, Activity.Type.Tournaments.class);
                                case "practice" -> new Activity.Type.Practices(((Parser.YayNode.YayArray)yayNode3).value().stream().map(yayNode -> mapper.fromYayTree((Parser.YayNode)yayNode, Activity.Practice.class)).toList());
                                case "simuls" -> new Activity.Type.Simuls(((Parser.YayNode.YayArray)yayNode3).value().stream().map(yayNode -> mapper.fromYayTree((Parser.YayNode)yayNode, Activity.Simul.class)).toList());
                                case "correspondenceMoves" -> mapper.fromYayTree(yayNode3, Activity.Type.CorrespondenceMoves.class);
                                case "correspondenceEnds" -> {
                                    Record var12_12 = mapper.fromYayTree(yayNode3, Activity.Type.CorrespondenceEnds.class);
                                    yield new Activity.Type.CorrespondenceEnds((Activity.Result)((List)function.apply(yayNode3)).get(0), ((Activity.Type.CorrespondenceEnds)var12_12).games());
                                }
                                case "follows" -> {
                                    List<String> v2;
                                    List<String> v1;
                                    Parser.YayNode.YayArray var13_13;
                                    Parser.YayNode.YayObject var14_14;
                                    Record var12_12 = (Parser.YayNode.YayObject)yayNode3;
                                    Parser.YayNode var15_15 = ((Parser.YayNode.YayObject)var12_12).value().get("in");
                                    if (var15_15 instanceof Parser.YayNode.YayObject && (var15_15 = (var14_14 = (Parser.YayNode.YayObject)var15_15).value().get("ids")) instanceof Parser.YayNode.YayArray) {
                                        var13_13 = (Parser.YayNode.YayArray)var15_15;
                                        v1 = var13_13.value().stream().map(yayNode -> ((Parser.YayNode.YayValue.YayString)yayNode).value()).toList();
                                    } else {
                                        v1 = List.of();
                                    }
                                    var15_15 = ((Parser.YayNode.YayObject)var12_12).value().get("out");
                                    if (var15_15 instanceof Parser.YayNode.YayObject && (var15_15 = (var14_14 = (Parser.YayNode.YayObject)var15_15).value().get("ids")) instanceof Parser.YayNode.YayArray) {
                                        var13_13 = (Parser.YayNode.YayArray)var15_15;
                                        v2 = var13_13.value().stream().map(yayNode -> ((Parser.YayNode.YayValue.YayString)yayNode).value()).toList();
                                    } else {
                                        v2 = List.of();
                                    }
                                    yield new Activity.Type.Follows(v1, v2);
                                }
                                case "teams" -> new Activity.Type.Teams(((Parser.YayNode.YayArray)yayNode3).value().stream().map(yayNode -> mapper.fromYayTree((Parser.YayNode)yayNode, Activity.Team.class)).toList());
                                case "patron" -> mapper.fromYayTree(yayNode3, Activity.Type.Patron.class);
                                case "posts" -> new Activity.Type.Posts(((Parser.YayNode.YayArray)yayNode3).value().stream().map(yayNode -> mapper.fromYayTree((Parser.YayNode)yayNode, Activity.Topic.class)).toList());
                                default -> new Activity.Type.Unknown(string, yayObject.value().get(string).toString());
                            };
                            ((HashSet)object3).add(record);
                        }
                        return new Activity(interval, (Set<Activity.Type>)object3);
                    }
                    return null;
                }).toList();
                Object object = Array.newInstance(Activity.class, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(object, i, list.get(i));
                }
                return object;
            }
            return null;
        });
    }
}

