/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.Client;
import chariot.api.Account;
import chariot.internal.Crypt;
import chariot.internal.Util;
import chariot.model.TokenResult;
import com.sun.net.httpserver.HttpServer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PKCE {
    public static Account.UriAndTokenExchange initiateAuthorizationFlowCustom(Set<Client.Scope> set, String string, final Function<Map<String, String>, TokenResult> function, URI uRI) throws Exception {
        String string2 = System.getProperty("jdk.module.main", Optional.ofNullable(PKCE.class.getModule().getName()).orElse("chariot"));
        String string3 = string + "/oauth";
        final CodeVerifier codeVerifier = PKCE.generateRandomCodeVerifier();
        final Request request = new Request(PKCE.generateChallenge(codeVerifier), "code", string2, uRI.toString(), set.stream().map(Client.Scope::asString).collect(Collectors.joining(" ")), PKCE.generateRandomState());
        String string4 = Util.urlEncode(request.toMap());
        String string5 = string3 + "?" + string4;
        final URI uRI2 = URI.create(string5);
        Account.UriAndTokenExchange uriAndTokenExchange = new Account.UriAndTokenExchange(){

            @Override
            public URI url() {
                return uRI2;
            }

            @Override
            public Supplier<Supplier<char[]>> token(String string, String string2) {
                if (!request.state().equals(string2)) {
                    throw new RuntimeException("Wrong State!");
                }
                if (string == null) {
                    throw new RuntimeException("Authorization Failed");
                }
                Map<String, String> map = Map.of("code_verifier", codeVerifier.code_verifier(), "grant_type", "authorization_code", "code", string, "redirect_uri", request.redirect_uri(), "client_id", request.client_id());
                TokenResult tokenResult = (TokenResult)function.apply(map);
                if (tokenResult instanceof TokenResult.AccessToken) {
                    TokenResult.AccessToken accessToken = (TokenResult.AccessToken)tokenResult;
                    Crypt.Result result = Crypt.encrypt(accessToken.access_token().toCharArray());
                    return () -> () -> Crypt.decrypt(result.data(), result.key());
                }
                Object object = "Authorization Failed";
                if (tokenResult instanceof TokenResult.Error) {
                    TokenResult.Error error = (TokenResult.Error)tokenResult;
                    object = error.error() + " - " + error.error_description();
                }
                throw new RuntimeException((String)object);
            }
        };
        return uriAndTokenExchange;
    }

    public static Account.UriAndToken initiateAuthorizationFlow(Set<Client.Scope> set, String string, Function<Map<String, String>, TokenResult> function) throws Exception {
        record StateAndCode(String state, String code) {
        }
        InetAddress inetAddress = InetAddress.getLoopbackAddress();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, 0);
        HttpServer httpServer = HttpServer.create(inetSocketAddress, 0);
        String string2 = inetAddress.getHostAddress();
        int n = httpServer.getAddress().getPort();
        URI uRI = URI.create("http://" + string2 + ":" + n + "/");
        CompletableFuture completableFuture = new CompletableFuture();
        httpServer.createContext("/", httpExchange -> {
            httpServer.removeContext("/");
            URI uRI = httpExchange.getRequestURI();
            String string3 = uRI.getQuery();
            Map<String, String> map = Arrays.stream(string3.split("&")).collect(Collectors.toMap(string -> string.split("=")[0], string -> string.split("=")[1]));
            String string4 = map.get("code");
            String string5 = map.get("state");
            if (string4 == null) {
                httpExchange.sendResponseHeaders(503, -1L);
                httpExchange.close();
                httpServer.stop(0);
                completableFuture.completeExceptionally(new Exception("Authorization Failed"));
                return;
            }
            String string6 = "<html>\n<body>\n<h1>Success, you may close this page</h1>\n<p>If you later want to revoke the token, you can do so from\n<a href=\"%s\">Security</a> in Preferences of your Lichess account.</p>\n</body>\n</html>".formatted(string + "/account/security");
            byte[] byArray = string6.getBytes();
            httpExchange.sendResponseHeaders(200, byArray.length);
            httpExchange.getResponseBody().write(byArray);
            httpExchange.close();
            completableFuture.complete(new StateAndCode(string5, string4));
        });
        httpServer.start();
        Account.UriAndTokenExchange uriAndTokenExchange = PKCE.initiateAuthorizationFlowCustom(set, string, function, uRI);
        return new Account.UriAndToken(uriAndTokenExchange.url(), () -> {
            try {
                StateAndCode stateAndCode = (StateAndCode)completableFuture.get(2L, TimeUnit.MINUTES);
                Supplier<char[]> supplier = uriAndTokenExchange.token(stateAndCode.code(), stateAndCode.state()).get();
                return supplier;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                httpServer.stop(0);
            }
        });
    }

    static CodeVerifier generateRandomCodeVerifier() {
        byte[] byArray = PKCE.randomBytes(32);
        String string = PKCE.encodeBytes(byArray);
        return new CodeVerifier(string);
    }

    static byte[] randomBytes(int n) {
        byte[] byArray = new byte[n];
        new Random().nextBytes(byArray);
        return byArray;
    }

    static Challenge generateChallenge(CodeVerifier codeVerifier) {
        MessageDigest messageDigest;
        byte[] byArray = codeVerifier.code_verifier().getBytes(StandardCharsets.US_ASCII);
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SHA-256 algorithm not available", noSuchAlgorithmException);
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        String string = PKCE.encodeBytes(byArray2);
        return new Challenge(string, "S256");
    }

    static String generateRandomState() {
        byte[] byArray = PKCE.randomBytes(16);
        return PKCE.encodeBytes(byArray).substring(0, 8);
    }

    static String encodeBytes(byte[] byArray) {
        return Base64.getUrlEncoder().encodeToString(byArray).replaceAll("=", "").replaceAll("\\+", "-").replaceAll("\\/", "_");
    }

    record CodeVerifier(String code_verifier) {
    }

    record Request(Challenge challenge, String response_type, String client_id, String redirect_uri, String scope, String state) {
        public Map<String, String> toMap() {
            return Map.of("code_challenge_method", this.challenge.code_challenge_method(), "code_challenge", this.challenge.code_challenge(), "response_type", this.response_type(), "client_id", this.client_id(), "redirect_uri", this.redirect_uri(), "scope", this.scope(), "state", this.state());
        }
    }

    record Challenge(String code_challenge, String code_challenge_method) {
    }
}

