/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.Client;
import chariot.internal.Config;
import chariot.internal.RequestHandler;
import chariot.internal.RequestResult;
import chariot.internal.Util;
import chariot.model.Many;
import chariot.model.One;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RequestParameters {
    public Parameters parameters();

    default public String path() {
        return this.parameters().path();
    }

    default public String data() {
        return this.parameters().data();
    }

    default public InputStream dataInputStream() {
        return this.parameters().dataInputStream();
    }

    default public String method() {
        return this.parameters().method();
    }

    default public Duration timeout() {
        return this.parameters().timeout();
    }

    default public Map<String, String> headers() {
        return this.parameters().headers();
    }

    default public Client.Scope scope() {
        return this.parameters().scope();
    }

    default public Config.ServerType target() {
        return this.parameters().target();
    }

    default public boolean stream() {
        return this.parameters().stream();
    }

    public static <T> ReqOne<T> one(ParamsBuilder paramsBuilder, Function<RequestResult, One<T>> function) {
        return new ReqOne<T>(paramsBuilder.build(), function);
    }

    public static <T> ReqMany<T> many(ParamsBuilder paramsBuilder, Function<RequestResult, Many<T>> function) {
        return new ReqMany<T>(paramsBuilder.build(), function);
    }

    public record Parameters(String path, String data, InputStream dataInputStream, String method, Duration timeout, Map<String, String> headers, Client.Scope scope, Config.ServerType target, boolean stream) {
    }

    public record ReqOne<T>(Parameters parameters, Function<RequestResult, One<T>> mapper) implements RequestParameters
    {
        public One<T> process(RequestHandler requestHandler) {
            return this.mapper.apply(requestHandler.request(this));
        }
    }

    public static class ParamsBuilder {
        private final String endpoint;
        private final String method;
        private String path;
        private String data;
        private InputStream dataInputStream;
        private Map<String, ?> dataMap;
        private Duration timeout = Duration.ofSeconds(60L);
        private Map<String, String> headers = Map.of();
        private List<Object> pathParameters = List.of();
        private Map<String, Object> queryParameters = Map.of();
        private Client.Scope scope;
        private Config.ServerType target;
        private boolean stream;

        ParamsBuilder(String string, String string2) {
            this.endpoint = Objects.requireNonNull(string);
            this.method = Objects.requireNonNull(string2);
        }

        public ParamsBuilder path(Object ... objectArray) {
            this.pathParameters = List.of(Objects.requireNonNull(objectArray));
            return this;
        }

        public ParamsBuilder query(Map<String, Object> map) {
            this.queryParameters = Objects.requireNonNull(map);
            return this;
        }

        public ParamsBuilder body(InputStream inputStream) {
            this.dataInputStream = inputStream;
            return this;
        }

        public ParamsBuilder body(String string) {
            this.data = string;
            return this;
        }

        public ParamsBuilder body(Map<String, ?> map) {
            this.dataMap = map;
            return this;
        }

        public ParamsBuilder timeout(Duration duration) {
            this.timeout = duration;
            return this;
        }

        public ParamsBuilder headers(Map<String, String> map) {
            this.headers = map;
            return this;
        }

        public ParamsBuilder scope(Client.Scope scope) {
            this.scope = scope;
            return this;
        }

        public ParamsBuilder serverType(Config.ServerType serverType) {
            this.target = serverType;
            return this;
        }

        public ParamsBuilder stream() {
            this.stream = true;
            return this;
        }

        public Parameters build() {
            String string = Util.urlEncodeWithWorkaround(this.queryParameters);
            this.path = this.endpoint.formatted(this.pathParameters.toArray()) + (String)(string.isEmpty() ? "" : "?" + string);
            if (this.dataMap != null) {
                this.data = Util.urlEncode(this.dataMap);
            }
            return new Parameters(this.path, this.data, this.dataInputStream, this.method, this.timeout, this.headers, this.scope, this.target, this.stream);
        }
    }

    public record ReqMany<T>(Parameters parameters, Function<RequestResult, Many<T>> mapper) implements RequestParameters
    {
        public Many<T> process(RequestHandler requestHandler) {
            return this.mapper.apply(requestHandler.request(this));
        }
    }

    public static interface Params {
        public Params path(Object ... var1);

        public Params query(Map<String, Object> var1);

        public Params body(InputStream var1);

        public Params body(String var1);

        public Params body(Map<String, ?> var1);

        public Params timeout(Duration var1);

        public Params headers(Map<String, String> var1);

        public Params scope(Client.Scope var1);

        public Params serverType(Config.ServerType var1);

        public Params stream();
    }
}

