/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal;

import chariot.model.Page;
import chariot.model.Pgn;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Util {
    public static final String javaVersion = Util._javaVersion();
    public static final String clientVersion = Util._clientVersion();
    public static final Predicate<String> notNullNotEmpty = Predicate.not(String::isEmpty).and(Objects::nonNull);

    public static String orEmpty(String string) {
        return string == null ? "" : string;
    }

    public static ZonedDateTime fromLong(Long l) {
        if (l == null) {
            l = 0L;
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault());
    }

    public static String urlEncode(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    public static String urlEncode(Map<String, ?> map) {
        return map.entrySet().stream().map(entry -> Util.urlEncode((String)entry.getKey()) + "=" + Util.urlEncode(String.valueOf(entry.getValue()))).collect(Collectors.joining("&"));
    }

    public static String urlEncodeWithWorkaround(Map<String, Object> map) {
        return map.entrySet().stream().map(entry -> {
            Object object = entry.getValue();
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                object = Arrays.stream(stringArray).map(string -> Util.urlEncode((String)entry.getKey()) + "=" + Util.urlEncode(string)).collect(Collectors.joining("&"));
                return object;
            }
            return Util.urlEncode((String)entry.getKey()) + "=" + Util.urlEncode(String.valueOf(entry.getValue()));
        }).collect(Collectors.joining("&"));
    }

    public static String _clientVersion() {
        Module module = Util.class.getModule();
        Package package_ = Util.class.getPackage();
        if (module.isNamed()) {
            return String.join((CharSequence)"/", module.getName(), module.getDescriptor().version().map(version -> version.toString()).orElse(Optional.ofNullable(package_.getImplementationVersion()).orElse("<unknown>")));
        }
        return String.join((CharSequence)"/", "chariot", Optional.ofNullable(package_.getImplementationVersion()).orElse("<unknown>"));
    }

    public static String _javaVersion() {
        return String.join((CharSequence)"/", "Java", Runtime.version().version().stream().map(String::valueOf).collect(Collectors.joining(".")));
    }

    public static Map<String, String> generateUserEntryCodes(String string, Set<String> set) {
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        try {
            byte[] byArray = string.getBytes("UTF8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            for (String string2 : set) {
                byte[] byArray2 = string2.toLowerCase().getBytes("UTF8");
                mac.update(byArray2);
                byte[] byArray3 = mac.doFinal();
                String string3 = HexFormat.of().formatHex(byArray3);
                hashMap.put(string2, string3);
            }
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new RuntimeException(exception);
        }
        return hashMap;
    }

    public static Stream<Pgn> toPgnStream(Stream<String> stream) {
        return StreamSupport.stream(new PgnSpliterator(stream.iterator()), false);
    }

    public static String stripSensitive(String string, String string2) {
        String string3 = switch (string.toLowerCase()) {
            case "authorization" -> {
                if (string2.split(" ").length == 2) {
                    yield "%s ***".formatted(string2.split(" ")[0]);
                }
                yield "Not on format \"<scheme> ***\"";
            }
            default -> string2;
        };
        return "%s: %s".formatted(string, string3);
    }

    public record PgnSpliterator(Iterator<String> iterator) implements Spliterator<Pgn>
    {
        @Override
        public boolean tryAdvance(Consumer<? super Pgn> consumer) {
            List<String> list = this.readGroup(this.iterator);
            List<String> list2 = this.readGroup(this.iterator);
            if (list.isEmpty() && list2.isEmpty()) {
                return false;
            }
            String string = String.join((CharSequence)" ", list2);
            List<Pgn.Tag> list3 = list.stream().map(Pgn.Tag::parse).toList();
            consumer.accept(Pgn.of(list3, string));
            return true;
        }

        List<String> readGroup(Iterator<String> iterator) {
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!bl) {
                    bl = string.contains("{");
                }
                if (bl && string.contains("}")) {
                    bl = false;
                }
                if (!string.isBlank() && !bl) {
                    arrayList.add(string);
                    continue;
                }
                if (arrayList.isEmpty()) continue;
                break;
            }
            return arrayList;
        }

        @Override
        public Spliterator<Pgn> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 16;
        }
    }

    public static class MapBuilder<T> {
        final T forInterface;
        final Map<String, Object> map;
        final InvocationHandler basicHandler;
        final Map<String, InvocationHandler> customHandlers;

        public MapBuilder(T t, Map<String, Object> map, InvocationHandler invocationHandler, Map<String, InvocationHandler> map2) {
            this.forInterface = t;
            this.map = map;
            this.basicHandler = invocationHandler;
            this.customHandlers = map2;
        }

        public MapBuilder<T> addCustomHandler(String string, BiConsumer<Object[], Map<String, Object>> biConsumer) {
            this.customHandlers.put(string, (object, method, objectArray) -> {
                biConsumer.accept(objectArray, this.map);
                return object;
            });
            return this;
        }

        public MapBuilder<T> rename(String string, String string2) {
            return this.addCustomHandler(string, (objectArray, map) -> map.put(string2, objectArray[0]));
        }

        public static <T> MapBuilder<T> of(Class<T> clazz) {
            Object object2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<String, InvocationHandler> hashMap2 = new HashMap<String, InvocationHandler>();
            InvocationHandler invocationHandler = (object, method, objectArray) -> {
                hashMap.put(method.getName(), objectArray[0]);
                return object;
            };
            Object object3 = object2 = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (object, method, objectArray) -> {
                if (method.isDefault()) {
                    Class<?> clazz = method.getDeclaringClass();
                    MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup());
                    MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
                    MethodHandle methodHandle = Modifier.isStatic(method.getModifiers()) ? lookup.findStatic(clazz, method.getName(), methodType) : lookup.findSpecial(clazz, method.getName(), methodType, clazz);
                    Object object2 = methodHandle.bindTo(object).invokeWithArguments(objectArray);
                    return object2;
                }
                InvocationHandler invocationHandler2 = hashMap2.getOrDefault(method.getName(), invocationHandler);
                try {
                    Object object3 = invocationHandler2.invoke(object, method, objectArray);
                    return object3;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            });
            return new MapBuilder<Object>(object3, hashMap, invocationHandler, hashMap2);
        }

        public MapBuilder<T> add(String string, Object object) {
            this.map.put(string, object);
            return this;
        }

        public Map<String, Object> toMap(Consumer<T> consumer) {
            consumer.accept(this.forInterface);
            return this.map;
        }

        public Map<String, Object> toMap() {
            return this.map;
        }

        public T proxy() {
            return this.forInterface;
        }
    }

    public static class PageSpliterator<T>
    implements Spliterator<T> {
        Page<T> page;
        Function<Integer, Page<T>> search;
        int currentElementIndex = 0;

        public PageSpliterator(Page<T> page, Function<Integer, Page<T>> function) {
            this.page = page;
            this.search = function;
        }

        public static <T> PageSpliterator<T> of(Page<T> page, Function<Integer, Page<T>> function) {
            return new PageSpliterator<T>(page, function);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            try {
                List<T> list = this.page.currentPageResults();
                if (this.currentElementIndex < list.size()) {
                    consumer.accept(list.get(this.currentElementIndex));
                    ++this.currentElementIndex;
                    return true;
                }
                if (this.page.currentPage() >= this.page.nbPages()) {
                    return false;
                }
                this.currentElementIndex = 0;
                this.page = this.search.apply(this.page.nextPage());
                return this.tryAdvance(consumer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.page.nbResults().intValue();
        }

        @Override
        public int characteristics() {
            return 80;
        }
    }

    public class MediaType {
        public static final String json = "application/json";
        public static final String jsonstream = "application/x-ndjson";
        public static final String lichessjson = "application/vnd.lichess.v3+json";
        public static final String wwwform = "application/x-www-form-urlencoded";
        public static final String chesspgn = "application/x-chess-pgn";
        public static final String plain = "text/plain; charset=utf-8";
    }
}

