/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.Client;
import chariot.api.AccountAuth;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.impl.AccountImpl;
import chariot.model.AccountEmail;
import chariot.model.AccountKid;
import chariot.model.AccountPreferences;
import chariot.model.Ack;
import chariot.model.Entry;
import chariot.model.Err;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.User;
import java.util.Map;
import java.util.Set;

public class AccountAuthImpl
extends AccountImpl
implements AccountAuth {
    public AccountAuthImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public One<User> profile() {
        return Endpoint.accountProfile.newRequest(params -> {}).process(this);
    }

    @Override
    public One<AccountEmail> emailAddress() {
        return Endpoint.accountEmail.newRequest(params -> {}).process(this);
    }

    @Override
    public One<Boolean> getKidModeStatus() {
        One<Boolean> one;
        One<AccountKid> one2 = Endpoint.accountKid.newRequest(params -> {}).process(this);
        if (one2 instanceof Entry) {
            Entry entry = (Entry)one2;
            one = One.entry(((AccountKid)entry.entry()).kid());
        } else {
            one = One.fail(-1, Err.from(one2.toString()));
        }
        return one;
    }

    @Override
    public One<Ack> setKidModeStatus(boolean bl) {
        return Endpoint.accountKidStatus.newRequest(params -> params.query(Map.of("v", bl))).process(this);
    }

    @Override
    public One<AccountPreferences> preferences() {
        return Endpoint.accountPreferences.newRequest(params -> {}).process(this);
    }

    @Override
    public Many<User> following() {
        return Endpoint.relFollowing.newRequest(params -> {}).process(this);
    }

    @Override
    public Set<Client.Scope> scopes() {
        return this.client.fetchScopes(Endpoint.accountProfile.endpoint());
    }

    @Override
    public One<Ack> revokeToken() {
        return Endpoint.apiTokenRevoke.newRequest(params -> {}).process(this);
    }
}

