/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.Client;
import chariot.api.Account;
import chariot.internal.Base;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.PKCE;
import chariot.model.Entry;
import chariot.model.One;
import chariot.model.TokenBulkResult;
import chariot.model.TokenResult;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AccountImpl
extends Base
implements Account {
    AccountImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public Account.UriAndToken oauthPKCE(Client.Scope ... scopeArray) {
        try {
            Account.UriAndToken uriAndToken = PKCE.initiateAuthorizationFlow(Set.of(scopeArray), this.client.config().servers().api().get(), this::token);
            return uriAndToken;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Account.UriAndTokenExchange oauthPKCEwithCustomRedirect(URI uRI, Client.Scope ... scopeArray) {
        try {
            Account.UriAndTokenExchange uriAndTokenExchange = PKCE.initiateAuthorizationFlowCustom(Set.of(scopeArray), this.client.config().servers().api().get(), this::token, uRI);
            return uriAndTokenExchange;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public URL personalAccessTokenForm(String string, Client.Scope ... scopeArray) {
        String string2 = Set.of(scopeArray).stream().map(scope -> "scopes[]=" + scope.asString()).collect(Collectors.joining("&"));
        String string3 = "description=" + URLEncoder.encode(string, StandardCharsets.UTF_8);
        String string4 = this.client.config().servers().api().get();
        String string5 = Endpoint.accountOAuthToken.endpoint() + "/create?";
        String string6 = String.join((CharSequence)"&", string2, string3);
        URI uRI = URI.create(string4 + string5 + string6);
        try {
            URL uRL = uRI.toURL();
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    TokenResult token(Map<String, String> map) {
        TokenResult tokenResult;
        One<TokenResult> one = Endpoint.apiToken.newRequest(params -> params.body(map)).process(this);
        if (one instanceof Entry) {
            Entry entry = (Entry)one;
            tokenResult = (TokenResult)entry.entry();
        } else {
            tokenResult = new TokenResult.Error("Unknown Error", "Unknown");
        }
        return tokenResult;
    }

    @Override
    public Set<Client.Scope> scopes(Supplier<char[]> supplier) {
        Set<Client.Scope> set = this.client.fetchScopes(Endpoint.accountProfile.endpoint(), supplier);
        return set;
    }

    @Override
    public One<TokenBulkResult> testTokens(Set<String> set) {
        return Endpoint.apiTokenBulkTest.newRequest(params -> params.body(set.stream().collect(Collectors.joining(",")))).process(this);
    }
}

