/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.Client;
import chariot.api.BoardAuth;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.Util;
import chariot.internal.impl.ChallengesAuthCommonImpl;
import chariot.model.Ack;
import chariot.model.ChatMessage;
import chariot.model.Enums;
import chariot.model.GameEvent;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.SeekAck;
import java.util.Map;
import java.util.function.Consumer;

public class BoardAuthImpl
extends ChallengesAuthCommonImpl
implements BoardAuth {
    public BoardAuthImpl(InternalClient internalClient) {
        super(internalClient, Client.Scope.board_play);
    }

    @Override
    public Many<String> seekRealTime(Consumer<BoardAuth.SeekRealTimeBuilder> consumer) {
        return Endpoint.boardSeekRealTime.newRequest(params -> params.stream().body(this.seekRealTimeBuilderToMap(consumer))).process(this);
    }

    @Override
    public One<SeekAck> seekCorrespondence(Consumer<BoardAuth.SeekCorrespondenceBuilder> consumer) {
        return Endpoint.boardSeekCorr.newRequest(params -> params.stream().body(this.seekCorrespondenceBuilderToMap(consumer))).process(this);
    }

    @Override
    public Many<GameEvent> connectToGame(String string) {
        return Endpoint.streamBoardGameEvents.newRequest(params -> params.path(string).stream()).process(this);
    }

    @Override
    public One<Ack> move(String string, String string2, boolean bl) {
        return Endpoint.boardMove.newRequest(params -> params.path(string, string2).query(Map.of("offeringDraw", bl))).process(this);
    }

    @Override
    public One<Ack> move(String string, String string2) {
        return Endpoint.boardMove.newRequest(params -> params.path(string, string2)).process(this);
    }

    @Override
    public One<Ack> chat(String string, String string2, Enums.Room room) {
        return Endpoint.boardChat.newRequest(params -> params.path(string).body(Map.of("text", string2, "room", room.name()))).process(this);
    }

    @Override
    public One<Ack> abort(String string) {
        return Endpoint.boardAbort.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> resign(String string) {
        return Endpoint.boardResign.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<ChatMessage> fetchChat(String string) {
        return Endpoint.boardFetchChat.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> berserk(String string) {
        return Endpoint.boardBerserk.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> handleDrawOffer(String string, Enums.Offer offer) {
        return Endpoint.boardDraw.newRequest(params -> params.path(string, offer.name())).process(this);
    }

    @Override
    public One<Ack> handleTakebackOffer(String string, Enums.Offer offer) {
        return Endpoint.boardTakeback.newRequest(params -> params.path(string, offer.name())).process(this);
    }

    @Override
    public One<Ack> claimVictory(String string) {
        return Endpoint.boardClaimVictory.newRequest(params -> params.path(string)).process(this);
    }

    private Map<String, Object> seekRealTimeBuilderToMap(Consumer<BoardAuth.SeekRealTimeBuilder> consumer) {
        final Util.MapBuilder<BoardAuth.SeekParams> mapBuilder = Util.MapBuilder.of(BoardAuth.SeekParams.class);
        BoardAuth.SeekRealTimeBuilder seekRealTimeBuilder = new BoardAuth.SeekRealTimeBuilder(){

            @Override
            public BoardAuth.SeekParams clock(float f, int n) {
                return (BoardAuth.SeekParams)mapBuilder.add("time", (int)f).add("increment", n).proxy();
            }
        };
        consumer.accept(seekRealTimeBuilder);
        return mapBuilder.toMap();
    }

    private Map<String, Object> seekCorrespondenceBuilderToMap(Consumer<BoardAuth.SeekCorrespondenceBuilder> consumer) {
        final Util.MapBuilder<BoardAuth.SeekParams> mapBuilder = Util.MapBuilder.of(BoardAuth.SeekParams.class);
        BoardAuth.SeekCorrespondenceBuilder seekCorrespondenceBuilder = new BoardAuth.SeekCorrespondenceBuilder(){

            @Override
            public BoardAuth.SeekParams daysPerTurn(int n) {
                return (BoardAuth.SeekParams)mapBuilder.add("days", n).proxy();
            }
        };
        consumer.accept(seekCorrespondenceBuilder);
        return mapBuilder.toMap();
    }
}

