/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.Client;
import chariot.api.BotAuth;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.impl.ChallengesAuthCommonImpl;
import chariot.model.Ack;
import chariot.model.ChatMessage;
import chariot.model.Enums;
import chariot.model.GameEvent;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.User;
import java.util.Map;

public class BotAuthImpl
extends ChallengesAuthCommonImpl
implements BotAuth {
    public BotAuthImpl(InternalClient internalClient) {
        super(internalClient, Client.Scope.bot_play);
    }

    @Override
    public Many<User> botsOnline(int n) {
        return Endpoint.botsOnline.newRequest(params -> params.query(Map.of("nb", n))).process(this);
    }

    @Override
    public Many<User> botsOnline() {
        return Endpoint.botsOnline.newRequest(params -> {}).process(this);
    }

    @Override
    public One<Ack> upgradeToBotAccount() {
        return Endpoint.botAccountUpgrade.newRequest(params -> {}).process(this);
    }

    @Override
    public Many<GameEvent> connectToGame(String string) {
        return Endpoint.streamBotGameEvents.newRequest(params -> params.path(string).stream()).process(this);
    }

    @Override
    public One<Ack> move(String string, String string2, boolean bl) {
        return Endpoint.botMove.newRequest(params -> params.path(string, string2).query(Map.of("offeringDraw", bl))).process(this);
    }

    @Override
    public One<Ack> move(String string, String string2) {
        return Endpoint.botMove.newRequest(params -> params.path(string, string2)).process(this);
    }

    @Override
    public One<Ack> chat(String string, String string2, Enums.Room room) {
        return Endpoint.botChat.newRequest(params -> params.path(string).body(Map.of("text", string2, "room", room.name()))).process(this);
    }

    @Override
    public One<Ack> abort(String string) {
        return Endpoint.botAbort.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> resign(String string) {
        return Endpoint.botResign.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<ChatMessage> fetchChat(String string) {
        return Endpoint.botFetchChat.newRequest(params -> params.path(string)).process(this);
    }
}

