/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.Client;
import chariot.api.ChallengesAuthCommon;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.Util;
import chariot.internal.impl.ChallengesImpl;
import chariot.model.Ack;
import chariot.model.Challenge;
import chariot.model.ChallengeAI;
import chariot.model.Enums;
import chariot.model.Event;
import chariot.model.Many;
import chariot.model.One;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ChallengesAuthCommonImpl
extends ChallengesImpl
implements ChallengesAuthCommon {
    private final Client.Scope scope;

    public ChallengesAuthCommonImpl(InternalClient internalClient, Client.Scope scope) {
        super(internalClient);
        this.scope = scope;
    }

    @Override
    public Many<Event> connect() {
        return this.connect(this.scope);
    }

    @Override
    public One<Challenge> challenge(String string, Consumer<ChallengesAuthCommon.ChallengeBuilder> consumer) {
        return this.challenge(this.scope, string, consumer);
    }

    @Override
    public Many<Challenge> challengeKeepAlive(String string, Consumer<ChallengesAuthCommon.ChallengeBuilder> consumer) {
        return this.challengeKeepAlive(this.scope, string, consumer);
    }

    @Override
    public One<ChallengeAI> challengeAI(Consumer<ChallengesAuthCommon.ChallengeAIBuilder> consumer) {
        return this.challengeAI(this.scope, consumer);
    }

    @Override
    public One<Ack> cancelChallenge(String string, Supplier<char[]> supplier) {
        return this.cancelChallenge(this.scope, string, supplier);
    }

    @Override
    public One<Ack> cancelChallenge(String string) {
        return this.cancelChallenge(this.scope, string);
    }

    @Override
    public One<Ack> acceptChallenge(String string) {
        return this.acceptChallenge(this.scope, string);
    }

    @Override
    public One<Ack> declineChallenge(String string, Enums.DeclineReason declineReason) {
        return this.declineChallenge(this.scope, string, declineReason);
    }

    @Override
    public One<Ack> declineChallenge(String string) {
        return this.declineChallenge(this.scope, string);
    }

    private Many<Event> connect(Client.Scope scope) {
        return Endpoint.streamEvents.newRequest(params -> params.scope(scope).stream()).process(this);
    }

    private One<Challenge> challenge(Client.Scope scope, String string, Consumer<ChallengesAuthCommon.ChallengeBuilder> consumer) {
        return Endpoint.challengeCreate.newRequest(params -> params.scope(scope).path(string).body(this.challengeBuilderToMap(consumer))).process(this);
    }

    private Many<Challenge> challengeKeepAlive(Client.Scope scope, String string, Consumer<ChallengesAuthCommon.ChallengeBuilder> consumer) {
        Map<String, Object> map = this.challengeBuilderToMap(consumer);
        map.put("keepAliveStream", true);
        return Endpoint.challengeCreateKeepAlive.newRequest(params -> params.scope(scope).path(string).body(map).stream()).process(this);
    }

    private One<ChallengeAI> challengeAI(Client.Scope scope, Consumer<ChallengesAuthCommon.ChallengeAIBuilder> consumer) {
        return Endpoint.challengeAI.newRequest(params -> params.scope(scope).body(this.challengeAIBuilderToMap(consumer))).process(this);
    }

    private One<Ack> cancelChallenge(Client.Scope scope, String string, Supplier<char[]> supplier) {
        return Endpoint.challengeCancel.newRequest(params -> params.scope(scope).path(string).query(Map.of("opponentToken", String.valueOf((char[])supplier.get())))).process(this);
    }

    private One<Ack> cancelChallenge(Client.Scope scope, String string) {
        return Endpoint.challengeCancel.newRequest(params -> params.scope(scope).path(string)).process(this);
    }

    private One<Ack> acceptChallenge(Client.Scope scope, String string) {
        return Endpoint.challengeAccept.newRequest(params -> params.scope(scope).path(string)).process(this);
    }

    private One<Ack> declineChallenge(Client.Scope scope, String string, Enums.DeclineReason declineReason) {
        return Endpoint.challengeDecline.newRequest(params -> params.body(Map.of("reason", declineReason.name())).path(string)).process(this);
    }

    private One<Ack> declineChallenge(Client.Scope scope, String string) {
        return Endpoint.challengeDecline.newRequest(params -> params.path(string)).process(this);
    }

    private Map<String, Object> challengeBuilderToMap(Consumer<ChallengesAuthCommon.ChallengeBuilder> consumer) {
        HashSet hashSet = new HashSet();
        final Util.MapBuilder<ChallengesAuthCommon.ChallengeParams> mapBuilder = Util.MapBuilder.of(ChallengesAuthCommon.ChallengeParams.class).addCustomHandler("acceptByToken", (objectArray, map) -> {
            map.put("acceptByToken", objectArray[0]);
            if (((Object[])objectArray).length == 2) {
                map.put("message", objectArray[1]);
            }
        }).addCustomHandler("noAbort", (objectArray, map) -> hashSet.add("noAbort")).addCustomHandler("noRematch", (objectArray, map) -> hashSet.add("noRematch")).addCustomHandler("noGiveTime", (objectArray, map) -> hashSet.add("noGiveTime")).addCustomHandler("noClaimWin", (objectArray, map) -> hashSet.add("noClaimWin"));
        ChallengesAuthCommon.ChallengeBuilder challengeBuilder = new ChallengesAuthCommon.ChallengeBuilder(){

            @Override
            public ChallengesAuthCommon.ChallengeParams clock(int n, int n2) {
                return (ChallengesAuthCommon.ChallengeParams)mapBuilder.add("clock.limit", n).add("clock.increment", n2).proxy();
            }

            @Override
            public ChallengesAuthCommon.ChallengeParams daysPerTurn(int n) {
                return (ChallengesAuthCommon.ChallengeParams)mapBuilder.add("days", n).proxy();
            }
        };
        consumer.accept(challengeBuilder);
        Map<String, Object> map2 = mapBuilder.toMap();
        if (!hashSet.isEmpty()) {
            map2.put("rules", String.join((CharSequence)",", hashSet));
        }
        return map2;
    }

    private Map<String, Object> challengeAIBuilderToMap(Consumer<ChallengesAuthCommon.ChallengeAIBuilder> consumer) {
        final Util.MapBuilder<ChallengesAuthCommon.ChallengeAIParams> mapBuilder = Util.MapBuilder.of(ChallengesAuthCommon.ChallengeAIParams.class).addCustomHandler("level", (objectArray, map) -> map.put("level", ((Enums.Level)((Object)((Object)Enums.Level.class.cast((Object)objectArray[0])))).level)).add("level", "1");
        ChallengesAuthCommon.ChallengeAIBuilder challengeAIBuilder = new ChallengesAuthCommon.ChallengeAIBuilder(){

            @Override
            public ChallengesAuthCommon.ChallengeAIParams clock(int n, int n2) {
                return (ChallengesAuthCommon.ChallengeAIParams)mapBuilder.add("clock.limit", n).add("clock.increment", n2).proxy();
            }

            @Override
            public ChallengesAuthCommon.ChallengeAIParams daysPerTurn(int n) {
                return (ChallengesAuthCommon.ChallengeAIParams)mapBuilder.add("days", n).proxy();
            }
        };
        consumer.accept(challengeAIBuilder);
        return mapBuilder.toMap();
    }
}

