/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.Client;
import chariot.api.ChallengesAuth;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.Util;
import chariot.internal.impl.ChallengesAuthCommonImpl;
import chariot.model.Ack;
import chariot.model.BulkPairing;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.PendingChallenges;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ChallengesAuthImpl
extends ChallengesAuthCommonImpl
implements ChallengesAuth {
    public ChallengesAuthImpl(InternalClient internalClient) {
        super(internalClient, Client.Scope.challenge_write);
    }

    @Override
    public One<PendingChallenges> challenges() {
        return Endpoint.challenges.newRequest(params -> {}).process(this);
    }

    @Override
    public One<Ack> startClocksOfGame(String string, String string2, String string3) {
        return Endpoint.startClocksOfGame.newRequest(params -> params.path(string).query(Map.of("token1", string2, "token2", string3))).process(this);
    }

    @Override
    public One<Ack> addTimeToGame(String string, int n) {
        return Endpoint.addTimeToGame.newRequest(params -> params.path(string, n)).process(this);
    }

    @Override
    public Many<BulkPairing> bulks() {
        return Endpoint.bulkPairingGet.newRequest(params -> {}).process(this);
    }

    @Override
    public One<BulkPairing> createBulk(Consumer<ChallengesAuth.BulkBuilder> consumer) {
        return Endpoint.bulkPairingCreate.newRequest(params -> params.body(this.bulkBuilderToMap(consumer))).process(this);
    }

    @Override
    public One<Ack> startBulk(String string) {
        return Endpoint.bulkPairingStart.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> cancelBulk(String string) {
        return Endpoint.bulkPairingCancel.newRequest(params -> params.path(string)).process(this);
    }

    private Map<String, Object> bulkBuilderToMap(Consumer<ChallengesAuth.BulkBuilder> consumer) {
        ArrayList<ChallengesAuth.BulkParams.Pairing> arrayList = new ArrayList<ChallengesAuth.BulkParams.Pairing>();
        HashSet hashSet = new HashSet();
        final Util.MapBuilder<ChallengesAuth.BulkParams> mapBuilder = Util.MapBuilder.of(ChallengesAuth.BulkParams.class).addCustomHandler("addPairing", (objectArray, map) -> arrayList.add((ChallengesAuth.BulkParams.Pairing)ChallengesAuth.BulkParams.Pairing.class.cast(objectArray[0]))).addCustomHandler("noAbort", (objectArray, map) -> hashSet.add("noAbort")).addCustomHandler("noRematch", (objectArray, map) -> hashSet.add("noRematch")).addCustomHandler("noGiveTime", (objectArray, map) -> hashSet.add("noGiveTime")).addCustomHandler("noClaimWin", (objectArray, map) -> hashSet.add("noClaimWin"));
        ChallengesAuth.BulkBuilder bulkBuilder = new ChallengesAuth.BulkBuilder(){

            @Override
            public ChallengesAuth.BulkParams clock(int n, int n2) {
                return (ChallengesAuth.BulkParams)mapBuilder.add("clock.limit", n).add("clock.increment", n2).proxy();
            }

            @Override
            public ChallengesAuth.BulkParams daysPerTurn(int n) {
                return (ChallengesAuth.BulkParams)mapBuilder.add("days", n).proxy();
            }
        };
        consumer.accept(bulkBuilder);
        Map<String, Object> map2 = mapBuilder.toMap();
        map2.putIfAbsent("rated", false);
        record Pairings(List<ChallengesAuth.BulkParams.Pairing> pairings) {
            @Override
            public String toString() {
                return this.pairings.stream().map(pairing -> String.valueOf(pairing.tokenWhite().get()) + ":" + String.valueOf(pairing.tokenBlack().get())).collect(Collectors.joining(","));
            }
        }
        map2.put("players", new Pairings(arrayList));
        if (!hashSet.isEmpty()) {
            map2.put("rules", String.join((CharSequence)",", hashSet));
        }
        return map2;
    }
}

