/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.ExternalEngineAuth;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.impl.ExternalEngineImpl;
import chariot.model.Ack;
import chariot.model.ExternalEngineInfo;
import chariot.model.ExternalEngineRegistration;
import chariot.model.Many;
import chariot.model.One;
import java.util.stream.Collectors;

public class ExternalEngineAuthImpl
extends ExternalEngineImpl
implements ExternalEngineAuth {
    public ExternalEngineAuthImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public Many<ExternalEngineInfo> list() {
        return Endpoint.externalEngineList.newRequest(params -> {}).process(this);
    }

    @Override
    public One<ExternalEngineInfo> create(ExternalEngineRegistration externalEngineRegistration) {
        return Endpoint.externalEngineCreate.newRequest(params -> params.body(this.toJson(externalEngineRegistration))).process(this);
    }

    @Override
    public One<ExternalEngineInfo> get(String string) {
        return Endpoint.externalEngineGet.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<ExternalEngineInfo> update(String string, ExternalEngineRegistration externalEngineRegistration) {
        return Endpoint.externalEngineUpdate.newRequest(params -> params.path(string).body(this.toJson(externalEngineRegistration))).process(this);
    }

    @Override
    public One<Ack> delete(String string) {
        return Endpoint.externalEngineDelete.newRequest(params -> params.path(string)).process(this);
    }

    private String toJson(ExternalEngineRegistration externalEngineRegistration) {
        return "{\n    \"name\": \"%s\",\n    \"maxThreads\": %d,\n    \"maxHash\": %d,\n    \"defaultDepth\": %d,\n    \"providerSecret\": \"%s\"\n    %s\n    %s\n}\n".formatted(externalEngineRegistration.name(), externalEngineRegistration.maxThreads(), externalEngineRegistration.maxHash(), externalEngineRegistration.defaultDepth(), externalEngineRegistration.providerSecret(), externalEngineRegistration.variants().isEmpty() ? "" : ",\"variants\":[" + externalEngineRegistration.variants().stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(",")) + "]", externalEngineRegistration.providerData().equals("") ? "" : ",\"providerData\":\"" + externalEngineRegistration.providerData() + "\"");
    }
}

