/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.ExternalEngine;
import chariot.internal.Base;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.model.ExternalEngineAnalysis;
import chariot.model.ExternalEngineRequest;
import chariot.model.ExternalEngineWork;
import chariot.model.Many;
import chariot.model.One;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ExternalEngineImpl
extends Base
implements ExternalEngine {
    ExternalEngineImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public Many<ExternalEngineAnalysis> analyse(String string, Consumer<ExternalEngine.AnalysisParameters> consumer) {
        return Endpoint.externalEngineAnalyse.newRequest(params -> params.path(string).body(this.toJson(consumer))).process(this);
    }

    @Override
    public One<ExternalEngineRequest> acquire(String string) {
        return Endpoint.externalEngineAcquire.newRequest(params -> params.body("{\"providerSecret\":\"%s\"}\n".formatted(string))).process(this);
    }

    @Override
    public One<Void> answer(String string, InputStream inputStream) {
        return Endpoint.externalEngineAnswer.newRequest(params -> params.path(string).stream().body(inputStream)).process(this);
    }

    String toJson(Consumer<ExternalEngine.AnalysisParameters> consumer) {
        var var2_2 = new ExternalEngine.AnalysisParameters(){
            String clientSecret;
            ExternalEngineWork work;

            @Override
            public ExternalEngine.AnalysisParameters clientSecret(String string) {
                this.clientSecret = string;
                return this;
            }

            @Override
            public ExternalEngine.AnalysisParameters work(ExternalEngineWork externalEngineWork) {
                this.work = externalEngineWork;
                return this;
            }
        };
        consumer.accept(var2_2);
        return "{\n    \"clientSecret\":\"%s\",\n    \"work\": {\n        \"sessionId\":\"%s\",\n        \"threads\":%d,\n        \"hash\":%d,\n        \"infinite\":%b,\n        \"multiPv\":%d,\n        \"variant\":\"%s\",\n        \"initialFen\":\"%s\",\n        \"moves\":[\n            %s\n        ]\n    }\n}\n".formatted(var2_2.clientSecret, var2_2.work.sessionId(), var2_2.work.threads(), var2_2.work.hash(), var2_2.work.infinite(), var2_2.work.multiPv(), var2_2.work.variant(), var2_2.work.initialFen(), var2_2.work.moves().stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(",")));
    }
}

