/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.Games;
import chariot.internal.Base;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.RequestParameters;
import chariot.internal.Util;
import chariot.model.Ack;
import chariot.model.Enums;
import chariot.model.Game;
import chariot.model.GameImport;
import chariot.model.GameInfo;
import chariot.model.Many;
import chariot.model.MoveInfo;
import chariot.model.One;
import chariot.model.Pgn;
import chariot.model.TVChannels;
import chariot.model.TVFeedEvent;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class GamesImpl
extends Base
implements Games {
    GamesImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public One<Game> byGameId(String string, Consumer<Games.GameParams> consumer) {
        return Endpoint.gameById.newRequest(GamesImpl.paramsConsumerByIdGameParams(string, consumer)).process(this);
    }

    @Override
    public One<Pgn> pgnByGameId(String string, Consumer<Games.GameParams> consumer) {
        return Endpoint.gameByIdPgn.newRequest(GamesImpl.paramsConsumerByIdGameParams(string, consumer)).process(this);
    }

    @Override
    public One<Game> currentByUserId(String string, Consumer<Games.GameParams> consumer) {
        return Endpoint.gameCurrentByUserId.newRequest(GamesImpl.paramsConsumerByIdGameParams(string, consumer)).process(this);
    }

    @Override
    public One<Pgn> pgnCurrentByUserId(String string, Consumer<Games.GameParams> consumer) {
        return Endpoint.gameCurrentByUserIdPgn.newRequest(GamesImpl.paramsConsumerByIdGameParams(string, consumer)).process(this);
    }

    @Override
    public Many<Game> byUserId(String string, Consumer<Games.SearchFilter> consumer) {
        return Endpoint.gamesByUserId.newRequest(GamesImpl.paramsConsumerByUserId(string, consumer)).process(this);
    }

    @Override
    public Many<Pgn> pgnByUserId(String string, Consumer<Games.SearchFilter> consumer) {
        return Endpoint.gamesByUserIdPgn.newRequest(GamesImpl.paramsConsumerByUserId(string, consumer)).process(this);
    }

    @Override
    public Many<Game> byGameIds(Set<String> set, Consumer<Games.GameParams> consumer) {
        return Endpoint.gamesByIds.newRequest(GamesImpl.paramsConsumerByIdsGameParams(set, consumer)).process(this);
    }

    @Override
    public Many<Pgn> pgnByGameIds(Set<String> set, Consumer<Games.GameParams> consumer) {
        return Endpoint.gamesByIdsPgn.newRequest(GamesImpl.paramsConsumerByIdsGameParams(set, consumer)).process(this);
    }

    @Override
    public One<GameImport> importGame(String string) {
        return Endpoint.gameImport.newRequest(params -> params.body(Map.of("pgn", string))).process(this);
    }

    @Override
    public Many<GameInfo> gameInfosByUserIds(Set<String> set, Consumer<Games.GamesParameters> consumer) {
        Util.MapBuilder<Games.GamesParameters> mapBuilder = Util.MapBuilder.of(Games.GamesParameters.class).addCustomHandler("withCurrentGames", (objectArray, map) -> {
            Boolean bl;
            Object object = objectArray[0];
            if (object instanceof Boolean && (bl = (Boolean)object).booleanValue()) {
                map.put("withCurrentGames", 1);
            }
        });
        return Endpoint.streamGamesByUsers.newRequest(params -> params.body(set.stream().map(String::toLowerCase).collect(Collectors.joining(","))).query(mapBuilder.toMap(consumer)).stream()).process(this);
    }

    @Override
    public Many<GameInfo> gameInfosByGameIds(String string, Set<String> set) {
        return Endpoint.streamGamesByStreamIds.newRequest(params -> params.path(string).body(String.join((CharSequence)",", set))).process(this);
    }

    @Override
    public One<Ack> addGameIdsToStream(String string, Set<String> set) {
        return Endpoint.addGameIdsToStream.newRequest(params -> params.path(string).body(String.join((CharSequence)",", set))).process(this);
    }

    @Override
    public Many<MoveInfo> moveInfosByGameId(String string) {
        return Endpoint.streamMoves.newRequest(params -> params.path(string).stream()).process(this);
    }

    @Override
    public One<TVChannels> tvChannels() {
        return Endpoint.gameTVChannels.newRequest(params -> {}).process(this);
    }

    @Override
    public Many<TVFeedEvent> tvFeed() {
        return Endpoint.gameTVFeed.newRequest(params -> {}).process(this);
    }

    @Override
    public Many<Game> byChannel(Enums.Channel channel, Consumer<Games.ChannelFilter> consumer) {
        return Endpoint.gamesTVChannel.newRequest(GamesImpl.paramsConsumerByChannelChannelFilter(channel, consumer)).process(this);
    }

    @Override
    public Many<Pgn> pgnByChannel(Enums.Channel channel, Consumer<Games.ChannelFilter> consumer) {
        return Endpoint.gamesTVChannelPgn.newRequest(GamesImpl.paramsConsumerByChannelChannelFilter(channel, consumer)).process(this);
    }

    static Consumer<RequestParameters.Params> paramsConsumerByChannelChannelFilter(Enums.Channel channel, Consumer<Games.ChannelFilter> consumer) {
        return params -> params.path(channel.name()).query(GamesImpl.channelFilterBuilder().toMap(consumer));
    }

    static Util.MapBuilder<Games.GameParams> gameParamsBuilder() {
        return GamesImpl.builder(Games.GameParams.class);
    }

    static Util.MapBuilder<Games.Filter> filterBuilder() {
        return GamesImpl.builder(Games.Filter.class);
    }

    static Util.MapBuilder<Games.ChannelFilter> channelFilterBuilder() {
        return GamesImpl.builder(Games.ChannelFilter.class);
    }

    static <T extends Games.CommonGameParameters<?>> Util.MapBuilder<T> builder(Class<T> clazz) {
        return Util.MapBuilder.of(clazz).rename("pgn", "pgnInJson");
    }

    static Consumer<RequestParameters.Params> paramsConsumerByUserId(String string, Consumer<Games.SearchFilter> consumer) {
        return params -> params.path(string).query(Util.MapBuilder.of(Games.SearchFilter.class).addCustomHandler("perfType", (objectArray, map) -> map.put("perfType", Arrays.stream((Enums.PerfType[])objectArray[0]).map(Enum::name).collect(Collectors.joining(",")))).addCustomHandler("sortAscending", (objectArray, map) -> map.put("sort", (Boolean)objectArray[0] != false ? "dateAsc" : "dateDesc")).rename("pgn", "pgnInJson").toMap(consumer)).timeout(Duration.ofHours(1L));
    }

    static Consumer<RequestParameters.Params> paramsConsumerByIdGameParams(String string, Consumer<Games.GameParams> consumer) {
        return params -> params.path(string).query(GamesImpl.gameParamsBuilder().toMap(consumer));
    }

    static Consumer<RequestParameters.Params> paramsConsumerByIdsGameParams(Set<String> set, Consumer<Games.GameParams> consumer) {
        return params -> params.body(set.stream().limit(300L).collect(Collectors.joining(","))).query(GamesImpl.gameParamsBuilder().toMap(consumer));
    }
}

