/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.OpeningExplorer;
import chariot.internal.Base;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.Util;
import chariot.model.Enums;
import chariot.model.ExploreResult;
import chariot.model.One;
import chariot.model.Pgn;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class OpeningExplorerImpl
extends Base
implements OpeningExplorer {
    public OpeningExplorerImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public One<Pgn> pgnByMastersGameId(String string) {
        return Endpoint.exploreMasterOTB.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<ExploreResult.OpeningDB> masters(Consumer<OpeningExplorer.MastersBuilder> consumer) {
        return Endpoint.exploreMasters.newRequest(params -> params.query(Util.MapBuilder.of(OpeningExplorer.MastersBuilder.class).toMap(consumer))).process(this);
    }

    @Override
    public One<ExploreResult.OpeningDB> lichess(Consumer<OpeningExplorer.LichessBuilder> consumer) {
        return Endpoint.exploreLichess.newRequest(params -> params.query(Util.MapBuilder.of(OpeningExplorer.LichessBuilder.class).addCustomHandler("speeds", (objectArray, map) -> {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                map.put("speeds", set.stream().map(Enum::name).collect(Collectors.joining(",")));
            }
        }).addCustomHandler("ratings", (objectArray, map) -> {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                map.put("ratings", set.stream().map(Enums.RatingGroup::asString).collect(Collectors.joining(",")));
            }
        }).toMap(consumer))).process(this);
    }

    @Override
    public One<ExploreResult.OpeningPlayer> player(String string, Consumer<OpeningExplorer.PlayerBuilder> consumer) {
        return Endpoint.explorePlayers.newRequest(params -> params.query(Util.MapBuilder.of(OpeningExplorer.PlayerBuilder.class).add("player", string).add("color", (Object)Enums.Color.white).addCustomHandler("speeds", (objectArray, map) -> {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                map.put("speeds", set.stream().map(Enum::name).collect(Collectors.joining(",")));
            }
        }).addCustomHandler("ratings", (objectArray, map) -> {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                map.put("modes", set.stream().map(Enum::name).collect(Collectors.joining(",")));
            }
        }).toMap(consumer))).process(this);
    }

    @Override
    public One<ExploreResult.HistoryStats> lichessHistory(Consumer<OpeningExplorer.HistoryBuilder> consumer) {
        return Endpoint.exploreLichessHistory.newRequest(params -> params.query(Util.MapBuilder.of(OpeningExplorer.HistoryBuilder.class).addCustomHandler("speeds", (objectArray, map) -> {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                map.put("speeds", set.stream().map(Enum::name).collect(Collectors.joining(",")));
            }
        }).addCustomHandler("ratings", (objectArray, map) -> {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                map.put("ratings", set.stream().map(Enums.RatingGroup::asString).collect(Collectors.joining(",")));
            }
        }).toMap(consumer))).process(this);
    }
}

