/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.Teams;
import chariot.internal.Base;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.Util;
import chariot.model.Entry;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.Page;
import chariot.model.PageTeam;
import chariot.model.Swiss;
import chariot.model.Team;
import chariot.model.Tournament;
import chariot.model.User;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TeamsImpl
extends Base
implements Teams {
    TeamsImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public One<Team> byTeamId(String string) {
        return Endpoint.teamById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<Team> byUserId(String string) {
        return Endpoint.teamsByUserId.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<User> usersByTeamId(String string) {
        return Endpoint.teamUsersById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<PageTeam> popularTeamsByPage(int n) {
        return Endpoint.popularTeamsByPage.newRequest(params -> params.query(Map.of("page", n))).process(this);
    }

    @Override
    public One<PageTeam> popularTeamsByPage() {
        return Endpoint.popularTeamsByPage.newRequest(params -> {}).process(this);
    }

    @Override
    public One<PageTeam> searchByPage(Consumer<Teams.PageParams> consumer) {
        return Endpoint.teamsSearch.newRequest(params -> params.query(Util.MapBuilder.of(Teams.PageParams.class).toMap(consumer))).process(this);
    }

    @Override
    public Many<Tournament> arenaByTeamId(String string, int n) {
        return Endpoint.teamArenaById.newRequest(params -> params.path(string).query(Map.of("max", n))).process(this);
    }

    @Override
    public Many<Tournament> arenaByTeamId(String string) {
        return Endpoint.teamArenaById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<Swiss> swissByTeamId(String string, int n) {
        return Endpoint.teamSwissById.newRequest(params -> params.path(string).query(Map.of("max", n))).process(this);
    }

    @Override
    public Many<Swiss> swissByTeamId(String string) {
        return Endpoint.teamSwissById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<Team> search(String string) {
        return this.search((Teams.PageParams pageParams) -> pageParams.text(string));
    }

    @Override
    public Many<Team> search() {
        return this.search((Teams.PageParams pageParams) -> {});
    }

    private Many<Team> search(Consumer<Teams.PageParams> consumer) {
        One<PageTeam> one = this.searchByPage(consumer.andThen(pageParams -> pageParams.page(1)));
        if (one instanceof Entry) {
            Entry entry = (Entry)one;
            Util.PageSpliterator pageSpliterator = Util.PageSpliterator.of((Page)entry.entry(), n -> {
                Page<Team> page;
                One<PageTeam> one = this.searchByPage(consumer.andThen(pageParams -> pageParams.page((int)n)));
                if (one instanceof Entry) {
                    Entry entry = (Entry)one;
                    page = (Page)entry.entry();
                } else {
                    page = new PageTeam(0, 0, List.of(), 0, 0, 0, 0);
                }
                return page;
            });
            return Many.entries(StreamSupport.stream(pageSpliterator, false));
        }
        return Many.entries(Stream.of(new Team[0]));
    }

    @Override
    public Many<Team> popularTeams() {
        One<PageTeam> one = this.popularTeamsByPage(1);
        if (one instanceof Entry) {
            Entry entry = (Entry)one;
            Util.PageSpliterator pageSpliterator = Util.PageSpliterator.of((Page)entry.entry(), n -> {
                Page<Team> page;
                One<PageTeam> one = this.popularTeamsByPage((int)n);
                if (one instanceof Entry) {
                    Entry entry = (Entry)one;
                    page = (Page)entry.entry();
                } else {
                    page = new PageTeam(0, 0, List.of(), 0, 0, 0, 0);
                }
                return page;
            });
            return Many.entries(StreamSupport.stream(pageSpliterator, false));
        }
        return Many.entries(Stream.of(new Team[0]));
    }
}

