/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.TournamentsAuth;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.Util;
import chariot.internal.impl.TournamentsImpl;
import chariot.model.Ack;
import chariot.model.Arena;
import chariot.model.Enums;
import chariot.model.One;
import chariot.model.Swiss;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TournamentsAuthImpl
extends TournamentsImpl
implements TournamentsAuth {
    public TournamentsAuthImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public One<Arena> createArena(Consumer<TournamentsAuth.ArenaBuilder> consumer) {
        return Endpoint.createArenaTournament.newRequest(params -> params.body(this.arenaBuilderToMap(consumer))).process(this);
    }

    @Override
    public One<Arena> updateArena(String string, Consumer<TournamentsAuth.ArenaBuilder> consumer) {
        return Endpoint.updateArenaTournament.newRequest(params -> params.path(string).body(this.arenaBuilderToMap(consumer))).process(this);
    }

    @Override
    public One<Arena> updateTeamBattle(String string, int n, Set<String> set) {
        return Endpoint.updateTeamBattleTournament.newRequest(params -> params.path(string).body(Map.ofEntries(Map.entry("teams", String.join((CharSequence)",", set)), Map.entry("nbLeaders", String.valueOf(n))))).process(this);
    }

    @Override
    public One<Ack> terminateArena(String string) {
        return Endpoint.terminateArenaTournament.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> joinArena(String string, Consumer<TournamentsAuth.JoinArenaParams> consumer) {
        return Endpoint.joinArenaTournament.newRequest(params -> params.path(string).body(Util.MapBuilder.of(TournamentsAuth.JoinArenaParams.class).rename("entryCode", "password").toMap(consumer))).process(this);
    }

    @Override
    public One<Ack> withdrawArena(String string) {
        return Endpoint.withdrawArenaTournament.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Swiss> createSwiss(String string, Consumer<TournamentsAuth.SwissBuilder> consumer) {
        return Endpoint.createSwiss.newRequest(params -> params.path(string).body(this.swissBuilderToMap(consumer))).process(this);
    }

    @Override
    public One<Swiss> updateSwiss(String string, Consumer<TournamentsAuth.SwissBuilder> consumer) {
        return Endpoint.updateSwissTournament.newRequest(params -> params.path(string).body(this.swissBuilderToMap(consumer))).process(this);
    }

    @Override
    public One<Ack> terminateSwiss(String string) {
        return Endpoint.terminateSwiss.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> withdrawSwiss(String string) {
        return Endpoint.withdrawSwiss.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<Ack> joinSwiss(String string, Consumer<TournamentsAuth.JoinSwissParams> consumer) {
        return Endpoint.joinSwissTournament.newRequest(params -> params.path(string).body(Util.MapBuilder.of(TournamentsAuth.JoinSwissParams.class).rename("entryCode", "password").toMap(consumer))).process(this);
    }

    private Map<String, Object> arenaBuilderToMap(Consumer<TournamentsAuth.ArenaBuilder> consumer) {
        final Util.MapBuilder<TournamentsAuth.ArenaParams> mapBuilder = Util.MapBuilder.of(TournamentsAuth.ArenaParams.class).addCustomHandler("startTime", (objectArray, map) -> {
            Function function = (Function)objectArray[0];
            TournamentsAuth.ArenaParams.StartTime startTime = (TournamentsAuth.ArenaParams.StartTime)function.apply(TournamentsAuth.ArenaParams.StartTime.provider());
            if (startTime instanceof TournamentsAuth.ArenaParams.StartTime.InMinutes) {
                TournamentsAuth.ArenaParams.StartTime.InMinutes inMinutes = (TournamentsAuth.ArenaParams.StartTime.InMinutes)startTime;
                map.put("waitMinutes", inMinutes.waitMinutes());
            } else if (startTime instanceof TournamentsAuth.ArenaParams.StartTime.AtDate) {
                TournamentsAuth.ArenaParams.StartTime.AtDate atDate = (TournamentsAuth.ArenaParams.StartTime.AtDate)startTime;
                map.put("startDate", atDate.startDate());
            }
        }).rename("entryCode", "password").rename("conditionTeam", "conditions.teamMember.teamId").rename("conditionMinRating", "conditions.minRating.rating").rename("conditionMaxRating", "conditions.maxRating.rating").rename("conditionMinRatedGames", "conditions.nbRatedGames.nb").addCustomHandler("allowList", (objectArray, map) -> {
            List list = (List)objectArray[0];
            if (!list.isEmpty()) {
                map.put("conditions.allowList", String.join((CharSequence)",", list));
            }
        });
        TournamentsAuth.ArenaBuilder arenaBuilder = new TournamentsAuth.ArenaBuilder(){

            @Override
            public TournamentsAuth.ArenaParams clock(float f, int n) {
                return (TournamentsAuth.ArenaParams)mapBuilder.add("clockTime", Float.valueOf(f)).add("clockIncrement", n).add("minutes", 100).proxy();
            }
        };
        consumer.accept(arenaBuilder);
        return mapBuilder.toMap();
    }

    private Map<String, Object> swissBuilderToMap(Consumer<TournamentsAuth.SwissBuilder> consumer) {
        final Util.MapBuilder<TournamentsAuth.SwissParams> mapBuilder = Util.MapBuilder.of(TournamentsAuth.SwissParams.class).rename("entryCode", "password").addCustomHandler("chatFor", (objectArray, map) -> map.put("chatFor", ((Enums.ChatFor)((Object)((Object)Enums.ChatFor.class.cast((Object)objectArray[0])))).id)).addCustomHandler("allowList", (objectArray, map) -> {
            List list = (List)objectArray[0];
            if (!list.isEmpty()) {
                map.put("conditions.allowList", String.join((CharSequence)",", list));
            }
        }).addCustomHandler("addForbiddenPairings", (objectArray, map) -> {
            Collection collection = (Collection)objectArray[0];
            String string = collection.stream().map(pairing -> String.join((CharSequence)" ", pairing.player1(), pairing.player2())).collect(Collectors.joining("\n"));
            String string2 = (String)map.get("forbiddenPairings");
            if (string2 != null) {
                string = String.join((CharSequence)"\n", string2, string);
            }
            map.put("forbiddenPairings", string);
        }).addCustomHandler("addManualPairings", (objectArray, map) -> {
            Collection collection = (Collection)objectArray[0];
            String string = collection.stream().map(pairing -> String.join((CharSequence)" ", pairing.player1(), pairing.player2())).collect(Collectors.joining("\n"));
            String string2 = (String)map.get("manualPairings");
            if (string2 != null) {
                string = String.join((CharSequence)"\n", string2, string);
            }
            map.put("manualPairings", string);
        });
        TournamentsAuth.SwissBuilder swissBuilder = new TournamentsAuth.SwissBuilder(){

            @Override
            public TournamentsAuth.SwissParams clock(int n, int n2) {
                return (TournamentsAuth.SwissParams)mapBuilder.add("clock.limit", n).add("clock.increment", n2).add("nbRounds", 9).proxy();
            }
        };
        consumer.accept(swissBuilder);
        return mapBuilder.toMap();
    }
}

