/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.Games;
import chariot.api.Tournaments;
import chariot.internal.Base;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.RequestParameters;
import chariot.internal.Util;
import chariot.internal.impl.GamesImpl;
import chariot.model.Arena;
import chariot.model.ArenaResult;
import chariot.model.Enums;
import chariot.model.Game;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.Pgn;
import chariot.model.Swiss;
import chariot.model.SwissResult;
import chariot.model.TeamBattleResults;
import chariot.model.Tournament;
import chariot.model.TournamentStatus;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class TournamentsImpl
extends Base
implements Tournaments {
    TournamentsImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public One<TournamentStatus> currentTournaments() {
        return Endpoint.tournamentArenas.newRequest(params -> {}).process(this);
    }

    @Override
    public One<Arena> arenaById(String string, int n) {
        return Endpoint.tournamentArenaById.newRequest(params -> params.path(string).query(Map.of("page", n))).process(this);
    }

    @Override
    public One<Arena> arenaById(String string) {
        return Endpoint.tournamentArenaById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<ArenaResult> resultsByArenaId(String string, Consumer<Tournaments.ArenaResultParams> consumer) {
        return Endpoint.tournamentArenaResultsById.newRequest(params -> params.path(string).query(Util.MapBuilder.of(Tournaments.ArenaResultParams.class).rename("max", "nb").toMap(consumer))).process(this);
    }

    @Override
    public Many<Tournament> arenasCreatedByUserId(String string, Set<Enums.TournamentState> set) {
        Consumer<RequestParameters.Params> consumer = params -> params.path(string);
        if (!set.isEmpty()) {
            consumer = consumer.andThen(params -> params.query(Map.of("status", set.stream().map(tournamentState -> String.valueOf(tournamentState.status())).toArray(String[]::new))));
        }
        return Endpoint.tournamentArenaCreatedByUser.newRequest(consumer).process(this);
    }

    @Override
    public One<TeamBattleResults> teamBattleResultsById(String string) {
        return Endpoint.tournamentTeamBattleResultsById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<Game> gamesByArenaId(String string, Consumer<Games.Filter> consumer) {
        return Endpoint.gamesByArenaId.newRequest(TournamentsImpl.paramsConsumerByPathId(string, consumer)).process(this);
    }

    @Override
    public Many<Pgn> pgnGamesByArenaId(String string, Consumer<Games.Filter> consumer) {
        return Endpoint.gamesByArenaIdPgn.newRequest(TournamentsImpl.paramsConsumerByPathId(string, consumer)).process(this);
    }

    @Override
    public One<Swiss> swissById(String string) {
        return Endpoint.tournamentSwissById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<SwissResult> resultsBySwissId(String string, Consumer<Tournaments.SwissResultParams> consumer) {
        return Endpoint.swissResults.newRequest(params -> params.path(string).query(Util.MapBuilder.of(Tournaments.SwissResultParams.class).rename("max", "nb").toMap(consumer))).process(this);
    }

    @Override
    public Many<String> swissTRF(String string) {
        return Endpoint.swissTRF.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public Many<Game> gamesBySwissId(String string, Consumer<Games.Filter> consumer) {
        return Endpoint.gamesBySwissId.newRequest(TournamentsImpl.paramsConsumerByPathId(string, consumer)).process(this);
    }

    @Override
    public Many<Pgn> pgnGamesBySwissId(String string, Consumer<Games.Filter> consumer) {
        return Endpoint.gamesBySwissIdPgn.newRequest(TournamentsImpl.paramsConsumerByPathId(string, consumer)).process(this);
    }

    static Consumer<RequestParameters.Params> paramsConsumerByPathId(String string, Consumer<Games.Filter> consumer) {
        return params -> params.path(string).query(GamesImpl.filterBuilder().toMap(consumer));
    }
}

