/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.impl;

import chariot.api.Users;
import chariot.internal.Base;
import chariot.internal.Endpoint;
import chariot.internal.InternalClient;
import chariot.internal.Util;
import chariot.model.Activity;
import chariot.model.Crosstable;
import chariot.model.Enums;
import chariot.model.Leaderboard;
import chariot.model.LightUserWithStatus;
import chariot.model.Many;
import chariot.model.One;
import chariot.model.PerfStat;
import chariot.model.RatingHistory;
import chariot.model.StreamerStatus;
import chariot.model.User;
import chariot.model.UserStatus;
import chariot.model.UserTopAll;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UsersImpl
extends Base
implements Users {
    public UsersImpl(InternalClient internalClient) {
        super(internalClient);
    }

    @Override
    public One<User> byId(String string, Consumer<Users.UserParams> consumer) {
        return Endpoint.userById.newRequest(params -> params.path(string).query(Util.MapBuilder.of(Users.UserParams.class).addCustomHandler("withTrophies", (objectArray, map) -> {
            Boolean bl;
            Object object = objectArray[0];
            if (object instanceof Boolean && (bl = (Boolean)object).booleanValue()) {
                map.put("trophies", 1);
            }
        }).toMap(consumer))).process(this);
    }

    @Override
    public Many<User> byIds(List<String> list) {
        return Endpoint.usersByIds.newRequest(params -> params.body(list.stream().collect(Collectors.joining(",")))).process(this);
    }

    @Override
    public One<Crosstable> crosstable(String string, String string2, Consumer<Users.CrosstableParams> consumer) {
        return Endpoint.crosstableByUserIds.newRequest(params -> params.path(string, string2).query(Util.MapBuilder.of(Users.CrosstableParams.class).toMap(consumer))).process(this);
    }

    @Override
    public Many<Activity> activityById(String string) {
        return Endpoint.activityById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<UserTopAll> top10() {
        return Endpoint.usersTopAll.newRequest(params -> {}).process(this);
    }

    @Override
    public Many<UserStatus> statusByIds(Collection<String> collection, Consumer<Users.UserStatusParams> consumer) {
        int n = 100;
        if (collection.size() > n) {
            return this.autoSplittingStatusByIds(collection, consumer, n);
        }
        return Endpoint.userStatusByIds.newRequest(params -> params.query(Util.MapBuilder.of(Users.UserStatusParams.class).add("ids", collection.stream().collect(Collectors.joining(","))).toMap(consumer))).process(this);
    }

    @Override
    public Many<StreamerStatus> liveStreamers() {
        return Endpoint.liveStreamers.newRequest(params -> {}).process(this);
    }

    @Override
    public One<Leaderboard> leaderboard(int n, Enums.PerfTypeNoCorr perfTypeNoCorr) {
        return Endpoint.usersLeaderboard.newRequest(params -> params.path(n, perfTypeNoCorr.name())).process(this);
    }

    @Override
    public Many<RatingHistory> ratingHistoryById(String string) {
        return Endpoint.ratingHistoryById.newRequest(params -> params.path(string)).process(this);
    }

    @Override
    public One<PerfStat> performanceStatisticsByIdAndType(String string, Enums.PerfType perfType) {
        return Endpoint.perfStatByIdAndType.newRequest(params -> params.path(string, perfType.name())).process(this);
    }

    private Many<UserStatus> autoSplittingStatusByIds(Collection<String> collection, Consumer<Users.UserStatusParams> consumer, int n2) {
        String[] stringArray = collection.toArray(new String[0]);
        int n4 = (int)Math.ceil((float)stringArray.length / (float)n2);
        Stream stream2 = Stream.iterate(0, n -> n + 1).limit(n4).map(n3 -> {
            if (n3 == n4) {
                return Arrays.stream(stringArray, n3 * n2, n3 * n2 + stringArray.length % n2);
            }
            return Arrays.stream(stringArray, n3 * n2, n3 * n2 + n2);
        }).map(stream -> stream.collect(Collectors.joining(","))).map(string -> Endpoint.userStatusByIds.newRequest(params -> params.query(Util.MapBuilder.of(Users.UserStatusParams.class).add("ids", string).toMap(consumer))).process(this)).flatMap(Many::stream);
        return Many.entries(stream2);
    }

    @Override
    public Many<String> autocompleteNames(String string) {
        return Endpoint.usersNamesAutocomplete.newRequest(params -> params.query(Map.of("term", string, "object", "false"))).process(this);
    }

    @Override
    public Many<LightUserWithStatus> autocompleteUsers(String string) {
        return Endpoint.usersStatusAutocomplete.newRequest(params -> params.query(Map.of("term", string, "object", "true"))).process(this);
    }
}

