/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.yayson;

import chariot.internal.yayson.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Lexer {
    public static List<Token> tokenize(String string) {
        Objects.requireNonNull(string);
        string = string.trim();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        while (string.length() > 0) {
            Token.TokenAndTail tokenAndTail = Token.lex(string);
            tokenAndTail.token().ifPresent(token -> arrayList.add((Token)token));
            string = tokenAndTail.tail();
        }
        return arrayList;
    }

    public static String detokenize(List<Token> list) {
        return list.stream().map(token -> {
            if (token instanceof Token.BeginArray) {
                Token.BeginArray beginArray = (Token.BeginArray)token;
                return String.valueOf(beginArray.c());
            }
            if (token instanceof Token.BeginObject) {
                Token.BeginObject beginObject = (Token.BeginObject)token;
                return String.valueOf(beginObject.c());
            }
            if (token instanceof Token.EndArray) {
                Token.EndArray endArray = (Token.EndArray)token;
                return String.valueOf(endArray.c());
            }
            if (token instanceof Token.EndObject) {
                Token.EndObject endObject = (Token.EndObject)token;
                return String.valueOf(endObject.c());
            }
            if (token instanceof Token.NameSeparator) {
                Token.NameSeparator nameSeparator = (Token.NameSeparator)token;
                return String.valueOf(nameSeparator.c());
            }
            if (token instanceof Token.ValueSeparator) {
                Token.ValueSeparator valueSeparator = (Token.ValueSeparator)token;
                return String.valueOf(valueSeparator.c());
            }
            if (token instanceof Token.False) {
                return "false";
            }
            if (token instanceof Token.True) {
                return "true";
            }
            if (token instanceof Token.Null) {
                return "null";
            }
            if (token instanceof Token.JsonNumber) {
                Token.JsonNumber jsonNumber = (Token.JsonNumber)token;
                return jsonNumber.string();
            }
            if (token instanceof Token.JsonString) {
                Token.JsonString jsonString = (Token.JsonString)token;
                return "\"" + jsonString.raw() + "\"";
            }
            return "<Unknown Token [%t]>".formatted(token);
        }).collect(Collectors.joining());
    }
}

