/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.yayson;

import chariot.internal.yayson.Lexer;
import chariot.internal.yayson.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Parser {
    static YayNode parse(List<Token> list) {
        if (list.isEmpty()) {
            return new YayNode.YayEmpty();
        }
        Token token = list.remove(0);
        if (token instanceof Token.BeginArray) {
            return Parser.parseArray(list);
        }
        if (token instanceof Token.BeginObject) {
            return Parser.parseObject(list);
        }
        if (token instanceof Token.False) {
            return new YayNode.YayValue.YayBool(false);
        }
        if (token instanceof Token.True) {
            return new YayNode.YayValue.YayBool(true);
        }
        if (token instanceof Token.Null) {
            return new YayNode.YayValue.YayNull();
        }
        if (token instanceof Token.JsonNumber) {
            Token.JsonNumber jsonNumber = (Token.JsonNumber)token;
            return new YayNode.YayValue.YayNumber(jsonNumber.number());
        }
        if (token instanceof Token.JsonString) {
            Token.JsonString jsonString = (Token.JsonString)token;
            return new YayNode.YayValue.YayString(jsonString.string());
        }
        return new YayNode.YayEmpty();
    }

    static YayNode.YayArray parseArray(List<Token> list) {
        Token token;
        YayNode.YayArray yayArray = new YayNode.YayArray(new ArrayList<YayNode>());
        if (list.get(0) instanceof Token.EndArray) {
            list.remove(0);
            return yayArray;
        }
        do {
            YayNode yayNode = Parser.parse(list);
            yayArray.value().add(yayNode);
            token = list.remove(0);
            if (!(token instanceof Token.EndArray)) continue;
            return yayArray;
        } while (token instanceof Token.ValueSeparator);
        throw new YayException("Expected comma in array");
    }

    static YayNode.YayObject parseObject(List<Token> list) {
        Token token;
        Token token2;
        YayNode.YayObject yayObject = new YayNode.YayObject(new HashMap<String, YayNode>());
        if (list.get(0) instanceof Token.EndObject) {
            list.remove(0);
            return yayObject;
        }
        do {
            if (!((token = list.remove(0)) instanceof Token.JsonString)) {
                throw new YayException("Expected the key, in the JSON key-value pair, to be a string - was [%s]".formatted(token));
            }
            Token.JsonString jsonString = (Token.JsonString)token;
            Token token3 = list.remove(0);
            if (!(token3 instanceof Token.NameSeparator)) {
                throw new YayException("Expected the colon between key-value pair - at key [%s]".formatted(token));
            }
            YayNode yayNode = Parser.parse(list);
            YayNode yayNode2 = yayObject.value().put(jsonString.string(), yayNode);
            if (yayNode2 != null) {
                System.out.println("Whaaat - prev!=null with prev " + String.valueOf(yayNode2));
            }
            if (list.isEmpty()) {
                System.out.println("\n\n\nFinished with [" + String.valueOf(token) + "] and now all tokens are gone...!?\n\n\n");
                return yayObject;
            }
            token2 = list.remove(0);
            if (!(token2 instanceof Token.EndObject)) continue;
            return yayObject;
        } while (token2 instanceof Token.ValueSeparator);
        throw new YayException("Expected comma after pair in object - at key [%s] - the token:%n%s%n".formatted(token, token2));
    }

    public static YayNode fromString(String string) {
        Objects.requireNonNull(string);
        string = string.trim();
        List<Token> list = Lexer.tokenize(string);
        YayNode yayNode = Parser.parse(list);
        return yayNode;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface YayNode {

        public static interface YayValue
        extends YayNode {

            public record YayNull() implements YayValue
            {
            }

            public record YayBool(boolean value) implements YayValue
            {
            }

            public record YayString(String value) implements YayValue
            {
            }

            public record YayNumber(Number value) implements YayValue
            {
            }
        }

        public record YayObject(Map<String, YayNode> value) implements YayNode
        {
            public String getString(String string) {
                YayNode yayNode = this.value().get(string);
                if (yayNode instanceof YayValue.YayString) {
                    YayValue.YayString yayString = (YayValue.YayString)yayNode;
                    return yayString.value();
                }
                return null;
            }

            public Number getNumber(String string) {
                YayNode yayNode = this.value().get(string);
                if (yayNode instanceof YayValue.YayNumber) {
                    YayValue.YayNumber yayNumber = (YayValue.YayNumber)yayNode;
                    return yayNumber.value();
                }
                return null;
            }

            public Integer getInteger(String string) {
                YayNode yayNode = this.value().get(string);
                if (yayNode instanceof YayValue.YayNumber) {
                    YayValue.YayNumber yayNumber = (YayValue.YayNumber)yayNode;
                    return yayNumber.value().intValue();
                }
                return null;
            }

            public Long getLong(String string) {
                YayNode yayNode = this.value().get(string);
                if (yayNode instanceof YayValue.YayNumber) {
                    YayValue.YayNumber yayNumber = (YayValue.YayNumber)yayNode;
                    return yayNumber.value().longValue();
                }
                return null;
            }

            public boolean getBool(String string) {
                YayNode yayNode = this.value().get(string);
                if (yayNode instanceof YayValue.YayBool) {
                    YayValue.YayBool yayBool = (YayValue.YayBool)yayNode;
                    return yayBool.value();
                }
                return false;
            }
        }

        public record YayArray(List<YayNode> value) implements YayNode
        {
        }

        public record YayEmpty() implements YayNode
        {
        }

        public record YayWithRaw(YayNode node, String raw) implements YayNode
        {
        }
    }

    public static class YayException
    extends RuntimeException {
        public YayException(String string) {
            super(string);
        }
    }
}

