/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.yayson;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Token {
    public static final Token BEGIN_OBJECT = new BeginObject('{');
    public static final Token END_OBJECT = new EndObject('}');
    public static final Token BEGIN_ARRAY = new BeginArray('[');
    public static final Token END_ARRAY = new EndArray(']');
    public static final Token NAME_SEPARATOR = new NameSeparator(':');
    public static final Token VALUE_SEPARATOR = new ValueSeparator(',');
    public static final Token FALSE = new False();
    public static final Token TRUE = new True();
    public static final Token NULL = new Null();

    default public int length() {
        return 1;
    }

    public static TokenAndTail lex(String string) {
        char c = string.charAt(0);
        try {
            Optional<Object> optional;
            switch (c) {
                case '[': {
                    Optional<Object> optional2 = Optional.of(BEGIN_ARRAY);
                    break;
                }
                case ']': {
                    Optional<Object> optional2 = Optional.of(END_ARRAY);
                    break;
                }
                case '{': {
                    Optional<Object> optional2 = Optional.of(BEGIN_OBJECT);
                    break;
                }
                case '}': {
                    Optional<Object> optional2 = Optional.of(END_OBJECT);
                    break;
                }
                case ':': {
                    Optional<Object> optional2 = Optional.of(NAME_SEPARATOR);
                    break;
                }
                case ',': {
                    Optional<Object> optional2 = Optional.of(VALUE_SEPARATOR);
                    break;
                }
                case 'f': 
                case 'n': 
                case 't': {
                    Optional<Object> optional2 = Token.lexLiteral(string);
                    break;
                }
                case '\"': {
                    Optional<Object> optional2 = Token.lexString(string);
                    break;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Optional<Object> optional2 = Token.lexNumber(string);
                    break;
                }
                default: {
                    Optional<Object> optional2 = optional = Optional.empty();
                }
            }
            if (optional.isPresent()) {
                TokenAndTail tokenAndTail = new TokenAndTail(optional, string.length() > ((Token)optional.get()).length() ? string.substring(((Token)optional.get()).length()).trim() : "");
                return tokenAndTail;
            }
            if (c == ' ' || c != '\n') {
                // empty if block
            }
            return new TokenAndTail(Optional.empty(), string.substring(1).trim());
        }
        catch (Exception exception) {
            return new TokenAndTail(Optional.empty(), string.length() > 1 ? string.substring(1).trim() : "");
        }
    }

    private static Optional<Token> lexLiteral(String string) {
        if (string.startsWith("true")) {
            return Optional.of(TRUE);
        }
        if (string.startsWith("false")) {
            return Optional.of(FALSE);
        }
        if (string.startsWith("null")) {
            return Optional.of(NULL);
        }
        return Optional.empty();
    }

    private static Optional<Token> lexString(String string) {
        int n = 1;
        try {
            while ((n = string.indexOf(34, n)) != -1) {
                if (string.charAt(n - 1) == '\\' && string.charAt(n - 2) != '\\') {
                    ++n;
                    continue;
                }
                String string2 = string.substring(1, n);
                JsonString jsonString = JsonString.decode(string2);
                return Optional.of(jsonString);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Couldn't find matching [\"], for json [" + string + "]");
        return Optional.empty();
    }

    private static Optional<Token> lexNumber(String string) {
        Long l;
        int n;
        List<Character> list = List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('e'), Character.valueOf('E'), Character.valueOf('.'));
        for (n = 0; n < string.length() - 1 && list.contains(Character.valueOf(string.charAt(n))); ++n) {
        }
        String string2 = string.substring(0, n);
        Number number = string2.contains(".") ? (Number)Float.valueOf(string2) : (Number)((l = Long.valueOf(string2)) >= 0L ? (Number)(l <= Integer.MAX_VALUE ? (Number)l.intValue() : (Number)l) : (Number)(l < Integer.MIN_VALUE ? (Number)l : (Number)l.intValue()));
        return Optional.of(new JsonNumber(string2, number));
    }

    public static String decodeUnicode(String string) throws Exception {
        int n;
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        for (n = 0; n < byArray.length; ++n) {
            byte by;
            byte by2 = byArray[n];
            if (by2 == 92 && n + 1 < byArray.length && (by = byArray[n + 1]) == 117) {
                byte by3 = byArray[n + 2];
                byte by4 = byArray[n + 3];
                byte by5 = byArray[n + 4];
                byte by6 = byArray[n + 5];
                char c = (char)by3;
                char c2 = (char)by4;
                char c3 = (char)by5;
                char c4 = (char)by6;
                String string2 = "" + c + c2 + c3 + c4;
                int n2 = Integer.parseInt(string2, 16);
                char[] cArray = Character.toChars(n2);
                String string3 = new String(cArray);
                byte[] byArray2 = string3.getBytes();
                for (int i = 0; i < byArray2.length; ++i) {
                    byteBuffer.put(byArray2[i]);
                }
                n += 5;
                continue;
            }
            byteBuffer.put(by2);
        }
        n = byteBuffer.position();
        return new String(byteBuffer.slice(0, n).array());
    }

    public record TokenAndTail(Optional<Token> token, String tail) {
    }

    public record JsonString(String string, String source) implements Token
    {
        public JsonString(String string) {
            this(string, string);
        }

        public static JsonString decode(String string) {
            if (string.contains("\\")) {
                try {
                    String string2 = string.replaceAll("\\\\/", "/");
                    String string3 = Token.decodeUnicode(string2);
                    String string4 = string3.translateEscapes();
                    return new JsonString(string4, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return new JsonString(string, string);
        }

        public String raw() {
            return this.source();
        }

        @Override
        public int length() {
            return this.source.length() + 2;
        }
    }

    public record JsonNumber(String string, Number number) implements Token
    {
        @Override
        public int length() {
            return this.string().length();
        }
    }

    public record BeginObject(char c) implements Token
    {
    }

    public record EndObject(char c) implements Token
    {
    }

    public record BeginArray(char c) implements Token
    {
    }

    public record EndArray(char c) implements Token
    {
    }

    public record NameSeparator(char c) implements Token
    {
    }

    public record ValueSeparator(char c) implements Token
    {
    }

    public record False() implements Token
    {
        @Override
        public int length() {
            return "false".length();
        }
    }

    public record True() implements Token
    {
        @Override
        public int length() {
            return "true".length();
        }
    }

    public record Null() implements Token
    {
        @Override
        public int length() {
            return "null".length();
        }
    }
}

