/*
 * Decompiled with CFR 0.152.
 */
package chariot.internal.yayson;

import chariot.internal.yayson.Parser;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class YayMapper {
    private final Config config;

    public static YayMapper mapper() {
        return YayMapper.mapper(new Config(false, new HashMap(), new HashMap()));
    }

    public static YayMapper mapper(Config config) {
        return new YayMapper(config);
    }

    private YayMapper(Config config) {
        this.config = config;
    }

    public void setMappings(Class<?> clazz, Map<String, String> map) {
        this.config.fieldMappings().put(clazz, map);
    }

    public void setCustomMapper(Class<?> clazz, Function<Parser.YayNode, ?> function) {
        this.config.customMappings().put(clazz, function);
    }

    public <T> T fromString(String string, Class<T> clazz) {
        Parser.YayNode yayNode = Parser.fromString(string);
        T t = this.fromYayTree(yayNode, clazz);
        return t;
    }

    public <T> T fromYayTree(Parser.YayNode yayNode, Class<T> clazz) {
        if (clazz.isInterface() && clazz.isSealed()) {
            return this.buildFromSealedInterface(yayNode, clazz, Optional.empty());
        }
        if (clazz.isRecord()) {
            if (this.config.customMappings().containsKey(clazz)) {
                Function<Parser.YayNode, ?> function = this.config.customMappings().get(clazz);
                return clazz.cast(function.apply(yayNode));
            }
            List<RecordComponent> list = Arrays.asList(clazz.getRecordComponents());
            if (yayNode instanceof Parser.YayNode.YayObject) {
                T t;
                Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                List<Object> list2 = list.stream().map(recordComponent -> {
                    ParameterizedType parameterizedType;
                    String string = this.config.fieldMappings().getOrDefault(clazz, Map.of()).getOrDefault(recordComponent.getName(), recordComponent.getName());
                    Optional<ParameterizedType> optional = Optional.empty();
                    Type type = recordComponent.getGenericType();
                    if (type instanceof ParameterizedType) {
                        parameterizedType = (ParameterizedType)type;
                        optional = Optional.of(parameterizedType);
                    }
                    parameterizedType = null;
                    try {
                        parameterizedType = recordComponent.getType().isInterface() && recordComponent.getType().isSealed() ? this.buildFromSealedInterface(yayObject.value().get(string), recordComponent.getType(), optional) : this.buildFromClass(yayObject.value().get(string), recordComponent.getType(), optional);
                    }
                    catch (Exception exception) {
                        System.out.println("Failure while looking for " + string + " of type " + String.valueOf(recordComponent.getType()) + " with (possibly) parameterized type " + String.valueOf(optional));
                        exception.printStackTrace();
                    }
                    return parameterizedType;
                }).toList();
                try {
                    Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                    Constructor constructor2 = constructorArray[0];
                    if (constructorArray.length > 1) {
                        List<Class> list3 = list.stream().map(RecordComponent::getType).toList();
                        constructor2 = Arrays.stream(constructorArray).filter(constructor -> Arrays.asList(constructor.getParameterTypes()).equals(list3)).findAny().orElseThrow();
                    }
                    t = clazz.cast(constructor2.newInstance(list2.toArray()));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                    exception.printStackTrace();
                    System.out.println(" ########  Instances: " + String.valueOf(list2));
                    System.out.println(" ========  node     : " + String.valueOf(yayNode));
                    t = null;
                }
                return t;
            }
        }
        return null;
    }

    private <T> T buildFromSealedInterface(Parser.YayNode yayNode, Class<T> clazz2, Optional<ParameterizedType> optional) {
        Optional<Class> optional2;
        Record record;
        if (yayNode instanceof Parser.YayNode.YayEmpty) {
            record = (Parser.YayNode.YayEmpty)yayNode;
            optional2 = Arrays.stream(clazz2.getPermittedSubclasses()).filter(clazz -> clazz.getRecordComponents().length == 0).findFirst();
            if (optional2.isPresent()) {
                Class clazz3 = (Class)optional2.get();
                T t = this.buildFromClass((Parser.YayNode)((Object)record), clazz3, optional);
                if (t != null) {
                    return clazz2.cast(t);
                }
                return null;
            }
        }
        if (!(yayNode instanceof Parser.YayNode.YayObject)) {
            return null;
        }
        record = (Parser.YayNode.YayObject)yayNode;
        optional2 = ((Parser.YayNode.YayObject)record).value().keySet();
        record ClassFieldMatches(Class<?> c, Long count) {
        }
        Optional<ClassFieldMatches> optional3 = Arrays.stream(clazz2.getPermittedSubclasses()).map(arg_0 -> this.lambda$buildFromSealedInterface$5((Set)((Object)optional2), arg_0)).max((classFieldMatches, classFieldMatches2) -> Long.compare(classFieldMatches.count(), classFieldMatches2.count()));
        Object var7_9 = null;
        if (optional3.isPresent()) {
            Class<?> clazz4 = optional3.get().c();
            if (this.config.customMappings().containsKey(clazz4)) {
                Function<Parser.YayNode, ?> function = this.config.customMappings().get(clazz4);
                var7_9 = function.apply(yayNode);
            } else {
                var7_9 = this.buildFromClass(yayNode, clazz4, optional);
            }
        } else {
            return null;
        }
        return clazz2.cast(var7_9);
    }

    private <T> T buildFromClass(Parser.YayNode yayNode, Class<T> clazz, Optional<ParameterizedType> optional) {
        if (clazz.isRecord()) {
            T t = this.fromYayTree(yayNode, clazz);
            return t;
        }
        if (clazz.equals(Optional.class)) {
            Object object;
            Type type;
            if (yayNode != null && (type = (object = optional.get()).getActualTypeArguments()[0]) instanceof Class) {
                Class clazz2 = (Class)type;
                T t = this.buildFromClass(yayNode, clazz2, Optional.empty());
                Optional<T> optional2 = Optional.ofNullable(t);
                return (T)optional2;
            }
            object = Optional.empty();
            return (T)object;
        }
        if (clazz.isArray()) {
            ParameterizedType parameterizedType;
            TypeDescriptor.OfField ofField = clazz.componentType();
            if (optional.isPresent()) {
                parameterizedType = optional.get();
                ofField = (Class)parameterizedType.getActualTypeArguments()[0];
            }
            parameterizedType = this.buildArray(yayNode, (Class<?>)ofField, clazz);
            return clazz.cast(parameterizedType);
        }
        if (List.class.isAssignableFrom(clazz)) {
            Object object;
            Class clazz3 = Object.class;
            if (optional.isPresent()) {
                object = optional.get();
                try {
                    clazz3 = (Class)object.getActualTypeArguments()[0];
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            object = this.buildList(yayNode, clazz3);
            return clazz.cast(object);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (yayNode instanceof Parser.YayNode.YayObject) {
                Parser.YayNode.YayObject yayObject = (Parser.YayNode.YayObject)yayNode;
                if (optional.isPresent()) {
                    Map<String, Object> map = yayObject.value().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
                        Class clazz = (Class)((ParameterizedType)optional.get()).getActualTypeArguments()[1];
                        if (clazz.isInterface() && clazz.isSealed()) {
                            return this.buildFromSealedInterface(yayNode, clazz, Optional.empty());
                        }
                        return this.buildFromClass((Parser.YayNode)entry.getValue(), clazz, Optional.empty());
                    }));
                    return clazz.cast(map);
                }
            }
            return clazz.cast(Map.of());
        }
        if (clazz.isEnum()) {
            if (yayNode instanceof Parser.YayNode.YayValue.YayString) {
                Parser.YayNode.YayValue.YayString yayString = (Parser.YayNode.YayValue.YayString)yayNode;
                try {
                    MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "valueOf", MethodType.methodType(clazz, String.class));
                    Object object = methodHandle.invoke(yayString.value());
                    return clazz.cast(object);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else if (yayNode instanceof Parser.YayNode.YayValue.YayNumber) {
                Parser.YayNode.YayValue.YayNumber yayNumber = (Parser.YayNode.YayValue.YayNumber)yayNode;
                try {
                    MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "valueOf", MethodType.methodType(clazz, Integer.TYPE));
                    Object object = methodHandle.invoke(yayNumber.value().intValue());
                    return clazz.cast(object);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return null;
        }
        T t = this.buildFromPrimitive(yayNode, clazz);
        return t;
    }

    private <T> T buildArray(Parser.YayNode yayNode, Class<?> clazz, Class<T> clazz2) {
        List<?> list = this.buildList(yayNode, clazz);
        int n = list.size();
        Object object = Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, list.get(i));
        }
        return clazz2.cast(object);
    }

    private <T> List<T> buildList(Parser.YayNode yayNode2, Class<? extends T> clazz) {
        ArrayList arrayList = new ArrayList();
        if (yayNode2 instanceof Parser.YayNode.YayArray) {
            Parser.YayNode.YayArray yayArray = (Parser.YayNode.YayArray)yayNode2;
            yayArray.value().stream().forEach(yayNode -> {
                if (clazz.isInterface() && clazz.isSealed()) {
                    Object t = this.buildFromSealedInterface((Parser.YayNode)yayNode, clazz, Optional.empty());
                    arrayList.add(clazz.cast(t));
                } else {
                    Object t = this.buildFromClass((Parser.YayNode)yayNode, clazz, Optional.empty());
                    arrayList.add(t);
                }
            });
        }
        return arrayList;
    }

    private <T> T buildFromPrimitive(Parser.YayNode yayNode, Class<T> clazz) {
        Object object;
        Parser.YayNode.YayValue yayValue;
        if (yayNode instanceof Parser.YayNode.YayValue) {
            yayValue = (Parser.YayNode.YayValue)yayNode;
            if (yayValue instanceof Parser.YayNode.YayValue.YayNumber) {
                Parser.YayNode.YayValue.YayNumber yayNumber = (Parser.YayNode.YayValue.YayNumber)yayValue;
                Number number = yayNumber.value();
                object = clazz == Short.class ? (Number)number.shortValue() : (Number)(clazz == Integer.class ? (Number)number.intValue() : (Number)(clazz == Long.class ? (Number)number.longValue() : (Number)(clazz == Float.class ? (Number)Float.valueOf(number.floatValue()) : (Number)(clazz == Double.class ? (Number)number.doubleValue() : (Number)number))));
            } else if (yayValue instanceof Parser.YayNode.YayValue.YayString) {
                Parser.YayNode.YayValue.YayString yayString = (Parser.YayNode.YayValue.YayString)yayValue;
                object = yayString.value();
            } else if (yayValue instanceof Parser.YayNode.YayValue.YayBool) {
                Parser.YayNode.YayValue.YayBool yayBool = (Parser.YayNode.YayValue.YayBool)yayValue;
                object = yayBool.value();
            } else if (yayValue instanceof Parser.YayNode.YayValue.YayNull) {
                Parser.YayNode.YayValue.YayNull yayNull = (Parser.YayNode.YayValue.YayNull)yayValue;
                object = null;
            } else {
                object = null;
            }
        } else {
            object = clazz.isPrimitive() ? (clazz == Boolean.TYPE ? Boolean.valueOf(false) : (clazz == Character.TYPE ? (Serializable)Character.valueOf('\u0000') : (Serializable)(clazz == Byte.TYPE ? (Number)((byte)0) : (Number)(clazz == Short.TYPE ? (Number)((short)0) : (Number)(clazz == Integer.TYPE ? (Number)0 : (Number)(clazz == Long.TYPE ? (Number)0L : (Number)(clazz == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(clazz == Double.TYPE ? Double.valueOf(0.0) : null)))))))) : null;
        }
        if (object != null) {
            if (clazz.isPrimitive()) {
                return (T)object;
            }
            yayValue = clazz.cast(object);
            return (T)yayValue;
        }
        return null;
    }

    private /* synthetic */ 1ClassFieldMatches lambda$buildFromSealedInterface$5(Set set, Class clazz) {
        return new ClassFieldMatches(clazz, Arrays.stream(clazz.getRecordComponents()).map(recordComponent -> recordComponent.getName()).map(string -> this.config.fieldMappings().getOrDefault(clazz, Map.of()).getOrDefault(string, (String)string)).filter(set::contains).collect(Collectors.counting()));
    }

    public record Config(boolean raw, Map<Class<?>, Map<String, String>> fieldMappings, Map<Class<?>, Function<Parser.YayNode, ?>> customMappings) {
    }
}

