/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import chariot.model.Enums;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;

public record Activity(Interval interval, Set<Type> activities) {

    public record Interval(ZonedDateTime start, ZonedDateTime end) {
    }

    public record Simul(String id, String name, boolean isHost, List<Enums.VariantName> variants, Score score) {

        public record Score(int win, int loss, int draw) {
        }
    }

    public record Topic(String topicUrl, String topicName, List<Post> posts) {

        public record Post(String url, String text) {
        }
    }

    public record Team(String url, String name) {
    }

    public record Game(String id, Enums.Color color, String url, String variant, String speed, String perf, Boolean rated, Opponent opponent) {
        public Game {
            string3 = Util.orEmpty(string3);
            string4 = Util.orEmpty(string4);
            string5 = Util.orEmpty(string5);
        }

        public record Opponent(String user, Integer rating) {
        }
    }

    public record Practice(String url, String name, Integer nbPositions) {
    }

    public record Tournament(Info tournament, Integer nbGames, Integer score, Integer rank, Integer rankPercent) {

        public record Info(String id, String name) {
        }
    }

    public record Result(String name, Integer win, Integer loss, Integer draw, RP rp) {

        public record RP(Integer before, Integer after) {
        }

        public record ResultHelper(Integer win, Integer loss, Integer draw, RP rp) {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Type {

        public record Unknown(String name, String raw) implements Type
        {
        }

        public record Simuls(List<Simul> simuls) implements Type
        {
        }

        public record Posts(List<Topic> topics) implements Type
        {
        }

        public record Patron(int months) implements Type
        {
        }

        public record Teams(List<Team> teams) implements Type
        {
        }

        public record Follows(List<String> inIds, List<String> outIds) implements Type
        {
        }

        public record CorrespondenceEnds(Result score, List<Game> games) implements Type
        {
        }

        public record CorrespondenceMoves(Integer nb, List<Game> games) implements Type
        {
        }

        public record Practices(List<Practice> practises) implements Type
        {
        }

        public record Tournaments(Integer nb, List<Tournament> best) implements Type
        {
        }

        public record Puzzles(Result score) implements Type
        {
        }

        public record Games(List<Result> result) implements Type
        {
        }
    }
}

