/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import chariot.model.Enums;
import java.util.List;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Arena {
    public String id();

    public String createdBy();

    public String startsAt();

    public String system();

    public String fullName();

    public Integer minutes();

    public Perf perf();

    public Clock clock();

    public Enums.VariantName variant();

    public boolean rated();

    public boolean berserkable();

    public Verdict verdicts();

    public Integer nbPlayers();

    public List<Duel> duels();

    public Standing standing();

    public record TeamBattle(Map<String, String> teams, Integer nbLeaders) {
    }

    public record DuelTeams() {
    }

    public record TeamStanding(Integer rank, String id, Integer score, List<Player> players) {

        public record Player(User user, Integer score) {

            public record User(String name, String id) {
            }
        }
    }

    public record Perf(String icon, String key, String name) {
    }

    public record Clock(Integer increment, Integer limit) {
    }

    public record Verdict(List<Condition> list, boolean accepted) {

        public record Condition(String condition, String verdict) {
        }
    }

    public record GreatPlayer(String name, String url) {
    }

    public record Standing(Integer page, List<Player> players) {

        public record Player(String name, Integer rank, Integer rating, Integer score, Sheet sheet, String team, boolean withdraw) {
            public Player {
                string2 = Util.orEmpty(string2);
            }
        }
    }

    public record Duel(String id, List<P> p) {

        public record P(String n, Integer r, Integer k) {
        }
    }

    public record Sheet(String scores, boolean fire) {
    }

    public record TeamFinished(String id, String createdBy, String startsAt, String system, String fullName, Integer minutes, Perf perf, Clock clock, Enums.VariantName variant, boolean rated, boolean berserkable, Verdict verdicts, Integer nbPlayers, List<Duel> duels, Standing standing, boolean isFinished, boolean isRecentlyFinished, boolean pairingsClosed, List<Podium> podium, Stats stats, List<TeamStanding> teamStanding, DuelTeams duelTeams, TeamBattle teamBattle) implements Arena
    {

        public record Stats(Integer games, Integer moves, Integer whiteWins, Integer blackWins, Integer draws, Integer berserks, Integer averageRating) {
        }

        public record Podium(String name, Integer rank, Integer rating, Integer score, Sheet sheet, String team, NB nb, Integer performance) {
            public Podium {
                string2 = Util.orEmpty(string2);
            }

            public record NB(Integer game, Integer berserk, Integer win) {
            }
        }
    }

    public record TeamOngoing(String id, String createdBy, String startsAt, String system, String fullName, Integer minutes, Perf perf, Clock clock, Enums.VariantName variant, boolean rated, boolean berserkable, Verdict verdicts, Integer nbPlayers, List<Duel> duels, Standing standing, boolean isStarted, Integer secondsToFinish, Featured featured, List<TeamStanding> teamStanding, DuelTeams duelTeams, TeamBattle teamBattle) implements Arena
    {

        public record Featured(String id, String fen, String orientation, String color, String lastMove, Player white, Player black, String winner) {

            public record Player(int rank, String name, int rating) {
            }
        }
    }

    public record TeamUpcoming(String id, String createdBy, String startsAt, String system, String fullName, Integer minutes, Perf perf, Clock clock, Enums.VariantName variant, boolean rated, boolean berserkable, Verdict verdicts, Integer nbPlayers, List<Duel> duels, Standing standing, Integer secondsToStart, GreatPlayer greatPlayer, List<TeamStanding> teamStanding, DuelTeams duelTeams, TeamBattle teamBattle) implements Arena
    {
    }

    public record Finished(String id, String createdBy, String startsAt, String system, String fullName, Integer minutes, Perf perf, Clock clock, Enums.VariantName variant, boolean rated, boolean berserkable, Verdict verdicts, Integer nbPlayers, List<Duel> duels, Standing standing, boolean isFinished, boolean isRecentlyFinished, boolean pairingsClosed, List<Podium> podium, Stats stats) implements Arena
    {

        public record Stats(Integer games, Integer moves, Integer whiteWins, Integer blackWins, Integer draws, Integer berserks, Integer averageRating) {
        }

        public record Podium(String name, Integer rank, Integer rating, Integer score, Sheet sheet, String team, NB nb, Integer performance) {
            public Podium {
                string2 = Util.orEmpty(string2);
            }

            public record NB(Integer game, Integer berserk, Integer win) {
            }
        }
    }

    public record Ongoing(String id, String createdBy, String startsAt, String system, String fullName, Integer minutes, Perf perf, Clock clock, Enums.VariantName variant, boolean rated, boolean berserkable, Verdict verdicts, Integer nbPlayers, List<Duel> duels, Standing standing, boolean isStarted, Integer secondsToFinish, Featured featured) implements Arena
    {

        public record Featured(String id, String fen, String orientation, Enums.Color color, String lastMove, Player white, Player black, String winner) {

            public record Player(int rank, String name, int rating) {
            }
        }
    }

    public record Upcoming(String id, String createdBy, String startsAt, String system, String fullName, Integer minutes, Perf perf, Clock clock, Enums.VariantName variant, boolean rated, boolean berserkable, Verdict verdicts, Integer nbPlayers, List<Duel> duels, Standing standing, Integer secondsToStart, GreatPlayer greatPlayer) implements Arena
    {
    }
}

