/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

public interface Enums {

    public static enum PerfTypeWithFromPos {
        antichess,
        atomic,
        blitz,
        bullet,
        chess960,
        classical,
        correspondence,
        crazyhouse,
        horde,
        kingOfTheHill,
        racingKings,
        rapid,
        threeCheck,
        ultraBullet,
        fromPosition;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public PerfTypeWithFromPos atomic() {
                return atomic;
            }

            default public PerfTypeWithFromPos antichess() {
                return antichess;
            }

            default public PerfTypeWithFromPos blitz() {
                return blitz;
            }

            default public PerfTypeWithFromPos bullet() {
                return bullet;
            }

            default public PerfTypeWithFromPos chess960() {
                return chess960;
            }

            default public PerfTypeWithFromPos classical() {
                return classical;
            }

            default public PerfTypeWithFromPos correspondence() {
                return correspondence;
            }

            default public PerfTypeWithFromPos crazyhouse() {
                return crazyhouse;
            }

            default public PerfTypeWithFromPos horde() {
                return horde;
            }

            default public PerfTypeWithFromPos kingOfTheHill() {
                return kingOfTheHill;
            }

            default public PerfTypeWithFromPos racingKings() {
                return racingKings;
            }

            default public PerfTypeWithFromPos rapid() {
                return rapid;
            }

            default public PerfTypeWithFromPos threeCheck() {
                return threeCheck;
            }

            default public PerfTypeWithFromPos ultraBullet() {
                return ultraBullet;
            }
        }
    }

    public static enum PerfTypeNoCorr {
        antichess,
        atomic,
        blitz,
        bullet,
        chess960,
        classical,
        crazyhouse,
        horde,
        kingOfTheHill,
        racingKings,
        rapid,
        threeCheck,
        ultraBullet;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public PerfTypeNoCorr atomic() {
                return atomic;
            }

            default public PerfTypeNoCorr antichess() {
                return antichess;
            }

            default public PerfTypeNoCorr blitz() {
                return blitz;
            }

            default public PerfTypeNoCorr bullet() {
                return bullet;
            }

            default public PerfTypeNoCorr chess960() {
                return chess960;
            }

            default public PerfTypeNoCorr classical() {
                return classical;
            }

            default public PerfTypeNoCorr crazyhouse() {
                return crazyhouse;
            }

            default public PerfTypeNoCorr horde() {
                return horde;
            }

            default public PerfTypeNoCorr kingOfTheHill() {
                return kingOfTheHill;
            }

            default public PerfTypeNoCorr racingKings() {
                return racingKings;
            }

            default public PerfTypeNoCorr rapid() {
                return rapid;
            }

            default public PerfTypeNoCorr threeCheck() {
                return threeCheck;
            }

            default public PerfTypeNoCorr ultraBullet() {
                return ultraBullet;
            }
        }
    }

    public static enum PerfType {
        antichess,
        atomic,
        blitz,
        bullet,
        chess960,
        classical,
        correspondence,
        crazyhouse,
        horde,
        kingOfTheHill,
        racingKings,
        rapid,
        threeCheck,
        ultraBullet;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public PerfType atomic() {
                return atomic;
            }

            default public PerfType antichess() {
                return antichess;
            }

            default public PerfType blitz() {
                return blitz;
            }

            default public PerfType bullet() {
                return bullet;
            }

            default public PerfType chess960() {
                return chess960;
            }

            default public PerfType classical() {
                return classical;
            }

            default public PerfType correspondence() {
                return correspondence;
            }

            default public PerfType crazyhouse() {
                return crazyhouse;
            }

            default public PerfType horde() {
                return horde;
            }

            default public PerfType kingOfTheHill() {
                return kingOfTheHill;
            }

            default public PerfType racingKings() {
                return racingKings;
            }

            default public PerfType rapid() {
                return rapid;
            }

            default public PerfType threeCheck() {
                return threeCheck;
            }

            default public PerfType ultraBullet() {
                return ultraBullet;
            }
        }
    }

    public static enum Channel {
        bot,
        blitz,
        racingKings,
        ultraBullet,
        bullet,
        classical,
        threeCheck,
        antichess,
        computer,
        horde,
        rapid,
        atomic,
        crazyhouse,
        chess960,
        kingOfTheHill,
        topRated;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public Channel bot() {
                return bot;
            }

            default public Channel blitz() {
                return blitz;
            }

            default public Channel racingKings() {
                return racingKings;
            }

            default public Channel ultraBullet() {
                return ultraBullet;
            }

            default public Channel bullet() {
                return bullet;
            }

            default public Channel classical() {
                return classical;
            }

            default public Channel threeCheck() {
                return threeCheck;
            }

            default public Channel antichess() {
                return antichess;
            }

            default public Channel computer() {
                return computer;
            }

            default public Channel horde() {
                return horde;
            }

            default public Channel rapid() {
                return rapid;
            }

            default public Channel atomic() {
                return atomic;
            }

            default public Channel crazyhouse() {
                return crazyhouse;
            }

            default public Channel chess960() {
                return chess960;
            }

            default public Channel kingOfTheHill() {
                return kingOfTheHill;
            }

            default public Channel topRated() {
                return topRated;
            }
        }
    }

    public static enum DeclineReason {
        generic,
        later,
        tooFast,
        tooSlow,
        timeControl,
        rated,
        casual,
        standard,
        variant,
        noBot,
        onlyBot;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public DeclineReason generic() {
                return generic;
            }

            default public DeclineReason later() {
                return later;
            }

            default public DeclineReason tooFast() {
                return tooFast;
            }

            default public DeclineReason tooSlow() {
                return tooSlow;
            }

            default public DeclineReason timeControl() {
                return timeControl;
            }

            default public DeclineReason rated() {
                return rated;
            }

            default public DeclineReason casual() {
                return casual;
            }

            default public DeclineReason standard() {
                return standard;
            }

            default public DeclineReason variant() {
                return variant;
            }

            default public DeclineReason noBot() {
                return noBot;
            }

            default public DeclineReason onlyBot() {
                return onlyBot;
            }
        }
    }

    public static enum ChatFor {
        none(0),
        onlyTeamLeaders(10),
        onlyTeamMembers(20),
        allLichessPlayers(30);

        public final int id;

        private ChatFor(int n2) {
            this.id = n2;
        }

        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public ChatFor none() {
                return none;
            }

            default public ChatFor onlyTeamLeaders() {
                return onlyTeamLeaders;
            }

            default public ChatFor onlyTeamMembers() {
                return onlyTeamMembers;
            }

            default public ChatFor allLichessPlayers() {
                return allLichessPlayers;
            }
        }
    }

    public static enum GameVariant {
        standard,
        chess960,
        crazyhouse,
        antichess,
        atomic,
        horde,
        kingOfTheHill,
        racingKings,
        threeCheck,
        fromPosition;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public GameVariant standard() {
                return standard;
            }

            default public GameVariant chess960() {
                return chess960;
            }

            default public GameVariant crazyhouse() {
                return crazyhouse;
            }

            default public GameVariant antichess() {
                return antichess;
            }

            default public GameVariant atomic() {
                return atomic;
            }

            default public GameVariant horde() {
                return horde;
            }

            default public GameVariant kingOfTheHill() {
                return kingOfTheHill;
            }

            default public GameVariant racingKings() {
                return racingKings;
            }

            default public GameVariant threeCheck() {
                return threeCheck;
            }

            default public GameVariant fromPosition() {
                return fromPosition;
            }
        }
    }

    public static enum VariantName {
        standard,
        chess960,
        crazyhouse,
        antichess,
        atomic,
        horde,
        kingOfTheHill,
        racingKings,
        threeCheck;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public VariantName standard() {
                return standard;
            }

            default public VariantName chess960() {
                return chess960;
            }

            default public VariantName crazyhouse() {
                return crazyhouse;
            }

            default public VariantName antichess() {
                return antichess;
            }

            default public VariantName atomic() {
                return atomic;
            }

            default public VariantName horde() {
                return horde;
            }

            default public VariantName kingOfTheHill() {
                return kingOfTheHill;
            }

            default public VariantName racingKings() {
                return racingKings;
            }

            default public VariantName threeCheck() {
                return threeCheck;
            }
        }
    }

    public static enum RatingGroup {
        _600,
        _1000,
        _1200,
        _1400,
        _1600,
        _1800,
        _2000,
        _2200,
        _2500;


        public String asString() {
            return this.name().substring(1);
        }

        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public RatingGroup _600() {
                return _600;
            }

            default public RatingGroup _1000() {
                return _1000;
            }

            default public RatingGroup _1200() {
                return _1200;
            }

            default public RatingGroup _1400() {
                return _1400;
            }

            default public RatingGroup _1600() {
                return _1600;
            }

            default public RatingGroup _1800() {
                return _1800;
            }

            default public RatingGroup _2000() {
                return _2000;
            }

            default public RatingGroup _2200() {
                return _2200;
            }

            default public RatingGroup _2500() {
                return _2500;
            }
        }
    }

    public static enum Speed {
        ultraBullet,
        bullet,
        blitz,
        rapid,
        classical,
        correspondence;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public Speed ultraBullet() {
                return ultraBullet;
            }

            default public Speed bullet() {
                return bullet;
            }

            default public Speed blitz() {
                return blitz;
            }

            default public Speed rapid() {
                return rapid;
            }

            default public Speed classical() {
                return classical;
            }

            default public Speed correspondence() {
                return correspondence;
            }
        }
    }

    public static enum TournamentState {
        created(10),
        started(20),
        finished(30);

        final int status;

        private TournamentState(int n2) {
            this.status = n2;
        }

        public int status() {
            return this.status;
        }

        public static TournamentState valueOf(int n) {
            return switch (n) {
                case 10 -> created;
                case 20 -> started;
                case 30 -> finished;
                default -> throw new IllegalArgumentException("Unknown tournament status: " + n);
            };
        }

        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public TournamentState created() {
                return created;
            }

            default public TournamentState started() {
                return started;
            }

            default public TournamentState finished() {
                return finished;
            }
        }
    }

    public static enum Room {
        player,
        spectator;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public Room player() {
                return player;
            }

            default public Room spectator() {
                return spectator;
            }
        }
    }

    public static enum Direction {
        in,
        out;

    }

    public static enum Offer {
        yes,
        no;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public Offer yes() {
                return yes;
            }

            default public Offer no() {
                return no;
            }
        }
    }

    public static enum Color {
        white,
        black;


        public Color other() {
            return this == white ? black : white;
        }

        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public Color white() {
                return white;
            }

            default public Color black() {
                return black;
            }
        }
    }

    public static enum ColorPref {
        random,
        white,
        black;


        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public ColorPref random() {
                return random;
            }

            default public ColorPref white() {
                return white;
            }

            default public ColorPref black() {
                return black;
            }
        }
    }

    public static enum Level {
        _1(1),
        _2(2),
        _3(3),
        _4(4),
        _5(5),
        _6(6),
        _7(7),
        _8(8);

        public final int level;

        private Level(int n2) {
            this.level = n2;
        }

        public static Provider provider() {
            return new Provider(){};
        }

        public static interface Provider {
            default public Level one() {
                return _1;
            }

            default public Level two() {
                return _2;
            }

            default public Level three() {
                return _3;
            }

            default public Level four() {
                return _4;
            }

            default public Level five() {
                return _5;
            }

            default public Level six() {
                return _6;
            }

            default public Level seven() {
                return _7;
            }

            default public Level eight() {
                return _8;
            }
        }
    }
}

