/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.model.Challenge;
import chariot.model.Enums;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Event {
    public Type type();

    default public String id() {
        Event event = this;
        if (event instanceof GameEvent) {
            GameEvent gameEvent = (GameEvent)event;
            return gameEvent.game().gameId();
        }
        event = this;
        if (event instanceof ChallengeEvent) {
            ChallengeEvent challengeEvent = (ChallengeEvent)event;
            return challengeEvent.challenge().id();
        }
        throw new RuntimeException("Unknown event: " + String.valueOf(this));
    }

    public record GameEvent(Type type, GameInfo game) implements Event
    {

        public record GameInfo(String fullId, String gameId, String fen, Enums.Color color, String lastMove, Variant variant, Enums.Speed speed, Enums.PerfTypeWithFromPos perf, boolean rated, boolean hasMoved, Opponent opponent, boolean isMyTurn, int secondsLeft, Optional<String> tournamentId, Optional<String> swissId, String source, Compat compat) {
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface Opponent {

            public record AI(String id, String username, Integer ai) implements Opponent
            {
            }

            public record User(String id, String username, Integer rating) implements Opponent
            {
            }
        }

        public record Variant(Enums.GameVariant key, String name) {
        }
    }

    public record ChallengeEvent(Type type, Challenge challenge, Compat compat) implements Event
    {
    }

    public record Compat(boolean bot, boolean board) {
    }

    public static enum Type {
        gameStart,
        gameFinish,
        challenge,
        challengeCanceled,
        challengeDeclined;

    }
}

