/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.model.Enums;
import java.util.List;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ExploreResult {

    public record ERStats(String month, int black, int draws, int white) {
    }

    public record HistoryStats(List<ERStats> history, EROpening opening) {
    }

    public record EROpening(String eco, String name) {
    }

    public record ERPlayer(String name, Integer rating) {
    }

    public record PlayerGame(String uci, String id, Optional<Enums.Color> winner, String speed, String mode, ERPlayer white, ERPlayer black, int year, String month) {
    }

    public record PlayerMove(String uci, String san, int white, int draws, int black, int averageOpponentRating, int performance, Optional<PlayerGame> game) {
    }

    public record DBGame(String uci, String id, Optional<Enums.Color> winner, ERPlayer white, ERPlayer black, int year, String month) {
    }

    public record DBMove(String uci, String san, int white, int draws, int black, int averageRating, Optional<DBGame> game) {
    }

    public record OpeningPlayer(int white, int draws, int black, List<PlayerMove> moves, List<PlayerGame> topGames, List<PlayerGame> recentGames, Optional<EROpening> opening) implements ExploreResult
    {
    }

    public record OpeningDB(int white, int draws, int black, List<DBMove> moves, List<DBGame> topGames, List<DBGame> recentGames, Optional<EROpening> opening) implements ExploreResult
    {
    }
}

