/*
 * Decompiled with CFR 0.152.
 */
package chariot.model;

import chariot.internal.Util;
import chariot.model.Enums;
import chariot.model.Player;
import java.time.ZonedDateTime;
import java.util.List;

public record Game(String id, boolean rated, Enums.GameVariant variant, String speed, String perf, long createdTime, long lastMoveTime, Status status, Players players, String moves, String initialFen, String lastFen, String pgn, String tournament, String swiss, Integer daysPerTurn, Enums.Color winner, Opening opening, Clock clock, List<Integer> clocks, List<AnalysisEntry> analysis) {
    public Game {
        string4 = Util.orEmpty(string4);
        string5 = Util.orEmpty(string5);
        string6 = Util.orEmpty(string6);
        string7 = Util.orEmpty(string7);
        string8 = Util.orEmpty(string8);
        string9 = Util.orEmpty(string9);
        n = n == null ? 0 : n;
    }

    public ZonedDateTime createdAt() {
        return Util.fromLong(this.createdTime());
    }

    public ZonedDateTime lastMoveAt() {
        return Util.fromLong(this.lastMoveTime());
    }

    public static enum Status {
        created,
        started,
        aborted,
        mate,
        resign,
        stalemate,
        timeout,
        draw,
        outoftime,
        cheat,
        noStart,
        unknownFinish,
        variantEnd;

    }

    public record Players(Player white, Player black) {
    }

    public record Opening(String eco, String name, Integer ply) {
    }

    public record Clock(int initial, int increment, int totalTime) {
    }

    public static enum Severity {
        Inaccuracy,
        Mistake,
        Blunder;

    }

    public record Judgment(Severity name, String comment) {
    }

    public record AnnotatedEval(int eval, String best, String variation, Judgment judgment) implements AnalysisEntry
    {
    }

    public record ForcedMate(int mate) implements AnalysisEntry
    {
    }

    public record Eval(int eval) implements AnalysisEntry
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface AnalysisEntry {
    }
}

